(function ($) {
    "use strict";
    
    // Dropdown on mouse hover
    $(document).ready(function () {
        function toggleNavbarMethod() {
            if ($(window).width() > 992) {
                $('.navbar .dropdown').on('mouseover', function () {
                    $('.dropdown-toggle', this).trigger('click');
                }).on('mouseout', function () {
                    $('.dropdown-toggle', this).trigger('click').blur();
                });
            } else {
                $('.navbar .dropdown').off('mouseover').off('mouseout');
            }
        }
        toggleNavbarMethod();
        $(window).resize(toggleNavbarMethod);
    });
	
	//required formular contact
	$("input[required], textarea[required], select[required]").attr("oninvalid", "this.setCustomValidity('Va rugam completati campul!')");
    $("input[required], textarea[required], select[required]").attr("oninput", "setCustomValidity('')");
	//end required formular contact
	
	//floating label input, textarea formular contact
	//clasa .floating poate fi inlocuita direct cu label daca de acesta nu este nevoie niciunde altundeva in site 
	$(function(){
	  var onClass = "on";
	  var showClass = "show";
	  
	  $("input , textarea").bind("checkval",function(){
		var label = $(this).prev(".floating");
		if(this.value !== ""){
		  label.addClass(showClass);
		} else {
		  label.removeClass(showClass);
		}
	   }).on("keyup",function(){
		$(this).trigger("checkval");
	   }).on("focus",function(){
		$(this).prev(".floating").addClass(onClass);
		}).on("blur",function(){
		  $(this).prev(".floating").removeClass(onClass);
		}).trigger("checkval");
	});
	//end floating label input, textarea formular contact


    // Date and time picker
    $('.date').datetimepicker({
        format: 'L'
    });
    $('.time').datetimepicker({
        format: 'LT'
    });
    
    
    // Back to top button
    $(window).scroll(function () {
        if ($(this).scrollTop() > 100) {
            $('.back-to-top').fadeIn('slow');
        } else {
            $('.back-to-top').fadeOut('slow');
        }
    });
    $('.back-to-top').click(function () {
        $('html, body').animate({scrollTop: 0}, 1500, 'easeInOutExpo');
        return false;
    });


    // Portfolio isotope and filter
    var portfolioIsotope = $('.portfolio-container').isotope({
        itemSelector: '.portfolio-item',
        layoutMode: 'fitRows'
    });
    $('#portfolio-flters li').on('click', function () {
        $("#portfolio-flters li").removeClass('active');
        $(this).addClass('active');

        portfolioIsotope.isotope({filter: $(this).data('filter')});
    });


    // Testimonials carousel
    $(".testimonial-carousel").owlCarousel({
        autoplay: true,
        smartSpeed: 1000,
        items: 1,
        dots: false,
        loop: true,
    });
    
})(jQuery);

