<?php
Class sectiune_model extends CI_Model
{
	function __construct()
	{
			parent::__construct();
	}
	
	/********************************************************************
	sectiune functions
	********************************************************************/
	function get_sectiuni($parent = 0)
	{
		$this->db->order_by('sequence', 'ASC');
		$this->db->where('parent_id', $parent);
		$result = $this->db->get('sectiuni')->result();
		
		$return	= array();
		foreach($result as $sectiune)
		{
			$return[$sectiune->id]				= $sectiune;
			$return[$sectiune->id]->children	= $this->get_sectiuni($sectiune->id);
		}
		
		return $return;
	}
	
		
	
	function get_sectiuni_multilingv($parent = 0,$lang_id)
	{
		$this->db->order_by('sequence', 'ASC');
		$this->db->where('parent_id', $parent);
		$this->db->where('lang_id', $lang_id);
		$result = $this->db->get('sectiuni')->result();
		
		$return	= array();
		foreach($result as $sectiune)
		{
			$return[$sectiune->id]				= $sectiune;
			$return[$sectiune->id]->children	= $this->get_sectiuni_child_multilingv($sectiune->id,$lang_id);
		}
		
		return $return;
	}
	
	function get_sectiuni_child_multilingv($parent = 0,$lang_id)
	{
		$this->db->order_by('id', 'DESC');
		$this->db->where('parent_id', $parent);
		$this->db->where('lang_id', $lang_id);
		$result = $this->db->get('sectiuni')->result();
		
		$return	= array();
		foreach($result as $sectiune)
		{
			$return[$sectiune->id]				= $sectiune;
			$return[$sectiune->id]->children	= $this->get_sectiuni_child_multilingv($sectiune->id,$lang_id);
		}
		
		return $return;
	}
	
	function get_sectiuni_solutii($parent = 0)
	{
		$this->db->order_by('sequence', 'ASC');
		$this->db->select('sectiuni.id,sectiuni.menu_title, sectiuni.url, sectiuni.new_window, sectiuni.slug');
		$this->db->where('parent_id', $parent);
		$result = $this->db->get('sectiuni')->result();
		
		$return	= array();
		foreach($result as $sectiune)
		{
			$return[$sectiune->id]				= $sectiune;
			$return[$sectiune->id]->children	= $this->get_sectiuni($sectiune->id);
		}
		
		return $return;
	}
	
	function get_subcategorii($parent_id)
	{
	$this->db->select('*');
	$this->db->from('sectiuni');
	$this->db->where('sectiuni.parent_id',$parent_id);
	$this->db->order_by("sequence", "ASC");
	
	$query = $this->db->get();
	return $query ->result_array();
	}
	
	function get_sectiuni_links($parent = 0)
	{
		$this->db->order_by('sequence', 'ASC');
		$this->db->select('sectiuni.id,sectiuni.menu_title, sectiuni.url, sectiuni.new_window, sectiuni.slug');
		$this->db->where('parent_id', $parent);
		$query = $this->db->get('sectiuni');
		return $query ->result_array();
	}
	
	function get_sectiune($id)
	{
		$this->db->where('id', $id);
		$result = $this->db->get('sectiuni')->row();
		
		return $result;
	}
	function get_sectiune_multilingv($id,$lang_id)
	{
		$this->db->where('id', $id);
		$this->db->where('lang_id', $lang_id);
		$result = $this->db->get('sectiuni')->row();
		
		return $result;
	}
	
	function get_pag($id)
	{
		$pag	= $this->db->get_where('sectiuni', array('id'=>$id))->row();
		
		//unset some of the additional fields we don't need to keep
		if(!$pag)
		{
			return false;
		}
		return (array)$pag;
	}
	
	function get_slug($id)
	{
		$sectiune = $this->get_sectiune($id);
		if($sectiune) 
		{
			return $sectiune->slug;
		}
	}
	
	function save_formular($data, $forms=false)
	{
			if ($data['id'])
			{
				$this->db->where('id', $data['id']);
				$this->db->update('sectiuni', $data);
	
				$id	= $data['id'];
			}
			//loop through the product forms and add them to the db
			if($forms !== false)
			{
				$obj =& get_instance();
				$obj->load->model('Form_model');
	
				// wipe the slate
				$obj->Form_model->clear_forms($id);
	
				// save edited values
				$count = 1;
				foreach ($forms as $form)
				{
					$values = $form['values'];
					unset($form['values']);
					$form['sectiune_id'] = $id;
					$form['sequence'] = $count;
	
					$obj->Form_model->save_form($form, $values);
					$count++;
				}
			}
	}
	
	function save($data)
	{
		if($data['id'])
		{
			$this->db->where('id', $data['id']);
			$this->db->update('sectiuni', $data);
			return $data['id'];
		}
		else
		{
			$max="SELECT MAX(sequence) AS max FROM `sectiuni`"; 		
			$q = $this -> db -> query($max);
			$t = $q->result_array();	
			$max=$t[0]['max'];
			if($max=='') $max=0;
			else $max=$max+1;
			//$this->db->set('sequence', $max); 
			$data['sequence']=$max;
	       // $this->db->insert('sectiuni');
			
			$this->db->insert('sectiuni', $data);
			return $this->db->insert_id();
		}
	}
	
	function delete_sectiune($id)
	{
		//delete the sectiune
		$this->db->where('id', $id);
		$this->db->delete('sectiuni');
	
	}
	
	function get_sectiune_by_slug($slug)
	{
		$this->db->where('slug', $slug);
		$result = $this->db->get('sectiuni')->row();
		
		return $result;
	}
	
	/*function organize($sectiuni)
	{
		foreach ($sectiuni as $sequence => $id)
		{
			$data = array('sequence' => $sequence);
			$this->db->where('id', $id);
			$this->db->update('sectiuni', $data);
			
			
		}
	}*/
	
	function get_sequence($id)
	{
		$this->db->select('sequence');
		$this->db->from('sectiuni');
		$this->db->where('id',$id);
		$query = $this->db->get();
		$query = $query ->result_array();
		return $query[0]['sequence'];
	}
	
	function get_target_sequence($direction,$sequence)
	{
		
		$this->db->select('sequence');
		$this->db->from('sectiuni');
		if($direction=="up") 
		{
			$this->db->where('sequence <', $sequence); 
			$this->db->order_by("sequence", "desc");
		}
		elseif($direction=="down") 
		{
			$this->db->where('sequence >', $sequence); 
			$this->db->order_by("sequence", "asc");
		}
		$query = $this->db->get();
		$query = $query ->result_array();
		
		if($query==NULL) $tt='';
		else $tt=$query[0]['sequence'];
		return $tt;
	}
	
	function move($sequence,$target)
	{
		$t=-10;
		$this->db->update('sectiuni', array('sequence' => $t), array('sequence' => $sequence));
		$this->db->update('sectiuni', array('sequence' => $sequence), array('sequence' => $target));
		$this->db->update('sectiuni', array('sequence' => $target), array('sequence' => $t));
	
	}
}
?>