<?php
Class Product_model extends CI_Model
{
		
	// we will store the group discount formula here
	// and apply it to product prices as they are fetched 
	var $group_discount_formula = false;
	
	function __construct()
	{
		parent::__construct();
		
		// check for possible group discount 
		$customer = $this->session->userdata('customer');
		if(isset($customer['group_discount_formula'])) 
		{
			$this->group_discount_formula = $customer['group_discount_formula'];
		}
	}
	
	function get_csv(){
		$this->db->select('id,name,sku,price');
		return $query = $this->db->get('products');
			/*
			Here you should note i am returning 
			the query object instead of 
			$query->result() or $query->result_array()
			*/
		}    
	
	function product_autocomplete($name, $limit)
	{
		return	$this->db->like('name', $name)->get('products', $limit)->result();
	}
	
	function products($data=array(), $return_count=false)
	{
		if(empty($data))
		{
			//if nothing is provided return the whole shabang
			$this->get_all_products();
		}
		else
		{
			//grab the limit
			if(!empty($data['rows']))
			{
				$this->db->limit($data['rows']);
			}
			
			//grab the offset
			if(!empty($data['page']))
			{
				$this->db->offset($data['page']);
			}
			
			//do we order by something other than category_id?
			if(!empty($data['order_by']))
			{
				//if we have an order_by then we must have a direction otherwise KABOOM
				$this->db->order_by($data['order_by'], $data['sort_order']);
			}
			
			//do we have a search submitted?
			if(!empty($data['term']))
			{
				$search	= json_decode($data['term']);
				//if we are searching dig through some basic fields
				if(!empty($search->term))
				{
					$this->db->like('name', $search->term);
					$this->db->or_like('description', $search->term);
					//$this->db->or_like('excerpt', $search->term);
					$this->db->or_like('sku', $search->term);
				}
				
				if(!empty($search->category_id))
				{
					//lets do some joins to get the proper category products
					$this->db->join('category_products', 'category_products.product_id=products.id', 'right');
					$this->db->where('category_products.category_id', $search->category_id);
					$this->db->order_by('sequence', 'ASC');
				}
			}
			
			if($return_count)
			{
				return $this->db->count_all_results('products');
			}
			else
			{
				return $this->db->get('products')->result();
			}
			
		}
	}
	
	function get_all_products()
	{
		//sort by alphabetically by default
		$this->db->order_by('name', 'ASC');
		$result	= $this->db->get('products');
		//apply group discount
		$return = $result->result();
		if($this->group_discount_formula) 
		{
			foreach($return as &$product) {
				eval('$product->price=$product->price'.$this->group_discount_formula.';');
			}
		}
		return $return;
	}
	
	function get_sitemap_products()
	{
		$this->db->where(array('enabled'=>1));
		$this->db->order_by('name', 'ASC');
		$result	= $this->db->get('products');
		//apply group discount
		$return = $result->result();
		if($this->group_discount_formula) 
		{
			foreach($return as &$product) {
				eval('$product->price=$product->price'.$this->group_discount_formula.';');
			}
		}
		return $return;
	}
	
	
	function get_accesories()
	{
			$this->db->where(array('accesoriu'=>1));
			$this->db->select('products.id,products.name,products.accesoriu,');
            $this->db->order_by('name', 'ASC');
			$result	= $this->db->get('products');
			//apply group discount
			$return = $result->result();
			if($this->group_discount_formula) 
			{
				foreach($return as &$product) {
					eval('$product->price=$product->price'.$this->group_discount_formula.';');
				}
			}
			return $return;
	}
	
	
	//selecteaza produsele dintr-o anumita categorie
	function get_products_($category_id = false)
	{
		//if we are provided a category_id, then get products according to category
		if ($category_id)
		{
			$this->db->select('category_products.*, LEAST(IFNULL(NULLIF(saleprice, 0), price), price) as sort_price', false)->from('category_products')->join('products', 'category_products.product_id=products.id')->where(array('category_id'=>$category_id, 'enabled'=>1));
			$this->db->order_by('name', 'ASC');
			
            $result	= $this->db->get()->result();
			
			$contents	= array();
			$count		= 0;
			foreach ($result as $product)
			{

				$contents[$count]	= $this->get_product($product->product_id);
				$count++;
			}

			return $contents;
		}
	}
	
	function get_products($category_id = false, $limit = false, $offset = false, $by=false, $sort=false)
	{
		//if we are provided a category_id, then get products according to category
		if ($category_id)
		{
			$this->db->select('category_products.*, LEAST(IFNULL(NULLIF(saleprice, 0), price), price) as sort_price', false)->from('category_products')->join('products', 'category_products.product_id=products.id')->where(array('category_id'=>$category_id, 'enabled'=>1));
			$this->db->order_by($by, $sort);
			
			$result	= $this->db->limit($limit)->offset($offset)->get()->result();

			$contents	= array();
			$count		= 0;
			foreach ($result as $product)
			{

				$contents[$count]	= $this->get_product($product->product_id);
				$count++;
			}

			return $contents;
		}
		else
		{
			//sort by alphabetically by default
			$this->db->order_by('name', 'ASC');
			$result	= $this->db->get('products');
			//apply group discount
			$return = $result->result();
			if($this->group_discount_formula) 
			{
				foreach($return as &$product) {
					eval('$product->price=$product->price'.$this->group_discount_formula.';');
				}
			}
			return $return;
		}
	}
	
	function count_all_products()
	{
		return $this->db->count_all_results('products');
	}
	
	function count_products($id)
	{
		return $this->db->select('product_id')->from('category_products')->join('products', 'category_products.product_id=products.id')->where(array('category_id'=>$id, 'enabled'=>1))->count_all_results();
	}

	function get_product($id, $related=true)
	{
		$result	= $this->db->get_where('products', array('id'=>$id))->row();
		if(!$result)
		{
			return false;
		}

        //for select related products from search modul
		/*$related	= json_decode($result->related_products);
		if(!empty($related))
		{
			//build the where
			$where = false;
			foreach($related as $r)
			{
				if(!$where)
				{
					$this->db->where('id', $r);
				}
				else
				{
					$this->db->or_where('id', $r);
				}
				$where = true;
			}
			$result->related_products	= $this->db->get('products')->result();
		}
		else
		{
			$result->related_products	= array();
		}*/
		
		$result->categories			= $this->get_product_categories($result->id);
		//$result->producers			= $this->get_product_producers($result->id);
		//$result->colectii			= $this->get_product_colectii($result->id);
	
		// group discount?
		if($this->group_discount_formula) 
		{
			eval('$result->price=$result->price'.$this->group_discount_formula.';');
		}

		return $result;
	}

    //for select category from search modul
	/*function get_product_categories($id)
	{
		return $this->db->where('product_id', $id)->join('categories', 'category_id = categories.id')->get('category_products')->result();
	}*/
	
	
	//for select category with checkboxes
	function get_product_categories($id)
	{
		$cats	= $this->db->where('product_id', $id)->get('category_products')->result();
		
		$categories = array();
		foreach ($cats as $c)
		{
			$categories[] = $c->category_id;
		}
		return $categories;
	}
	
	/*function get_product_producers($id)
	{
		$prods	= $this->db->where('product_id', $id)->get('producator_products')->result();
		
		$producers = array();
		foreach ($prods as $c)
		{
			$producers[] = $c->producator_id;
		}
		return $producers;
	}*/
	
	/*function get_product_colectii($id)
	{
		$cols	= $this->db->where('product_id', $id)->get('colectie_products')->result();
		
		$colectii = array();
		foreach ($cols as $c)
		{
			$colectii[] = $c->colectie_id;
		}
		return $colectii;
	}*/
	
	
	function get_slug($id)
	{
		return $this->db->get_where('products', array('id'=>$id))->row()->slug;
	}

	function check_slug($str, $id=false)
	{
		$this->db->select('slug');
		$this->db->from('products');
		$this->db->where('slug', $str);
		if ($id)
		{
			$this->db->where('id !=', $id);
		}
		$count = $this->db->count_all_results();

		if ($count > 0)
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	function save($product, $categories=false/*, $producers=false, $colectii=false*/)
	{
		if ($product['id'])
		{
			$this->db->where('id', $product['id']);
			$this->db->update('products', $product);

			$id	= $product['id'];
		}
		else
		{
			$this->db->insert('products', $product);
			$id	= $this->db->insert_id();
		}

		//for select category from search modul
		/*if($categories !== false)
		{
			if($product['id'])
			{
				//get all the categories that the product is in
				$cats	= $this->get_product_categories($id);
				
				//generate cat_id array
				$ids	= array();
				foreach($cats as $c)
				{
					$ids[]	= $c->id;
				}

				//eliminate categories that products are no longer in
				foreach($ids as $c)
				{
					if(!in_array($c, $categories))
					{
						$this->db->delete('category_products', array('product_id'=>$id,'category_id'=>$c));
					}
				}
				
				//add products to new categories
				foreach($categories as $c)
				{
					if(!in_array($c, $ids))
					{
						$this->db->insert('category_products', array('product_id'=>$id,'category_id'=>$c));
					}
				}
			}
			else
			{
				//new product add them all
				foreach($categories as $c)
				{
					$this->db->insert('category_products', array('product_id'=>$id,'category_id'=>$c));
				}
			}
		}*/
		
		//for select category with checkboxes
		if($categories !== false)
		{
			if($product['id'])
			{
				//get all the categories that the product is in
				$cats	= $this->get_product_categories($id);
				
				//eliminate categories that products are no longer in
				foreach($cats as $c)
				{
					if(!in_array($c, $categories))
					{
						$this->db->delete('category_products', array('product_id'=>$id,'category_id'=>$c));
					}
				}
				
				//add products to new categories
				foreach($categories as $c)
				{
					if(!in_array($c, $cats))
					{
						$this->db->insert('category_products', array('product_id'=>$id,'category_id'=>$c));
					}
				}
			}
			else
			{
				//new product add them all
				foreach($categories as $c)
				{
					$this->db->insert('category_products', array('product_id'=>$id,'category_id'=>$c));
				}
			}
		}
		
		//for select producator with checkboxes
		/*if($producers !== false)
		{
			if($product['id'])
			{
				//get all the categories that the product is in
				$prods	= $this->get_product_producers($id);
				
				//eliminate categories that products are no longer in
				foreach($prods as $c)
				{
					if(!in_array($c, $producers))
					{
						$this->db->delete('producator_products', array('product_id'=>$id,'producator_id'=>$c));
					}
				}
				
				//add products to new categories
				foreach($producers as $c)
				{
					if(!in_array($c, $prods))
					{
						$this->db->insert('producator_products', array('product_id'=>$id,'producator_id'=>$c));
					}
				}
			}
			else
			{
				//new product add them all
				foreach($producers as $c)
				{
					$this->db->insert('producator_products', array('product_id'=>$id,'producator_id'=>$c));
				}
			}
		}*/
		
		//for select colectie with checkboxes
		/*if($colectii !== false)
		{
			if($product['id'])
			{
				//get all the categories that the product is in
				$cols	= $this->get_product_colectii($id);
				
				//eliminate categories that products are no longer in
				foreach($cols as $c)
				{
					if(!in_array($c, $colectii))
					{
						$this->db->delete('colectie_products', array('product_id'=>$id,'colectie_id'=>$c));
					}
				}
				
				//add products to new categories
				foreach($colectii as $c)
				{
					if(!in_array($c, $cols))
					{
						$this->db->insert('colectie_products', array('product_id'=>$id,'colectie_id'=>$c));
					}
				}
			}
			else
			{
				//new product add them all
				foreach($colectii as $c)
				{
					$this->db->insert('colectie_products', array('product_id'=>$id,'colectie_id'=>$c));
				}
			}
		}*/
		
		//return the product id
		return $id;
	}
	
	function save_accesories($product)
	{
			$this->db->where('id', $product['id']);
			$this->db->update('products', $product);
	}
	
	function delete_product($id)
	{
		// delete product 
		$this->db->where('id', $id);
		$this->db->delete('products');

		//delete references in the product to category table
		$this->db->where('product_id', $id);
		$this->db->delete('category_products');
		
		//delete references in the product to producator table
		//$this->db->where('product_id', $id);
	//	$this->db->delete('producator_products');
		
		//delete references in the product to colectie table
		//$this->db->where('product_id', $id);
		//$this->db->delete('colectie_products');
		
		// delete coupon reference
		//$this->db->where('product_id', $id);
		//$this->db->delete('coupons_products');

	}

	function add_product_to_category($product_id, $optionlist_id, $sequence)
	{
		$this->db->insert('product_categories', array('product_id'=>$product_id, 'category_id'=>$category_id, 'sequence'=>$sequence));
	}

	function search_products($term, $limit=false, $offset=false, $by=false, $sort=false)
	{
		$results		= array();
		
		$this->db->select('*, LEAST(IFNULL(NULLIF(saleprice, 0), price), price) as sort_price', false);
		//this one counts the total number for our pagination
		$this->db->where('enabled', 1);
		$this->db->where('(name LIKE "%'.$term.'%" OR description LIKE "%'.$term.'%" OR sku LIKE "%'.$term.'%")');
		$results['count']	= $this->db->count_all_results('products');


		$this->db->select('*, LEAST(IFNULL(NULLIF(saleprice, 0), price), price) as sort_price', false);
		//this one gets just the ones we need.
		$this->db->where('enabled', 1);
		$this->db->where('(name LIKE "%'.$term.'%" OR description LIKE "%'.$term.'%" OR sku LIKE "%'.$term.'%")');
		
		if($by && $sort)
		{
			$this->db->order_by($by, $sort);
		}
		
		$results['products']	= $this->db->get('products', $limit, $offset)->result();
		
		return $results;
	}

	// Build a cart-ready product array
	function get_cart_ready_product($id, $quantity=false)
	{
		$product	= $this->db->get_where('products', array('id'=>$id))->row();
		
		//unset some of the additional fields we don't need to keep
		if(!$product)
		{
			return false;
		}
		
		$product->base_price	= $product->price;
		
		if ($product->saleprice != 0.00)
		{ 
			$product->price	= $product->saleprice;
		}
		
		
		// Some products have n/a quantity, such as downloadables
		//overwrite quantity of the product with quantity requested
		if (!$quantity || $quantity <= 0 || $product->fixed_quantity==1)
		{
			$product->quantity = 1;
		}
		else
		{
			$product->quantity = $quantity;
		}
		
		
		// attach list of associated downloadables
		$product->file_list	= $this->Digital_Product_model->get_associations_by_product($id);
		
		return (array)$product;
	}
	
	function get_produse_home()
	{
			$this->db->select('*')->from('products')->where(array('enabled'=>1, 'produs_home'=>1));
			$this->db->order_by('name', 'RANDOM');
			//$this->db->limit(100);
			$result	= $this->db->get()->result();
			//print_r($result	);die;

			$contents	= array();
			$count		= 0;
			foreach ($result as $product)
			{
				$contents[$count]	= $this->get_product($product->id);
				$count++;
			}
			return $contents;
    }
	
	function get_produse_promotie()
	{
			$this->db->select('*')->from('products')->where(array('enabled'=>1, 'produs_promotie'=>1));
			$this->db->order_by('name', 'RANDOM');
			//$this->db->limit(100);
			$result	= $this->db->get()->result();
			//print_r($result	);die;

			$contents	= array();
			$count		= 0;
			foreach ($result as $product)
			{
				$contents[$count]	= $this->get_product($product->id);
				$count++;
			}
			return $contents;
    }
	
	function get_produse_noi()
	{
			$this->db->select('*')->from('products')->where(array('enabled'=>1, 'produs_nou'=>1));
			$this->db->order_by('name', 'RANDOM');
			//$this->db->limit(100);
			$result	= $this->db->get()->result();
			//print_r($result	);die;

			$contents	= array();
			$count		= 0;
			foreach ($result as $product)
			{
				$contents[$count]	= $this->get_product($product->id);
				$count++;
			}
			return $contents;
    }
	
	function get_produse_sugerate()
	{
			$this->db->select('*')->from('products')->where(array('enabled'=>1, 'produs_sugerat'=>1));
			//$this->db->where('id','277');
			$this->db->order_by('name', 'RANDOM');
			//$this->db->limit(100);
			$result	= $this->db->get()->result();
			//print_r($result	);die;

			$contents	= array();
			$count		= 0;
			foreach ($result as $product)
			{
				$contents[$count]	= $this->get_product($product->id);
				$count++;
			}
			return $contents;
    }
	
	function get_all_promotii($limit = false, $offset = false)//afiseaza produsele active bifate ca promotii
	{
		$this->db->select('*')->from('products')->where(array('enabled'=>1, 'produs_promotie'=>1));
		$this->db->order_by('id', 'DESC');
		$result	= $this->db->limit($limit)->offset($offset)->get()->result();
		//return $result;
		$contents	= array();
		$count		= 0;
		foreach ($result as $product)
		{

			$contents[$count]	= $this->get_product($product->id);
			$count++;
		}

		return $contents;
	}
	
	function count_promotii() 
	{
		return $this->db->select('product_id')->from('products')->where(array('enabled'=>1, 'produs_promotie'=>1))->count_all_results();
	}
	
	function get_all_noutati($limit = false, $offset = false) //afiseaza produsele active bifate ca noutati
	{
		$this->db->select('*')->from('products')->where(array('enabled'=>1, 'produs_nou'=>1));
		$this->db->order_by('id', 'DESC');
		$result	= $this->db->limit($limit)->offset($offset)->get()->result();
		
		$contents	= array();
		$count		= 0;
		foreach ($result as $product)
		{

			$contents[$count]	= $this->get_product($product->id);
			$count++;
		}

		return $contents;
			
		//return $result;
		
	
	}
	
	function count_noutati()
	{
		return $this->db->select('product_id')->from('products')->where(array('enabled'=>1, 'produs_nou'=>1))->count_all_results();
	}
	
	function get_products_producatori($producator_id,$limit = false, $offset = false, $by=false, $sort=false) //pt fiecare producator afiseaza toate produsele active si inactive
	{
		$this->db->select('producator_products.*,products.name,products.slug,products.price,products.image_list,products.id,products.seo_title,products.saleprice,products.pret_in_site,products.track_stock,products.quantity, LEAST(IFNULL(NULLIF(saleprice, 0), price), price) as sort_price', false)->from('producator_products')->join('products', 'producator_products.product_id=products.id')->where(array('products.enabled'=>1,'producator_id'=>$producator_id));
		$this->db->order_by($by, $sort);
		$result	= $this->db->limit($limit)->offset($offset)->get()->result();
		//return $result;
		$contents	= array();
		$count		= 0;
		foreach ($result as $product)
		{

			$contents[$count]	= $this->get_product($product->id);
			$count++;
		}

		return $contents;
	}
	function count_products_producatori($id)
	{
		return $this->db->select('product_id')->from('producator_products')->join('products', 'producator_products.product_id=products.id')->where(array('producator_id'=>$id, 'enabled'=>1))->count_all_results();
	}
	
	/*function get_products_colectii($colectie_id) //pt fiecare colectie afiseaza toate produsele active
	{
		$this->db->select('colectie_products.*,products.name,products.slug,products.price,products.image_list,products.id,products.seo_title,products.saleprice,products.pret_in_site,products.track_stock,products.quantity, LEAST(IFNULL(NULLIF(saleprice, 0), price), price) as sort_price', false)->from('colectie_products')->join('products', 'colectie_products.product_id=products.id')->where(array('colectie_id'=>$colectie_id,'enabled'=>1));
		$this->db->order_by('products.name', 'RANDOM');
		//$result	= $this->db->limit($limit)->offset($offset)->get()->result();
		$result	= $this->db->get()->result();
		//return $result;
		$contents	= array();
		$count		= 0;
		foreach ($result as $product)
		{

			$contents[$count]	= $this->get_product($product->id);
			$count++;
		}

		return $contents;
	}*/
	
}
?>