<?php
Class Page_model extends CI_Model
{
	function __construct()
	{
			parent::__construct();
	}
	
	/********************************************************************
	Page functions
	********************************************************************/
	function get_pages($parent = 0)
	{
		$this->db->order_by('sequence', 'ASC');
		$this->db->where('parent_id', $parent);
		$result = $this->db->get('pages')->result();
		
		$return	= array();
		foreach($result as $page)
		{
			$return[$page->id]				= $page;
			$return[$page->id]->children	= $this->get_pages($page->id);
		}
		
		return $return;
	}
	
	function get_pages_multilingv($parent = 0,$lang_id)
	{
		$this->db->order_by('sequence', 'ASC');
		$this->db->where('parent_id', $parent);
		$this->db->where('lang_id', $lang_id);
		$result = $this->db->get('pages')->result();
		
		$return	= array();
		foreach($result as $page)
		{
			$return[$page->id]				= $page;
			$return[$page->id]->children	= $this->get_pages_multilingv($page->id,$lang_id);
		}
		
		return $return;
	}
	
	function get_pages_solutii($parent = 0)
	{
		$this->db->order_by('sequence', 'ASC');
		$this->db->select('pages.id,pages.menu_title, pages.url, pages.new_window, pages.slug');
		$this->db->where('parent_id', $parent);
		$result = $this->db->get('pages')->result();
		
		$return	= array();
		foreach($result as $page)
		{
			$return[$page->id]				= $page;
			$return[$page->id]->children	= $this->get_pages($page->id);
		}
		
		return $return;
	}
	
	function get_subcategorii($parent_id)
	{
	$this->db->select('*');
	$this->db->from('pages');
	$this->db->where('pages.parent_id',$parent_id);
	$this->db->order_by("sequence", "ASC");
	
	$query = $this->db->get();
	return $query ->result_array();
	}
	
	function get_pages_links($parent = 0)
	{
		$this->db->order_by('sequence', 'ASC');
		$this->db->select('pages.id,pages.menu_title, pages.url, pages.new_window, pages.slug');
		$this->db->where('parent_id', $parent);
		$query = $this->db->get('pages');
		return $query ->result_array();
	}
	
	function get_page($id)
	{
		$this->db->where('id', $id);
		$result = $this->db->get('pages')->row();
		
		return $result;
	}
	
	function get_page_multilingv($id,$lang_id)
	{
		$this->db->where('id', $id);
		$this->db->where('lang_id', $lang_id);
		$result = $this->db->get('pages')->row();
		
		return $result;
	}
	
	function get_pag($id)
	{
		$pag	= $this->db->get_where('pages', array('id'=>$id))->row();
		
		//unset some of the additional fields we don't need to keep
		if(!$pag)
		{
			return false;
		}
		return (array)$pag;
	}
	
	function get_slug($id)
	{
		$page = $this->get_page($id);
		if($page) 
		{
			return $page->slug;
		}
	}
	
	function save_formular($data, $forms=false)
	{
			if ($data['id'])
			{
				$this->db->where('id', $data['id']);
				$this->db->update('pages', $data);
	
				$id	= $data['id'];
			}
			//loop through the product forms and add them to the db
			if($forms !== false)
			{
				$obj =& get_instance();
				$obj->load->model('Form_model');
	
				// wipe the slate
				$obj->Form_model->clear_forms($id);
	
				// save edited values
				$count = 1;
				foreach ($forms as $form)
				{
					$values = $form['values'];
					unset($form['values']);
					$form['page_id'] = $id;
					$form['sequence'] = $count;
	
					$obj->Form_model->save_form($form, $values);
					$count++;
				}
			}
	}
	
	function save($data)
	{
		if($data['id'])
		{
			$this->db->where('id', $data['id']);
			$this->db->update('pages', $data);
			return $data['id'];
		}
		else
		{
			$max="SELECT MAX(sequence) AS max FROM `pages`"; 		
			$q = $this -> db -> query($max);
			$t = $q->result_array();	
			$max=$t[0]['max'];
			if($max=='') $max=0;
			else $max=$max+1;
			//$this->db->set('sequence', $max); 
			$data['sequence']=$max;
	       // $this->db->insert('pages');
			
			$this->db->insert('pages', $data);
			return $this->db->insert_id();
		}
	}
	
	function delete_page($id)
	{
		//delete the page
		$this->db->where('id', $id);
		$this->db->delete('pages');
	
	}
	
	function get_page_by_slug($slug)
	{
		$this->db->where('slug', $slug);
		$result = $this->db->get('pages')->row();
		
		return $result;
	}
	
	/*function organize($pages)
	{
		foreach ($pages as $sequence => $id)
		{
			$data = array('sequence' => $sequence);
			$this->db->where('id', $id);
			$this->db->update('pages', $data);
			
			
		}
	}*/
	
	function get_sequence($id)
	{
		$this->db->select('sequence');
		$this->db->from('pages');
		$this->db->where('id',$id);
		$query = $this->db->get();
		$query = $query ->result_array();
		return $query[0]['sequence'];
	}
	
	function get_target_sequence($direction,$sequence)
	{
		
		$this->db->select('sequence');
		$this->db->from('pages');
		if($direction=="up") 
		{
			$this->db->where('sequence <', $sequence); 
			$this->db->order_by("sequence", "desc");
		}
		elseif($direction=="down") 
		{
			$this->db->where('sequence >', $sequence); 
			$this->db->order_by("sequence", "asc");
		}
		$query = $this->db->get();
		$query = $query ->result_array();
		
		if($query==NULL) $tt='';
		else $tt=$query[0]['sequence'];
		return $tt;
	}
	
	function move($sequence,$target)
	{
		$t=-10;
		$this->db->update('pages', array('sequence' => $t), array('sequence' => $sequence));
		$this->db->update('pages', array('sequence' => $sequence), array('sequence' => $target));
		$this->db->update('pages', array('sequence' => $target), array('sequence' => $t));
	
	}
}
?>