<?php
Class banner_footer_model extends CI_Model
{
	function get_banners_footer($limit = false)
	{
		if($limit)
		{
			$this->db->limit($limit);
		}
		return $this->db->order_by('sequence asc')->get('banners_footer')->result();
	}
	
	function get_homepage_banners_footer($limit = false)
	{
		$banners_footer	= $this->db->order_by('sequence asc')->get('banners_footer')->result();
		//$count	= 1;
		$return	= array();
		foreach ($banners_footer as $banner_footer)
		{
			if ($banner_footer->enable_on == '0000-00-00')
			{
				$enable_test	= false;
				$enable			= '';
			}
			else
			{
				$eo			 	= explode('-', $banner_footer->enable_on);
				$enable_test	= $eo[0].$eo[1].$eo[2];
				$enable			= $eo[1].'-'.$eo[2].'-'.$eo[0];
			}

			if ($banner_footer->disable_on == '0000-00-00')
			{
				$disable_test	= false;
				$disable		= '';
			}
			else
			{
				$do			 	= explode('-', $banner_footer->disable_on);
				$disable_test	= $do[0].$do[1].$do[2];
				$disable		= $do[1].'-'.$do[2].'-'.$do[0];
			}

			$curDate		= date('Ymd');

			if (($enable_test && $enable_test > $curDate) || ($disable_test && $disable_test <= $curDate))
			{
				//unset($banner_footer);
			}
			else
			{
				//$count++;
				$return[]	= $banner_footer;
			}
			
			if($limit && $limit <= count($return))
			{
				break;
			}
		}
		
		//print_r($return);die;
		return $return;
	}
	
	function get_banner_footer($id)
	{
		$this->db->where('id', $id);
		$result = $this->db->get('banners_footer');
		$result = $result->row();
		
		if ($result)
		{
			if ($result->enable_on == '0000-00-00')
			{
				$result->enable_on = '';
			}
			
			if ($result->disable_on == '0000-00-00')
			{
				$result->disable_on = '';
			}
		
			return $result;
		}
		else
		{ 
			return array();
		}
	}
	
	function delete($id)
	{
		
		$banner_footer	= $this->get_banner_footer($id);
		if ($banner_footer)
		{
			$this->db->where('id', $id);
			$this->db->delete('banners_footer');
			
			return 'The "'.$banner_footer->title.'" banner has been removed.';
		}
		else
		{
			return 'The banner could not be found.';
		}
	}
	
	function get_next_sequence()
	{//die;
		$this->db->select('sequence');
		$this->db->order_by('sequence asc');
		$this->db->limit(1);
		$result = $this->db->get('banners_footer');
		$result = $result->row();
		if ($result)
		{
			return $result->sequence + 1;
		}
		else
		{
			return 0;
		}
	}
	
	function save_banner_footer($data)
	{
		if(isset($data['id']))
		{
			$this->db->where('id', $data['id']);
			$this->db->update('banners_footer', $data);
		}
		else
		{
			$data['sequence'] = $this->get_next_sequence();
			$this->db->insert('banners_footer', $data);
		}
	}
	
	function organize($banners_footer)
	{
		foreach ($banners_footer as $sequence => $id)
		{
			$data = array('sequence' => $sequence);
			$this->db->where('id', $id);
			$this->db->update('banners_footer', $data);
		}
	}
}
?>