<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Images
{
	var $CI;
	
	function Images()
	{
		$this->CI =& get_instance();
		$this->CI->load->library('image_lib');
	}//~constructor
	
	function upload_and_resize($configuration)
	{
		$this->CI =& get_instance();
		
		$config['upload_path'] = $configuration['upload_path'];
		$config['allowed_types'] = $configuration['allowed_types'];
		//$config['max_size']	= '100000';
		//$config['max_width']  = '800';
		//$config['max_height']  = '600';
		
		$this->CI->load->library('upload', $config);
				
		if($this->CI->upload->do_upload($configuration['field_name']))
		{		
			$data = $this->CI->upload->data();
			
			foreach($configuration['width'] as $pos=>$width)
			{
				if($pos==0)
				{
					if($data['image_width']>$width || $data['image_height']>$height)
						$this->resize_picture($data['full_path'], $width, $configuration['height'][$pos]);
				}
				else
				{
					if($pos>=2) $thumb_marker = '_thumb'.$pos;
					else $thumb_marker = '_thumb';
					
					$this->resize_picture($data['full_path'], $width, $configuration['height'][$pos], $thumb_marker);
				}
			}
			
			return $data['file_name'];
		}
		else 
		{
			//echo $this->CI->upload->display_errors();
			return false;
		}
	}
	
	
	function resize_picture($path,$width,$height,$thumb_marker=false, $master_dim = false)
	{
		$this->CI =& get_instance();
		
		$image_lib_config['image_library'] = 'GD2';
		
		if($master_dim)
			$image_lib_config['master_dim'] = $master_dim;
		else
			$image_lib_config['master_dim'] = 'auto';
		
		$image_lib_config['width'] = $width;
		$image_lib_config['height'] = $height;
		$image_lib_config['source_image'] = $path;
		
		if(!$thumb_marker)
		{
			$image_lib_config['create_thumb'] = false;
		}
		else
		{
			$image_lib_config['create_thumb'] = true;
			$image_lib_config['thumb_marker'] = $thumb_marker;
		}	
		
		$this->CI->image_lib->clear();
		$this->CI->image_lib->initialize($image_lib_config);
        if($this->CI->image_lib->resize()) return true;
		else 
		{
			echo $this->CI->image_lib->display_errors();
			die;
			return false;
		}
	}

	function add_file_termination($image_name, $termination = '_thumb')
	{
		$this->CI =& get_instance();
		
		$ext = end(explode(".", $image_name));
		return substr($image_name, 0, -strlen($ext)-1).$termination.'.'.$ext;
	}
	
	function upload_category_image($field_name)
	{
		$this->CI =& get_instance();
		
		$config['upload_path'] = $this->CI->config->item('upload_url').'uploads/categories';
		$config['allowed_types'] = 'gif|jpg|png|tif';
		//$config['max_size']	= '100000';
		//$config['max_width']  = '800';
		//$config['max_height']  = '600';
		
		$this->CI->load->library('upload', $config);
				
		if($this->CI->upload->do_upload($field_name))
		{		
			$data = $this->CI->upload->data();
			if($data['image_width']>500 || $data['image_height']>375)
				$this->resize_picture($data['full_path'], 500, 375);
				
			$this->resize_picture($data['full_path'], 126, 52, '_thumb');
			return $data['file_name'];
		}
		else 
		{
			//echo $this->CI->upload->display_errors();
			return false;
		}
		
	}
	
	function upload_category_banner($field_name, $position)
	{
		$this->CI =& get_instance();
		
		$config['upload_path'] = $this->CI->config->item('upload_url').'uploads/categories_banners';
		$config['allowed_types'] = 'gif|jpg|png|swf|tif';
		//$config['max_size']	= '100000';
		//$config['max_width']  = '800';
		//$config['max_height']  = '600';
		
		$this->CI->load->library('upload', $config);
				
		if($this->CI->upload->do_upload($field_name))
		{		
			$data = $this->CI->upload->data();

			if($data['is_image'])
			{
				if(!$this->resize_picture($data['full_path'], $this->CI->config->item('flash_categ_banner_w'), $this->CI->config->item('flash_categ_banner_h'))) return false;
			}

			return $data['file_name'];
		}
		
		//echo $this->CI->upload->display_errors();
		return false;
	}
	
	function delete_category_banner($banner_name)
	{
		$this->CI =& get_instance();
		
		if(!empty($banner_name) && file_exists($this->CI->config->item('upload_url').'uploads/categories_banners/'.$banner_name))
			unlink($this->CI->config->item('upload_url').'uploads/categories_banners/'.$banner_name);
	}
	
	
	function delete_category_server_image($image_name)
	{
		$this->CI =& get_instance();
		
		if(!empty($image_name) && file_exists($this->CI->config->item('upload_url').'uploads/categories/'.$image_name))
			unlink($this->CI->config->item('upload_url').'uploads/categories/'.$image_name);
		
		if(!empty($image_name) && file_exists($this->CI->config->item('upload_url').'uploads/categories/'.$this->add_file_termination($image_name, '_thumb')))
			unlink($this->CI->config->item('upload_url').'uploads/categories/'.$this->add_file_termination($image_name, '_thumb'));
	
	}
	
	function upload_shop_image($field_name)
	{
		$this->CI =& get_instance();
		
		$config['upload_path'] = $this->CI->config->item('upload_url').'uploads/shops';
		$config['allowed_types'] = 'gif|jpg|png|tif';
		//$config['max_size']	= '100000';
		//$config['max_width']  = '800';
		//$config['max_height']  = '600';
		
		$this->CI->load->library('upload', $config);
				
		if($this->CI->upload->do_upload($field_name))
		{		
			$data = $this->CI->upload->data();
			if($data['image_width']>150 || $data['image_height']>150)
				$this->resize_picture($data['full_path'], 150, 150);
			$this->resize_picture($data['full_path'], 70, 70, '_thumb');
			return $data['file_name'];
		}
		else 
		{
			//echo $this->CI->upload->display_errors();
			return false;
		}
		
	}
	
	function delete_shop_server_image($image_name)
	{
		$this->CI =& get_instance();

		if(!empty($image_name) && file_exists($this->CI->config->item('upload_url').'uploads/shops/'.$image_name))
			unlink($this->CI->config->item('upload_url').'uploads/shops/'.$image_name);

		if(!empty($image_name) && file_exists($this->CI->config->item('upload_url').'uploads/shops/'.$this->add_file_termination($image_name, '_thumb')))
			unlink($this->CI->config->item('upload_url').'uploads/shops/'.$this->add_file_termination($image_name, '_thumb'));
	
	}

	function upload_product_image($field_name)
	{
		$this->CI =& get_instance();
		
		$config['upload_path'] = $this->CI->config->item('upload_url').'uploads/products';
		$config['allowed_types'] = 'gif|jpg|png|tif';
		//$config['max_size']	= '100000';
		//$config['max_width']  = '800';
		//$config['max_height']  = '600';
		
		$this->CI->load->library('upload', $config);
				
		if($this->CI->upload->do_upload($field_name))
		{		
			$data = $this->CI->upload->data();
			if($data['image_width']>150 || $data['image_height']>150)
				$this->resize_picture($data['full_path'], 150, 150);
			$this->resize_picture($data['full_path'], 70, 70, '_thumb');
			return $data['file_name'];
		}
		else 
		{
			//echo $this->CI->upload->display_errors();
			return false;
		}
		
	}
	
	function delete_product_server_image($image_name)
	{
		$this->CI =& get_instance();
		
		if(!empty($image_name) && file_exists($this->CI->config->item('upload_url').'uploads/products/'.$image_name))
			unlink($this->CI->config->item('upload_url').'uploads/products/'.$image_name);
		
		if(!empty($image_name) && file_exists($this->CI->config->item('upload_url').'uploads/products/'.$this->add_file_termination($image_name, '_thumb')))
			unlink($this->CI->config->item('upload_url').'uploads/products/'.$this->add_file_termination($image_name, '_thumb'));
	
	}

	function upload_banner($field_name, $position)
	{
		$this->CI =& get_instance();
		
		$config['upload_path'] =  $this->CI->config->item('root').'uploads/banners';
		$config['allowed_types'] = 'gif|jpg|png|swf|tif';
		//$config['max_size']	= '100000';
		//$config['max_width']  = '800';
		//$config['max_height']  = '600';
		
		$this->CI->load->library('upload', $config);
				
		if($this->CI->upload->do_upload($field_name))
		{		//die;
			$data = $this->CI->upload->data();
			
			if($data['is_image'])
			{
				if($position=='header')
				{
					if($data['image_width']>$this->CI->config->item('flash_header_banner_w') || $data['image_height']>$this->CI->config->item('flash_header_banner_h'))
						if(!$this->resize_picture($data['full_path'], $this->CI->config->item('flash_header_banner_w'), $this->CI->config->item('flash_header_banner_h'))) return false;
				}
	
				if($position=='left')
				{
					if($data['image_width']>$this->CI->config->item('flash_left_banner_w') || $data['image_height']>$this->CI->config->item('flash_left_banner_h'))
						if(!$this->resize_picture($data['full_path'], $this->CI->config->item('flash_left_banner_w'), $this->CI->config->item('flash_left_banner_h'))) return false;				
				}
	
				if($position=='right')
				{
					if($data['image_width']>$this->CI->config->item('flash_right_banner_w') || $data['image_height']>$this->CI->config->item('flash_right_banner_h'))
						if(!$this->resize_picture($data['full_path'], $this->CI->config->item('flash_right_banner_w'), $this->CI->config->item('flash_right_banner_h'))) return false;
				}
	
				if($position=='footer')
				{
					if($data['image_width']>$this->CI->config->item('flash_footer_banner_w') || $data['image_height']>$this->CI->config->item('flash_footer_banner_h'))
						if(!$this->resize_picture($data['full_path'], $this->CI->config->item('flash_footer_banner_w'), $this->CI->config->item('flash_footer_banner_h'))) return false;
				}
			}

			return $data['file_name'];
		}
		
		return false;
	}
	
	function delete_banner($banner_name)
	{
		$this->CI =& get_instance();
		
		if(!empty($banner_name) && file_exists($this->CI->config->item('upload_url').'uploads/banners/'.$banner_name))
			unlink($this->CI->config->item('upload_url').'uploads/banners/'.$banner_name);
	}
	
	function upload_link_image($field_name)
	{
		$this->CI =& get_instance();
		
		$config['upload_path'] = $this->CI->config->item('upload_url').'uploads/links';
		$config['allowed_types'] = 'gif|jpg|png|tif';
		//$config['max_size']	= '100000';
		//$config['max_width']  = '800';
		//$config['max_height']  = '600';
		
		$this->CI->load->library('upload', $config);
				
		if($this->CI->upload->do_upload($field_name))
		{		
			$data = $this->CI->upload->data();
			if($data['image_width']>50 || $data['image_height']>50)
				$this->resize_picture($data['full_path'], 50, 50);
			return $data['file_name'];
		}
		else 
		{
			//echo $this->CI->upload->display_errors();
			return false;
		}
		
	}
	
	function delete_link_server_image($image_name)
	{
		$this->CI =& get_instance();
		
		if(!empty($image_name) && file_exists($this->CI->config->item('upload_url').'uploads/links/'.$image_name))
			unlink($this->CI->config->item('upload_url').'uploads/links/'.$image_name);
	}
}
?>