<?php

/**
 * The base controller which is used by the Front and the Admin controllers
 */
/*class Base_Controller extends CI_Controller
{
	
	public function __construct()
	{
		
		parent::__construct();

		// load the migrations class
		$this->load->library('migration');
	
		// Migrate to the latest migration file found
		if ( ! $this->migration->latest())
		{
			log_message('error', 'The migration failed');
		}
		
	}//end __construct()
	
}//end Base_Controller*/

class Front_Controller extends CI_Controller
{
	
	//we collect the categories automatically with each load rather than for each function
	//this just cuts the codebase down a bit
	var $categories	= '';
	
	//load all the pages into this variable so we can call it from all the methods
	var $pages = '';
	
	// determine whether to display gift card link on all cart pages
	//  This is Not the place to enable gift cards. It is a setting that is loaded during instantiation.
	var $gift_cards_enabled;
	
	function __construct(){
		
		parent::__construct();

		//load GoCart library
		$this->load->library('Webevo');
		
		//preia limba
		$this->load->helper('language');
	    $site_lang = $this->session->userdata('site_lang');	$site_lang = ($site_lang != "") ? $site_lang : "romana";
		
        if ($site_lang) {
            $this->lang->load('common',$this->session->userdata('site_lang'));
			$this->lang->load('form_validation',$this->session->userdata('site_lang'));
			
        } else {
            $this->lang->load('common','romana');
			$this->lang->load('form_validation','romana');
        }
		$this->lang_id = $this->session->userdata('lang_id'); $this->lang_id = ($this->lang_id != "") ? $this->lang_id : "1";
		//preia limba
		
	
		//load needed models
		$this->load->model(array('Banner_model','Banner_footer_model','Product_model', 'Digital_Product_model','Category_model','Page_model','Sectiune_model', 'Settings_model','General_settings_model'));
		
		$home		= $this->Page_model->get_page('46');
		$this->text_footer		= $home->text_footer;
		
		//load helpers
		//$this->load->helper(array('form_helper', 'formatting_helper'));
		$this->categories	= $this->Category_model->get_categories_tierd(0);
		
		//$this->pages		= $this->Page_model->get_pages();  ///toate sectiunile pages
		$this->pages		= $this->Page_model->get_pages_multilingv(0,$this->lang_id);
		
		//$this->sectiuni		= $this->Sectiune_model->get_sectiuni();  ///toate sectiunile
		$this->sectiuni		= $this->Sectiune_model->get_sectiuni_multilingv(0,$this->lang_id);  ///toate sectiunile
		//$this->pages_links		= $this->Page_model->get_pages_links(); //link-uri pagini administrabile
		
		$this->banners = $this->Banner_model->get_homepage_boxes_multilingv(10,$this->lang_id); //get bannere header
		//$this->banners_left = $this->Banner_left_model->get_homepage_banners_left(10); //get bannere header
		$this->banners_footer = $this->Banner_footer_model->get_homepage_banners_footer(10); //get bannere header
		
		$this->general_settings		= $this->General_settings_model->get_all_general_settings2();  //solutii pentru afaceri
		
		//print_r($this->general_settings	);die;
		$this->nume_site=$this->general_settings[0]['valoare'];
		$this->contact_email=$this->general_settings[1]['valoare'];
		$this->administrator_email=$this->general_settings[2]['valoare'];
		
		$this->facebook=$this->general_settings[3]['valoare'];
		$this->youtube=$this->general_settings[4]['valoare'];
		$this->twitter=$this->general_settings[5]['valoare'];
		$this->instagram=$this->general_settings[6]['valoare'];	
		
		$this->copyright=$this->general_settings[7]['valoare'];
		$this->analytics=$this->general_settings[8]['valoare'];
		
		$this->adresa_footer=$this->general_settings[9]['valoare'];
		$this->telefon_footer=$this->general_settings[10]['valoare'];
		$this->email_footer=$this->general_settings[11]['valoare'];
		
		//load the theme package
		$this->load->add_package_path(APPPATH.'themes/'.$this->config->item('theme').'/');
	}
	
	/*
	This works exactly like the regular $this->load->view()
	The difference is it automatically pulls in a header and footer.
	*/
	function view($view, $vars = array(), $string=false)
	{
		if($string)
		{
			$result	 = $this->load->view('header', $vars, true);
			$result	.= $this->load->view($view, $vars, true);
			$result	.= $this->load->view('footer', $vars, true);
			
			return $result;
		}
		else
		{
			$this->load->view('header', $vars);
			$this->load->view($view, $vars);
			$this->load->view('footer', $vars);

		}
	}
	
	/*
	This function simple calls $this->load->view()
	*/
	function partial($view, $vars = array(), $string=false)
	{
		if($string)
		{
			return $this->load->view($view, $vars, true);
		}
		else
		{
			$this->load->view($view, $vars);
		}
	}
}


class Admin_Controller extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		
		$this->load->library('auth');
		$this->auth->is_logged_in(uri_string());
		//print_r(uri_string());die;
		
		//load the base language file
		$this->lang->load('admin_common');
		$this->lang->load('goedit'); //for editor redactor
	}
}
?>