<?php

class Events extends Admin_Controller

{

	function __construct()

	{

		parent::__construct();



		force_ssl();

		$this->auth->check_access('Admin', true);

		

		$this->lang->load('event');

		$this->lang->load('common');

		$this->load->model('event_model');

		$this->load->helper('date');



	}

		

	function index()

	{

		$data['events']		= $this->event_model->get_events();

		$data['page_title']		= lang('events');

		

		$this->load->view($this->config->item('admin_folder').'/events/events', $data);

	}

	

	function organize()

	{

		$events	= $this->input->post('events');

		$this->event_model->organize($events);

	}

	

	/*function delete($id)

	{

		$this->event_model->delete($id);

		

		$this->session->set_flashdata('message', lang('message_delete_event'));

		redirect($this->config->item('admin_folder').'/events');

	}*/

	

	function delete($id)

	{

		

		$event	= $this->event_model->get_event($id);

		

		if($event)

		{

			$this->load->model('Routes_model');

			

			$this->Routes_model->delete($event->route_id);

			$this->event_model->delete_event($id);

			$this->session->set_flashdata('message', lang('message_deleted_event'));

		}

		else

		{

			$this->session->set_flashdata('error', 'Proiectul nu a putut fi gasit.');

		}

		

		redirect($this->config->item('admin_folder').'/events');

	}

	

	/********************************************************************

	this function is called by an ajax script, it re-sorts the events

	********************************************************************/

	

	function form($id = false)

	{

		

		//$config['upload_path']		= 'uploads/events';

		//$config['allowed_types']	= 'gif|jpg|png|jpeg';

		//$config['max_size']			= $this->config->item('size_limit');

		//$config['max_width']		= '1920';

	    //$config['max_height']		= '1080';

		$config['encrypt_name']		= true;

		$this->load->library('upload', $config);

		

		

		$this->load->helper('form');

		$this->load->library('form_validation');

		

		//set the default values

		$data	= array(	 'id'=>$id

							,'title'=>''

							,'titlu'=>''

							,'slug'=>''

							//,'lang_id'=>''

							//,'short_text'=>''

							,'text'=>''

							//,'enable_on'=>''

							//,'disable_on'=>''

							,'image'=>''

							,'banner'=>''

							,'seo_title'=>''

							,'meta'=>''

							,'keywords'=>''

							//,'homepage'=>''

							,'images'=>array()

							//,'link'=>''

							//,'new_window'=>false	

						);

		

		if($id)

		{

			$data				= (array) $this->event_model->get_event($id);

			//$data['enable_on']	= format_mdy($data['enable_on']);

			//$data['disable_on']	= format_mdy($data['disable_on']);

			//$data['new_window']	= (bool) $data['new_window'];

			//$data['homepage']	= (bool) $data['homepage'];

			$data['text']	= $data['text'];

			//$data['short_text']	= $data['short_text'];

			$data['seo_title']		= $data['seo_title'];

			$data['meta']			= $data['meta'];

			$data['keywords']			= $data['keywords'];

			$data['slug']			= $data['slug'];

			

			

			

			$event			= $this->event_model->get_event($id);

			if(!$event)

			{

				//event does not exist

				$this->session->set_flashdata('error', 'Partenerul nu a fost gasit');

				redirect($this->config->item('admin_folder').'/events');

			}

			//make sure we haven't submitted the form yet before we pull in the images/related products from the database

			if(!$this->input->post('submit'))

			{

				$data['images']				= (array)json_decode($event->images);

			}

			

			

		}

		

		$data['page_title']	= lang('event_form');

		

		$this->form_validation->set_rules('title', 'lang:title', 'trim|required|full_decode');

		$this->form_validation->set_rules('slug', 'Url key', 'trim');

		$this->form_validation->set_rules('titlu', 'Subtitlu', 'trim');

		//$this->form_validation->set_rules('enable_on', 'lang:enable_on', 'trim');

		//$this->form_validation->set_rules('disable_on', 'lang:disable_on', 'trim|callback_date_check');

		//$this->form_validation->set_rules('lang_id', 'lang:lang_id', 'trim|integer');

		$this->form_validation->set_rules('image', 'Imagine listing', 'trim');

		$this->form_validation->set_rules('banner', 'Imagine principala', 'trim');

		//$this->form_validation->set_rules('link', 'lang:link', 'trim');

		//$this->form_validation->set_rules('new_window', 'lang:new_window', 'trim');

		//$this->form_validation->set_rules('homepage', 'lang:homepage', 'trim');

		$this->form_validation->set_rules('text', 'Text', 'trim');

		//$this->form_validation->set_rules('short_text', 'Scurta descriere', 'trim');

		

		if($this->input->post('submit'))

		{

			//reset the product forms that were submitted in the post

			$data['images']				= $this->input->post('images');

		}

		

		if ($this->form_validation->run() == false)

		{

			$data['error'] = validation_errors();

			$this->load->view($this->config->item('admin_folder').'/events/event_form', $data);

		}

		else

		{	

			

			$uploaded	= $this->upload->do_upload('image');

			$save['id']			= $id;

			$save['title']			= $this->input->post('title');

			$save['titlu']			= $this->input->post('titlu');

			$save['text']			= $this->input->post('text');

			$save['seo_title']	= $this->input->post('seo_title');

			$save['meta']		= $this->input->post('meta');

			$save['keywords']		= $this->input->post('keywords');

		//	$save['short_text']		= $this->input->post('short_text');

			

			$this->load->helper('text');

			//first check the slug field

			$slug = $this->input->post('slug');

			//if it's empty assign the name field

			if(empty($slug) || $slug=='')

			{

				$slug = $this->input->post('title');

			}

			$slug	= url_title(convert_accented_characters($slug), 'dash', TRUE);

			

			//validate the slug

			$this->load->model('Routes_model');

			if($id)

			{

				$slug		= $this->Routes_model->validate_slug($slug, $event->route_id);

				$route_id	= $event->route_id;

			}

			else

			{

				$slug			= $this->Routes_model->validate_slug($slug);

				$route['slug']	= $slug;	

				$route_id		= $this->Routes_model->save($route);

			}

			

			$save['slug']		= $slug;

			$save['route_id']	= $route_id;

			

			//$save['enable_on']		= format_ymd($this->input->post('enable_on'));

			//$save['disable_on']		= format_ymd($this->input->post('disable_on'));

			//$save['link']			= $this->input->post('link');

			//if($this->input->post('new_window')){$save['new_window']		= $this->input->post('new_window');}else{$save['new_window']		= 0;}

			//if($this->input->post('homepage')){$save['homepage']		= $this->input->post('homepage');}else{$save['homepage']		= 0;}

			//$save['lang_id']	= $this->input->post('lang_id');

			if ($id)

			{

				$save['id']	= $id;

			}

			

			$post_images				= $this->input->post('images');

			if($primary	= $this->input->post('primary_image'))

			{

				if($post_images)

				{

					foreach($post_images as $key => &$pi)

					{

						if($primary == $key)

						{

							$pi['primary']	= true;

							continue;

						}

					}	

				}

				

			}

			$save['images']				= json_encode($post_images);

			

			if(isset($_FILES['banner']) && !empty($_FILES['banner']['name']))

		    {

				//die;

				$config['upload_path']		= 'uploads/events/banners';

				$config['allowed_types']	= 'gif|jpg|png|jpeg';

				$config['max_size']			= $this->config->item('size_limit');

				//$config['max_width']		= '1140';

				//$config['max_height']		= '400';

				$config['encrypt_name']		= true;

				$this->load->library('upload', $config);

				$this->upload->initialize($config); 

				

				$uploaded_banner	= $this->upload->do_upload('banner');

				//print_r($uploaded_banner);die;

				if($id)

				{

					//delete the original file if another is uploaded

					if($uploaded_banner)

					{

						if($data['banner'] != '')

						{

							$file = array();

							$file[] = 'uploads/events/banners/'.$data['banner'];

							//delete the existing file if needed

							foreach($file as $f){if(file_exists($f)){@unlink($f);}}

						}

					}

				 }

				if($uploaded_banner)

				{

					$banner			= $this->upload->data();

					$save['banner']	= $banner['file_name'];

				}

			}

			

			if(isset($_FILES['image']) && !empty($_FILES['image']['name']))

		    {

				$config['upload_path']		= 'uploads/events/images_list';

				$config['allowed_types']	= 'gif|jpg|png|jpeg';

				$config['max_size']			= $this->config->item('size_limit');

				//$config['max_width']		= '1140';

				//$config['max_height']		= '400';

				$config['encrypt_name']		= true;

				$this->load->library('upload', $config);

				$this->upload->initialize($config); 

				

				$uploaded	= $this->upload->do_upload('image');

				if($id)

				{

					//delete the original file if another is uploaded

					if($uploaded)

					{

						if($data['image'] != '')

						{

							$file = array();

							$file[] = 'uploads/events/images_list/'.$data['image'];

							$file[] = 'uploads/events/images_list/small/'.$data['image'];

							//delete the existing file if needed

							foreach($file as $f){if(file_exists($f)){@unlink($f);}}

						}

					}

				}

				if($uploaded)

				{

					$image			= $this->upload->data();

					$save['image']	= $image['file_name'];

					

					$this->load->library('image_lib');

					//this is the larger image

					$config['image_library'] = 'gd2';

					$config['source_image'] = 'uploads/events/images_list/'.$save['image'];

					$config['new_image']	= 'uploads/events/images_list/small/'.$save['image'];

					$config['maintain_ratio'] = TRUE;

					$config['width'] = 510;

					$config['height'] = 383; //orice inaltime

					$this->image_lib->initialize($config);

					$this->image_lib->resize();

					$this->image_lib->clear();

				 }

			}

			

			//$this->event_model->save_event($save);

			$event_id	= $this->event_model->save($save);

			

			//save the route

			$route['id']	= $route_id;

			$route['slug']	= $slug;

			$route['route']	= 'cart/events/'.$event_id;

			

			$this->Routes_model->save($route);

			

			$this->session->set_flashdata('message', lang('message_event_saved'));

			

			redirect($this->config->item('admin_folder').'/events');

		}	

	}



	function date_check()

	{

		

		if ($this->input->post('disable_on') != '')

		{

			if (format_ymd($this->input->post('disable_on')) <= format_ymd($this->input->post('enable_on')))

			{

				$this->form_validation->set_message('date_check', lang('date_error'));

				return FALSE;

			}

		}

		

		return TRUE;

	}

	

	function delete_image($id,$image)

    {

		if ($image)

		{

		    $this->db->update('events',array('image'=>''),array('id'=>$id));

			@unlink('uploads/events/images_list/' . $image);

			@unlink('uploads/events/images_list/small/' . $image);

			

			$this->session->set_flashdata('message', lang('message_delete_imagine'));

			redirect($this->config->item('admin_folder').'/events/form/'.$id);

		}

		else

		{

			$this->session->set_flashdata('error', lang('error_not_found'));

		}

    }

	

	function delete_banner($id,$banner)

    {

		if($banner)

		{

		    $this->db->update('events',array('banner'=>''),array('id'=>$id));

			@unlink('uploads/events/banners/' . $banner);

			

			$this->session->set_flashdata('message', lang('message_delete_imagine'));

			redirect($this->config->item('admin_folder').'/events/form/'.$id);

		}

		else

		{

			$this->session->set_flashdata('error', lang('error_not_found'));

		}

    }

	

	function event_image_form()

	{


		$data['file_name'] = false;

		$data['error']	= false;

		$this->load->view($this->config->item('admin_folder').'/events/iframe/event_image_uploader', $data);

	}

	

	function event_image_upload()

	{

		$data['file_name'] = false;

		$data['error']	= false;

		

		$config['allowed_types'] = 'gif|jpg|png';

		//$config['max_size']	= $this->config->item('size_limit');

		$config['upload_path'] = 'uploads/events/galerie_foto/full';

		$config['encrypt_name'] = true;

		$config['remove_spaces'] = true;



		$this->load->library('upload', $config);

		

		if ( $this->upload->do_upload())

		{

			$upload_data	= $this->upload->data();

			

			$this->load->library('image_lib');

			/*

			

			I find that ImageMagick is more efficient that GD2 but not everyone has it

			if your server has ImageMagick then you can change out the line

			

			$config['image_library'] = 'gd2';

			

			with

			

			$config['library_path']		= '/usr/bin/convert'; //make sure you use the correct path to ImageMagic

			$config['image_library']	= 'ImageMagick';

			*/			

			

			//this is the larger image

			$config['image_library'] = 'gd2';

			$config['source_image'] = 'uploads/events/galerie_foto/full/'.$upload_data['file_name'];

			$config['new_image']	= 'uploads/events/galerie_foto/small/'.$upload_data['file_name'];

			$config['maintain_ratio'] = TRUE;

			$config['width'] = 465;

			$config['height'] = 465; //800/520

			$this->image_lib->initialize($config);

			$this->image_lib->resize();

			$this->image_lib->clear();



			//small image

			/*$config['image_library'] = 'gd2';

			$config['source_image'] = 'uploads/events/images/medium/'.$upload_data['file_name'];

			$config['new_image']	= 'uploads/events/images/small/'.$upload_data['file_name'];

			$config['maintain_ratio'] = TRUE;

			$config['width'] = 235;

			$config['height'] = 235;

			$this->image_lib->initialize($config); 

			$this->image_lib->resize();

			$this->image_lib->clear();*/



			//cropped thumbnail

			/*$config['image_library'] = 'gd2';

			$config['source_image'] = 'uploads/events/images/small/'.$upload_data['file_name'];

			$config['new_image']	= 'uploads/events/images/thumbnails/'.$upload_data['file_name'];

			$config['maintain_ratio'] = TRUE;

			$config['width'] = 150;

			$config['height'] = 150;

			$this->image_lib->initialize($config); 	

			$this->image_lib->resize();	

			$this->image_lib->clear();*/



			$data['file_name']	= $upload_data['file_name'];

		}

		

		if($this->upload->display_errors() != '')

		{

			$data['error'] = $this->upload->display_errors();

		}

		$this->load->view($this->config->item('admin_folder').'/events/iframe/event_image_uploader', $data);

	}

}

?>