<?php

class Categories extends Admin_Controller {	
	
	function __construct()
	{		
		parent::__construct();
		 force_ssl();
		//remove_ssl();
		$this->auth->check_access('Admin', true);
		$this->lang->load('category');
		$this->load->model('Category_model');
		$this->load->helper(array('formatting', 'utility'));
	}
	
	function index()
	{
		//we're going to use flash data and redirect() after form submissions to stop people from refreshing and duplicating submissions
		//$this->session->set_flashdata('message', 'this is our message');
		
		$data['page_title']	= lang('categories');
		$data['categories']	= $this->Category_model->get_categories_tierd();
		
		$this->load->view($this->config->item('admin_folder').'/categories/categories', $data);
	}
	
	//basic category search
	function category_autocomplete()
	{
		$name	= trim($this->input->post('name'));
		$limit	= $this->input->post('limit');
		
		if(empty($name))
		{
			echo json_encode(array());
		}
		else
		{
			$results	= $this->Category_model->category_autocomplete($name, $limit);
			
			$return		= array();
			foreach($results as $r)
			{
				$return[$r->id]	= $r->name;
			}
			echo json_encode($return);
		}
		
	}
	
	function organize($id = false)
	{
		$this->load->helper('form');
		
		if (!$id)
		{
			$this->session->set_flashdata('error', lang('error_must_select'));
			redirect($this->config->item('admin_folder').'/categories');
		}
		
		$data['category']		= $this->Category_model->get_category($id);
		//if the category does not exist, redirect them to the category list with an error
		if (!$data['category'])
		{
			$this->session->set_flashdata('error', lang('error_not_found'));
			redirect($this->config->item('admin_folder').'/categories');
		}
			
		$data['page_title']		= sprintf(lang('organize_category'), $data['category']->name);
		
		$data['category_products']	= $this->Category_model->get_category_products_admin($id);
		$data['parent_id']	=	$id;	
		$this->load->view($this->config->item('admin_folder').'/categories/organize_category', $data);
	}
	
	function process_organization($id)
	{
		$products	= $this->input->post('product');
		$this->Category_model->organize_contents($id, $products);
	}
	
	function form($id = false)
	{
		$this->category_id	= $id;
		$this->load->helper('form');
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('<div class="error">', '</div>');
		
		$data['categories']		= $this->Category_model->get_categories();
		$data['page_title']		= lang('category_form');
		
		//default values are empty if the customer is new
		$data['id']				= '';
		$data['name']			= '';
		$data['slug']			= '';
		$data['description']	= '';
		$data['excerpt']		= '';
		$data['keywords']		= '';
		$data['sequence']		= '';
		$data['image']			= '';
		$data['banner']			= '';
		$data['seo_title']		= '';
		$data['meta']			= '';
		$data['parent_id']		= 0;
		$data['error']			= '';
				
		if ($id)
		{	
			$category		= $this->Category_model->get_category($id);

			//if the category does not exist, redirect them to the category list with an error
			if (!$category)
			{
				$this->session->set_flashdata('error', lang('error_not_found'));
				redirect($this->config->item('admin_folder').'/categories');
			}
			
			//helps us with the slug generation
			$this->category_name	= $this->input->post('slug', $category->slug);
			
			//set values to db values
			$data['id']				= $category->id;
			$data['name']			= $category->name;
			$data['slug']			= $category->slug;
			$data['description']	= $category->description;
			$data['excerpt']		= $category->excerpt;
			$data['keywords']			= $category->keywords;
			$data['sequence']		= $category->sequence;
			$data['parent_id']		= $category->parent_id;
			$data['image']			= $category->image;
			$data['banner']			= $category->banner;
			$data['seo_title']		= $category->seo_title;
			$data['meta']			= $category->meta;
		}
		
		$this->form_validation->set_rules('name', 'lang:name', 'trim|required|max_length[64]');
		$this->form_validation->set_rules('slug', 'lang:slug', 'trim');
		$this->form_validation->set_rules('description', 'lang:description', 'trim');
		$this->form_validation->set_rules('excerpt', 'lang:excerpt', 'trim');
		$this->form_validation->set_rules('sequence', 'lang:sequence', 'trim|integer');
		$this->form_validation->set_rules('parent_id', 'parent_id', 'trim');
		$this->form_validation->set_rules('image', 'lang:image', 'trim');
		$this->form_validation->set_rules('seo_title', 'lang:seo_title', 'trim');
		$this->form_validation->set_rules('meta', 'lang:meta', 'trim');
		$this->form_validation->set_rules('keywords', 'lang:keywords', 'trim');
		
		
		// validate the form
		if ($this->form_validation->run() == FALSE)
		{
			$this->load->view($this->config->item('admin_folder').'/categories/category_form', $data);
		}
		else
		{   
		   
			    /*
				$config['upload_path']		= 'uploads/categories/full';
				$config['allowed_types']	= 'gif|jpg|png';
				$config['max_size']			= $this->config->item('size_limit');
				$config['max_width']		= '3024';
				$config['max_height']		= '2768';
				$config['encrypt_name']		= true;
				$this->load->library('upload', $config);
				$this->upload->initialize($config); 
				
				$uploaded	= $this->upload->do_upload('image');
				if ($id)
				{
					//delete the original file if another is uploaded
					if($uploaded)
					{
						if($data['image'] != '')
						{
							$file = array();
							$file[] = 'uploads/categories/full/'.$data['image'];
							$file[] = 'uploads/categories/medium/'.$data['image'];
							$file[] = 'uploads/categories/small/'.$data['image'];
							//delete the existing file if needed
							foreach($file as $f){if(file_exists($f)){@unlink($f);}}
						}
					}
				}
				else
				{
					if(!$uploaded)
					{//apare eroare daca nu este uploadata o imagine
						$error	= $this->upload->display_errors();
						if($error != lang('error_file_upload'))
						{
							$data['error']	.= $this->upload->display_errors();
							$this->load->view($this->config->item('admin_folder').'/categories/category_form', $data);
							return; //end script here if there is an error
						}
					}
				 }
				 if($uploaded)
				 {
						$image			= $this->upload->data();
						$save['image']	= $image['file_name'];
						
						$this->load->library('image_lib');
						//this is the larger image
						$config['image_library'] = 'gd2';
						$config['source_image'] = 'uploads/categories/full/'.$save['image'];
						$config['new_image']	= 'uploads/categories/medium/'.$save['image'];
						$config['maintain_ratio'] = TRUE;
						$config['width'] = 800;
						$config['height'] = 600;
						$this->image_lib->initialize($config);
						$this->image_lib->resize();
						$this->image_lib->clear();
		
						//small image
						$config['image_library'] = 'gd2';
						$config['source_image'] = 'uploads/categories/medium/'.$save['image'];
						$config['new_image']	= 'uploads/categories/small/'.$save['image'];
						$config['maintain_ratio'] = TRUE;
						$config['width'] = 128;
						$config['height'] = 110;
						$this->image_lib->initialize($config); 
						$this->image_lib->resize();
						$this->image_lib->clear();
				 }*/
			
		  if(isset($_FILES['banner']) && !empty($_FILES['banner']['name']))
		  {
				$config['upload_path']		= 'uploads/categories/banners';
				$config['allowed_types']	= 'gif|jpg|png';
				$config['max_size']			= $this->config->item('size_limit');
				//$config['max_width']		= '980';
				//$config['max_height']		= '140';
				$config['encrypt_name']		= true;
				$this->load->library('upload', $config);
				$this->upload->initialize($config); 
				
				$uploaded_banner	= $this->upload->do_upload('banner');
				if($id)
				{
					//delete the original file if another is uploaded
					if($uploaded_banner)
					{
						if($data['banner'] != '')
						{
							$file = array();
							$file[] = 'uploads/categories/banners/'.$data['banner'];
							$file[] = 'uploads/categories/banners/small/'.$data['banner'];
							//delete the existing file if needed
							foreach($file as $f){if(file_exists($f)){@unlink($f);}}
						}
					}
				}
				if($uploaded_banner)
				{
					$banner			= $this->upload->data();
					$save['banner']	= $banner['file_name'];
					
					$this->load->library('image_lib');
					//this is the larger image
					$config['image_library'] = 'gd2';
					$config['source_image'] = 'uploads/categories/banners/'.$save['banner'];
					$config['new_image']	= 'uploads/categories/banners/small/'.$save['banner'];
					$config['maintain_ratio'] = TRUE;
					$config['width'] = 183;
					$config['height'] = 104;
					$this->image_lib->initialize($config);
					$this->image_lib->resize();
					$this->image_lib->clear();
				 }
			}
			
			if(isset($_FILES['image']) && !empty($_FILES['image']['name']))
		    {
				$config['upload_path']		= 'uploads/categories/images';
				$config['allowed_types']	= 'gif|jpg|png';
				$config['max_size']			= $this->config->item('size_limit');
				//$config['max_width']		= '800';
				//$config['max_height']		= '600';
				$config['encrypt_name']		= true;
				$this->load->library('upload', $config);
				$this->upload->initialize($config); 
				
				$uploaded	= $this->upload->do_upload('image');
				if($id)
				{
					//delete the original file if another is uploaded
					if($uploaded)
					{
						if($data['image'] != '')
						{
							$file = array();
							$file[] = 'uploads/categories/images/'.$data['image'];
							$file[] = 'uploads/categories/images/small/'.$data['image'];
							//delete the existing file if needed
							foreach($file as $f){if(file_exists($f)){@unlink($f);}}
						}
					}
				}
				if($uploaded)
				{
					$image			= $this->upload->data();
					$save['image']	= $image['file_name'];
					
					$this->load->library('image_lib');
					//this is the larger image
					$config['image_library'] = 'gd2';
					$config['source_image'] = 'uploads/categories/images/'.$save['image'];
					$config['new_image']	= 'uploads/categories/images/small/'.$save['image'];
					$config['maintain_ratio'] = TRUE;
					$config['width'] = 440;
					$config['height'] = 330;
					$this->image_lib->initialize($config);
					$this->image_lib->resize();
					$this->image_lib->clear();
				 }
			}
			
			$this->load->helper('text');
			
			//first check the slug field
			$slug = $this->input->post('slug');
			//if it's empty assign the name field
			if(empty($slug) || $slug==''){$slug = $this->input->post('name');}
			$slug	= url_title(convert_accented_characters($slug), 'dash', TRUE);
			
			//validate the slug
			$this->load->model('Routes_model');
			if($id)
			{
				$slug	= $this->Routes_model->validate_slug($slug, $category->route_id);
				$route_id	= $category->route_id;
			}
			else
			{
				$slug	= $this->Routes_model->validate_slug($slug);
				
				$route['slug']	= $slug;	
				$route_id	= $this->Routes_model->save($route);
			}
			
			$save['id']				= $id;
			$save['name']			= $this->input->post('name');
			$save['description']	= $this->input->post('description');
			$save['excerpt']		= $this->input->post('excerpt');
			
			$save['parent_id']		= intval($this->input->post('parent_id'));
			$save['sequence']		= intval($this->input->post('sequence'));
			$save['seo_title']		= $this->input->post('seo_title');
			$save['meta']			= $this->input->post('meta');
            $save['keywords']		= $this->input->post('keywords');
			$save['route_id']		= intval($route_id);
			$save['slug']			= $slug;
			
			$category_id	= $this->Category_model->save($save);
			
			//save the route
			$route['id']	= $route_id;
			$route['slug']	= $slug;
			$route['route']	= 'cart/category/'.$category_id.'';
			
			$this->Routes_model->save($route);
			
			$this->session->set_flashdata('message', lang('message_category_saved'));
			
			//go back to the category list
			redirect($this->config->item('admin_folder').'/categories');
		}
	}
	
	function delete_image($id,$image)
    {
		if ($image)
		{
		    $this->db->update('categories',array('image'=>''),array('id'=>$id));
			@unlink('uploads/categories/images/' . $image);
			@unlink('uploads/categories/images/small/' . $image);
			
			$this->session->set_flashdata('message', lang('message_delete_imagine'));
			redirect($this->config->item('admin_folder').'/categories/form/'.$id);
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_not_found'));
		}
    }
	
	function delete_banner($id,$banner)
    {
		if($banner)
		{
		    $this->db->update('categories',array('banner'=>''),array('id'=>$id));
			@unlink('uploads/categories/banners/' . $banner);
			@unlink('uploads/categories/banners/small/' . $banner);
			
			$this->session->set_flashdata('message', lang('message_delete_banner'));
			redirect($this->config->item('admin_folder').'/categories/form/'.$id);
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_not_found'));
		}
    }
	
	function delete($id)
	{
		
		$category	= $this->Category_model->get_category($id);
		//if the category does not exist, redirect them to the customer list with an error
		if ($category)
		{
			$this->load->model('Routes_model');
			
			$this->Routes_model->delete($category->route_id);
			$this->Category_model->delete($id);
			
			$this->session->set_flashdata('message', lang('message_delete_category'));
			redirect($this->config->item('admin_folder').'/categories');
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_not_found'));
		}
	}
	
	
}
?>