<?php

class Cart extends Front_Controller {

	function __construct()
	{
		parent::__construct();
		//make sure we're not always behind ssl
		force_ssl();
		//$this->load->library('Securimage');
		//if(isset($_POST)){$_POST = $this->security($_POST);}
		$this->load->helper('date');
		$this->load->helper('build_link');
		$this->load->model(array('Category_model','Product_model'));
		
	}

	function index() 
	{   
	    $this->section = 'home';
	    $lang_id = $this->session->userdata('lang_id'); $lang_id = ($lang_id != "") ? $lang_id : "1";
		
		$this->load->model('box_model');
		
		$this->load->helper('directory');
		//$data['banners']			= $this->Banner_model->get_homepage_banners(10);
		//$data['boxes']				= $this->box_model->get_homepage_boxes(9);
		//$data['boxes_top']				= $this->box_model->get_homepage_boxes_top(9);
		//$data['seo_title']			= $this->meta_title;
		//$data['meta']				= $this->meta_description;
		//$data['keywords']				= $this->keywords;
		
		//print_r($data['boxes']);die;
		$data['homepage']			= true;
		
		$base_url	= $this->uri->segment_array();
		$data['base_url']	= $base_url;
		$base_url			= implode('/', $base_url);
		
		//$data['page']	= $this->Page_model->get_page('46');
		if($lang_id == '2')
		{
			$data['page']	= $this->Page_model->get_page('48');
			$data['boxes']				= $this->box_model->get_homepage_boxes_multilingv(20,$lang_id);
		}
		elseif($lang_id == '1')
		{
			$data['page']	= $this->Page_model->get_page('46');
			$data['boxes']				= $this->box_model->get_homepage_boxes_multilingv(20,$lang_id);
		}
		$data['image']				= $data['page']->image;
		$data['meta']				= $data['page']->meta;
		$data['keywords']				= $data['page']->keywords;
		$data['seo_title']			= (!empty($data['page']->seo_title))?$data['page']->seo_title:$data['page']->title;
		
		$produse_home = $this->Product_model->get_produse_home();
		$data['produse_home'] = $produse_home;
		
		/*$this->load->model('service_model');
		$data['services']				= $this->service_model->get_homepage_services(6);
		
		$this->load->model('portofolio_model');
		$data['portofolios']				= $this->portofolio_model->get_homepage_portofolios(8);
		
		$this->load->model('Banner_left_model');
		$data['dinsites']= $this->Banner_left_model->get_homepage_banners_left(); //get bannere header*/
		
		$this->load->view('homepage', $data);
	}
	
	
	function abonare()
	{
        $this->load->model('newslettermdl');
		$this->form_validation->set_rules('email', lang('email'), 'required|valid_email');

		if($this->form_validation->run()==FALSE){

			//$this->session->set_userdata(array('newsletter_notification'=>'Introduceti o adresa de e-mail corecta!'));
            echo lang('email_necompletat');
			//redirect();

		}else{


			$_POST['time']=time();

			unset($_POST['save']);

			if($this->newslettermdl->add($_POST)) echo lang('inregistrat_succes'); //$this->session->set_userdata(array('newsletter_notification'=>'V-ati inregistrat cu succes!'));

            else echo lang('email_inregistrat'); //$this->session->set_userdata(array('newsletter_notification'=>'Adresa de e-mail este deja inregistrata!'));

			//redirect();

		}

	}	
	
	function dezabonare()
	{
        $this->load->model('newslettermdl');
		$this->form_validation->set_rules('email', lang('email'), 'required|valid_email');

		if($this->form_validation->run()==FALSE){

			//$this->session->set_userdata(array('newsletter_notification'=>'Introduceti o adresa de e-mail corecta!'));
            echo lang('email_necompletat');
			//redirect();

		}else{
//die;

			$_POST['time']=time();

			unset($_POST['save']);
			//print_r($_POST);die;

			if($this->newslettermdl->dezab($_POST)) echo lang('dezabonare_succes'); //echo 'V-ati dezabonat cu succes!'; //$this->session->set_userdata(array('newsletter_notification'=>'V-ati inregistrat cu succes!'));

			//else echo 'Adresa de e-mail nu este inregistrata!'; //$this->session->set_userdata(array('newsletter_notification'=>'Adresa de e-mail este deja inregistrata!'));
            else echo lang('email_neinregistrat');
			//redirect();

		}

	}	

	function page($id = false)
	{
		
		//if there is no page id provided redirect to the homepage.
		$data['page']	= $this->Page_model->get_page($id);
		if(!$data['page'])
		{
			show_404();
		}
		$this->section=$data['page']->slug;
		$this->load->model('Page_model');
		$data['base_url']			= $this->uri->segment_array();
		
		$data['id']			= $data['page']->id;
		$data['page_title']			= $data['page']->title;
		$data['menu_title']			= $data['page']->menu_title;
		$data['slug']			= $data['page']->slug;
		$data['meta']				= $data['page']->meta;
		$data['keywords']				= $data['page']->keywords;
		$data['image']				= $data['page']->image;
		$data['banner']				= $data['page']->banner;
		$data['seo_title']			= (!empty($data['page']->seo_title))?$data['page']->seo_title:$data['page']->title;

		$data['solutii']=$solutii=$this->Page_model->get_subcategorii($id);  //pagina solutii pentru afaceri
		
		/*if($id=='38' || $id=='49')
		{//die;
			//google maps
				$this->load->library('googlemaps');
				$config['center'] = '44.498928444067204,26.20563689428718';
				$config['zoom'] = 12;
				$this->googlemaps->initialize($config);
				
				$marker = array();
				$marker['position'] = '44.498928444067204,26.20563689428718';
				$this->googlemaps->add_marker($marker);
				$data['map'] = $this->googlemaps->create_map();
			//end google maps		
		
			if($this->form_validation->run('contact')==FALSE) $this->load->view('contact', $data);	
			else
			{
				if($this->securimage->check($this->input->post('captcha')) == true)
				{
					$config['mailtype']="html";
					$config['protocol']="mail";
					$this->load->library('email');
					$this->email->initialize($config);
					$this->email->from($this->contact_email, 'Contact')	                
							->to($this->administrator_email)
							->subject('Contact')
							->message("<html><head></head>
									   <body>
									   <h3>Mesaj de pe site:</h3>
									   <ul>
									   <li><b>Nume: </b> ".$this->input->post('nume')."</li>
									   <li><b>E-mail: </b> ".$this->input->post('email')."</li>     
									   <li><b>Telefon: </b> ".$this->input->post('phone')."</li>                                                                    
									   </ul>
									   <p>".$this->input->post('mesaj')."</p> 
									   </body>
									   </html>")
							->send();
					$data['notificare']="Mesajul a fost trimis cu succes. Va multumim!";
					$this->load->view('contact', $data);	
				}
				else
				{
					$data['notificare']="Codul introdus este incorect!";
					$this->load->view('contact', $data);	
				}
			}
		}*/
		/*elseif($id=='37')
		{
			$this->load->model('Form_model');
			$data['forms']	= $this->Form_model->get_page_forms('37');
		    $data['posted_forms']	= $this->session->flashdata('form_values');
			$this->form_validation->set_rules('caption', 'Caption');
			//print_r($data['posted_forms']);die;
			$data['slug']	= $this->Page_model->get_slug($id);
			$pag = $this->Page_model->get_pag($id);
			
			//daca este apasat butonul trimite
			if($this->input->post('nemultumiri'))
		    {
				if ($this->form_validation->run() == FALSE) $this->load->view('nemultumiri', $data);	
				else
				{
				    $post_forms 	= $this->input->post('form');	
					$status = $this->Form_model->validate_page_forms($pag, $post_forms);
					//daca nu sunt completate toate campurile obligatorii
					if( ! $status['validated'])
					{
						$this->session->set_flashdata('error', $status['message']);
						$this->session->set_flashdata('form_values', $post_forms);
						//$data['post_forms']	= $post_forms;
						redirect($this->Page_model->get_slug($id));
					}
					elseif($this->securimage->check($this->input->post('captcha')) == false)
					{//daca nu este completat captcha
							$data['post_forms']	= $post_forms;
							$data['notificare']="Codul de securitate introdus este incorect!";
							$this->load->view('nemultumiri', $data);	
					} 
					else 
					{  //daca totul este corect trimite mail
						$data['post_forms']	= $post_forms;
						$this->session->set_flashdata('form_values', $post_forms);
						$config['mailtype']="html";
						$config['protocol']="mail";
						$this->load->library('email');
						$this->email->initialize($config);
						
						$msg = "<html><head></head><body><h3>Mesaj primit din site:</h3><ul>";  	
						if(count($data['forms']) > 0):
							foreach($data['forms'] as $form):
								   if(isset($form->values[0]))
									{ 
										if(isset($data['post_forms']) && isset($data['post_forms'][$form->id]))
										{
											 $value	= $data['post_forms'][$form->id];
										}
										else{ $value = false;}
										
										if($form->type == 'textfield'):
										$msg .= '<li><b>'.$form->name.': </b>'.$value.'</li>';
										elseif($form->type == 'textarea'):
										$msg .= '<li><b>'.$form->name.': </b>'.$value.'</li>';
										elseif($form->type == 'droplist'):
											  foreach ($form->values as $values):
												if($value == $values->id)
												 {
													$msg .= '<li><b>'.$form->name.': </b>'.$values->name.'</li>';
												 }
											   endforeach;
										elseif($form->type == 'radiolist'):
											  foreach ($form->values as $values):
												if($value == $values->id)
												 {
													$msg .= '<li><b>'.$form->name.': </b>'.$values->name.'</li>';
												 }
											   endforeach;
										elseif($form->type == 'checklist'):
										
											  foreach ($form->values as $values):
												 if(in_array($values->id, $value))
												 {
													$msg .= '<li><b>'.$form->name.': </b>'.$values->name.'</li>';
												 }
											   endforeach;
										endif;
									}
							endforeach;
						endif;
						$msg .= "</ul></body></html>";
						//print_r($msg);die;
			
						$this->email->from($this->contact_email, 'Nemultumiri')	                
									->to($this->administrator_email)
									->subject('Nemultumiri')
									->message($msg)
									->send();
								
						$data['notificare']="Mesajul a fost trimis cu succes!";
						$data['post_forms']='';
						$this->load->view('nemultumiri', $data);	
					}
				}
			}
			else{$this->load->view('nemultumiri', $data);}
		}*/
		//else
		//{		
		    $this->load->view('page', $data);
		//}
	}
	
	function services($id = false)
	{
		
		$this->load->model('Sectiune_model');
		$data['sectiune']	= $this->Sectiune_model->get_sectiune('45');
		
		$this->load->model('service_model');
		$data['service']				= $this->service_model->get_service($id);
		
		if(!$data['service'])
		{
			show_404();
		}
		$this->section=$data['service']->slug;
		$data['base_url']			= $this->uri->segment_array();
		$data['fb_like']			= true;
        
		$data['id']			= $data['service']->id;
		$data['page_title']			= $data['service']->title;
		$data['page_subtitlu']			= $data['service']->titlu;
		$data['page_text']			= $data['service']->text;
		$data['slug']			= $data['service']->slug;
		$data['meta']				= $data['service']->meta;
		$data['keywords']				= $data['service']->keywords;
		$data['image']				= $data['service']->banner;
		//$data['banner']				= $data['service']->banner;
		$data['seo_title']			= (!empty($data['service']->seo_title))?$data['service']->seo_title:$data['service']->title;
		
		//print_r($data['banner']	);die;

	    $this->load->view('serviciu', $data);
	}
	
	function portofolios($id = false)
	{
		$this->load->model('Sectiune_model');
		$data['sectiune']	= $this->Sectiune_model->get_sectiune('46');
		
		$this->load->model('portofolio_model');
		$data['portofolio']				= $this->portofolio_model->get_portofolio($id);
		
		if(!$data['portofolio'])
		{
			show_404();
		}
		$this->section=$data['portofolio']->slug;
		$data['base_url']			= $this->uri->segment_array();
		$data['fb_like']			= true;
        
		$data['id']			= $data['portofolio']->id;
		$data['page_title']			= $data['portofolio']->title;
		$data['page_subtitlu']			= $data['portofolio']->titlu;
		$data['page_text']			= $data['portofolio']->text;
		$data['slug']			= $data['portofolio']->slug;
		$data['meta']				= $data['portofolio']->meta;
		$data['keywords']				= $data['portofolio']->keywords;
		$data['image']				= $data['portofolio']->banner;
		//$data['banner']				= $data['portofolio']->banner;
		$data['seo_title']			= (!empty($data['portofolio']->seo_title))?$data['portofolio']->seo_title:$data['portofolio']->title;
		
		//print_r($data['banner']	);die;

	    $this->load->view('portofoliu', $data);
	}
	
	function contact()
	{
		$lang_id = $this->session->userdata('lang_id'); $lang_id = ($lang_id != "") ? $lang_id : "1";
		
		if($lang_id == '1')
		{
			$data['page']	= $this->Page_model->get_page('49');
		}
		elseif($lang_id == '2')
		{
			$data['page']	= $this->Page_model->get_page('38');
		}
		//if there is no page id provided redirect to the homepage.
		//$data['page']	= $this->Page_model->get_page($id);
		if(!$data['page'])
		{
			show_404();
		}
		$this->section=$data['page']->slug;
		$this->load->model('Page_model');
		$data['base_url']			= $this->uri->segment_array();
		
		$data['id']			= $data['page']->id;
		$data['page_title']			= $data['page']->title;
		$data['menu_title']			= $data['page']->menu_title;
		$data['slug']			= $data['page']->slug;
		$data['meta']				= $data['page']->meta;
		$data['keywords']				= $data['page']->keywords;
		$data['image']				= $data['page']->image;
		$data['banner']				= $data['page']->banner;
		$data['seo_title']			= (!empty($data['page']->seo_title))?$data['page']->seo_title:$data['page']->title;

		//$data['solutii']=$solutii=$this->Page_model->get_subcategorii($id);  //pagina solutii pentru afaceri
		
		//google maps
			/*$this->load->library('googlemaps');
			$config['center'] = '44.43945230118785,26.085788004701953';
			$config['zoom'] = 16;
			$this->googlemaps->initialize($config);
			
			$marker = array();
			$marker['position'] = '44.43945230118785,26.085788004701953';
			$this->googlemaps->add_marker($marker);
			$data['map'] = $this->googlemaps->create_map();*/
		//end google maps	
		
		//google maps
		if($data['page']->latitudine!='' && $data['page']->longitudine!='')
		{
			$this->load->library('googlemaps');
			$config['center'] = $data['page']->latitudine.','.$data['page']->longitudine;
			$config['zoom'] = 18;
			$this->googlemaps->initialize($config);
			
			$marker = array();
			$marker['position'] = $data['page']->latitudine.','.$data['page']->longitudine;
			$this->googlemaps->add_marker($marker);
			$data['map'] = $this->googlemaps->create_map();
		}
		//end google maps		
	    $data['termeni']	= FALSE;	//TRUE daca vrei sa fie bifat automat	
	
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('<div>', '</div>');	
		$this->form_validation->set_rules('nume', lang('nume'), 'trim|required|max_length[32]');
		$this->form_validation->set_rules('email', 'E-mail', 'trim|required|valid_email|max_length[128]');
		$this->form_validation->set_rules('phone', lang('telefon'), 'trim|required|max_length[32]');
		$this->form_validation->set_rules('mesaj', lang('mesaj'), 'trim|required|max_length[255]');
		//$this->form_validation->set_rules('captcha', lang('captcha'), 'trim|required|callback_check_captcha');
		$this->form_validation->set_rules('g-recaptcha-response','Cod Securitate','callback_recaptcha');
		$this->form_validation->set_rules('termeni', 'Prelucrarea datelor personale', 'trim|required');

		//if($this->form_validation->run('contact')==FALSE) $this->load->view('contact', $data);	
		if ($this->form_validation->run() == FALSE)
		{
			//echo validation_errors();
			$this->load->view('contact', $data);	}
		else
		{
			//if($this->securimage->check($this->input->post('captcha')) == true)
			//{
				$this->load->library('email');
				$config['protocol'] = 'mail';
				$config['mailtype']="html";
				$this->email->initialize($config);
			
				$this->email->from($this->contact_email, 'Contact')	                
						->to($this->administrator_email)
						->subject('Contact')
						->message("<html><head></head>
								   <body>
								   <h3>".lang('mesaj_from')."</h3>
								   <ul>
								   <li><b>".lang('nume').": </b> ".$this->input->post('nume')."</li>
								   <li><b>E-mail: </b> ".$this->input->post('email')."</li>     
								   <li><b>".lang('telefon').": </b> ".$this->input->post('phone')."</li>                                                                    
								   </ul>
								   <p>".$this->input->post('mesaj')."</p> 
								   </body>
								   </html>")
						->send();
				$data['notificare']=lang('trimis');
				$this->load->view('contact', $data);	
			/*}
			else
			{
				$data['notificare']=lang('captcha_err');
				$this->load->view('contact', $data);	
			}*/
		}
	}
	
	public function recaptcha($str='')

	  {

		$google_url="https://www.google.com/recaptcha/api/siteverify";

		$secret='6LdCjl0pAAAAAEDkMUIbpiOz4F6cwOfBuJ2796Xg';

		$ip=$_SERVER['REMOTE_ADDR'];

		$url=$google_url."?secret=".$secret."&response=".$str."&remoteip=".$ip;

		$curl = curl_init();

		curl_setopt($curl, CURLOPT_URL, $url);

		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

		curl_setopt($curl, CURLOPT_TIMEOUT, 10);

		curl_setopt($curl, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.2.16) Gecko/20110319 Firefox/3.6.16");

		$res = curl_exec($curl);

		curl_close($curl);

		$res= json_decode($res, true);

		//reCaptcha success check

		if($res['success'])

		{

		  return TRUE;

		}

		else

		{

		  $this->form_validation->set_message('recaptcha', 'Bifati campul reCAPTCHA si incercati din nou.');

		  return FALSE;

		}

	  }
	
	function sectiune($id = false)
	{
		$lang_id = $this->session->userdata('lang_id'); $lang_id = ($lang_id != "") ? $lang_id : "1";
		//if($lang_id == '1'){redirect('/');}
		//if there is no page id provided redirect to the homepage.
		$this->load->model('Sectiune_model');
		//$data['sectiune']	= $this->Sectiune_model->get_sectiune($id);
		$data['sectiune']	= $this->Sectiune_model->get_sectiune_multilingv($id,$lang_id);
		if(!$data['sectiune'])
		{
			show_404();
		}
		$this->section=$data['sectiune']->slug;
		$data['base_url']			= $this->uri->segment_array();
		$data['fb_like']			= true;
        
		$data['id']			= $data['sectiune']->id;
		$data['page_title']			= $data['sectiune']->title;
		$data['menu_title']			= $data['sectiune']->menu_title;
		$data['slug']			= $data['sectiune']->slug;
		$data['meta']				= $data['sectiune']->meta;
		$data['keywords']				= $data['sectiune']->keywords;
		$data['image']				= $data['sectiune']->image;
		$data['banner']				= $data['sectiune']->banner;
		$data['seo_title']			= (!empty($data['sectiune']->seo_title))?$data['sectiune']->seo_title:$data['sectiune']->title;

		if($data['sectiune']->images!='false'){$data['sectiune']->images	= (array)json_decode($data['sectiune']->images);}else{$data['sectiune']->images	=array();}
		
		$this->load->model('fisiere_paginimdl');
		$data['files']=$this->fisiere_paginimdl->items($id);
			
		$data['subcategorii']		= $this->Sectiune_model->get_sectiuni_child_multilingv($id,$lang_id);
		
		//print_r($data['subcategorii']);die;
		
		/*if($id=='45'):
		$this->load->model('service_model');
		$data['services']				= $this->service_model->get_homepage_services();
		endif;
		
		if($id=='46'):
		$this->load->model('portofolio_model');
		$data['portofolios']				= $this->portofolio_model->get_homepage_portofolios();
		endif;*/
		
		/*if($id=='63'):
		$this->load->model('event_model');
		$data['events']				= $this->event_model->get_homepage_events_();
		endif;*/
		
		$this->load->view('sectiune', $data);
	}
	
	function events($id = false)

	{

		$this->load->model('Sectiune_model');

		$data['sectiune']	= $this->Sectiune_model->get_sectiune('63');

		

		$this->load->model('event_model');

		$data['event']				= $this->event_model->get_event($id);

		

		if(!$data['event'])

		{

			show_404();

		}

		$this->section=$data['event']->slug;

		$data['base_url']			= $this->uri->segment_array();

		$data['fb_like']			= true;

        

		$data['id']			= $data['event']->id;

		$data['page_title']			= $data['event']->title;

		$data['page_subtitlu']			= $data['event']->titlu;

		$data['page_text']			= $data['event']->text;

		$data['slug']			= $data['event']->slug;

		$data['meta']				= $data['event']->meta;

		$data['keywords']				= $data['event']->keywords;

		$data['image']				= $data['event']->image;

		//$data['banner']				= $data['event']->banner;

		$data['seo_title']			= (!empty($data['event']->seo_title))?$data['event']->seo_title:$data['event']->title;

		if($data['event']->images!='false'){$data['event']->images	= (array)json_decode($data['event']->images);}else{$data['event']->images	=array();}

	    $this->load->view('partener', $data);

	}
	
	function download_file($id)
	{
		$this->load->model('fisiere_paginimdl');
		$this->load->helper('download');
		$file=$this->fisiere_paginimdl->item($id);
		
		$file_name=$file->fisier;
		$path = $this->config->item('document_root').'uploads/fisiere/'.$file_name; 
		$data=array('file'=>$path,'filename'=>$file->fisier);
		
		$this->load->view('file', $data);
	}
	
	function search_sectiuni($code=false, $page = 0)
	{   //cautare in scetiuni site
		$this->load->model('Search_model');
		$lang_id = $this->session->userdata('lang_id'); $lang_id = ($lang_id != "") ? $lang_id : "1";
		
		//check to see if we have a search term
		/*if(!$code)
		{
			//if the term is in post, save it to the db and give me a reference
			$term		= $this->input->post('term', true);
			$code		= $this->Search_model->record_term($term);
			
			// no code? redirect so we can have the code in place for the sorting.
			// I know this isn't the best way...
			redirect('cart/search/'.$code.'/'.$page);
		}
		else
		{
			//if we have the md5 string, get the term
			$term	= $this->Search_model->get_term($code);
		}*/
		$term		= $this->input->post('term', true);
		//if(empty($term))
		//{
			//if there is still no search term throw an error
			//if there is still no search term throw an error
			//$this->session->set_flashdata('error_search', lang('search_error'));
			//redirect('cart');
		//}
		$data['page_title']			= lang('search');
		$data['seo_title']			= lang('search');
		//fix for the category view page.
		$data['base_url']			= array();
		
		//if(empty($term))
		//{
			//if there is still no search term throw an error
			//$this->load->view('search_error', $data);
		//}
		//else
		//{
	
			$data['page_title']	= lang('search');
		
			//set up pagination
			$this->load->library('pagination');
			//$config['base_url']		= base_url().'cart/search/'.$code.'/';
			$config['base_url']		= base_url().'cart/search/';
			$config['uri_segment']	=3;
			$config['per_page']		= 100000;
			
			$config['first_link'] = '&laquo;';
			$config['first_tag_open'] = '';
			$config['first_tag_close'] = '';
			$config['last_link'] = '&raquo;';
			$config['last_tag_open'] = '';
			$config['last_tag_close'] = '';

			$config['full_tag_open'] = '<div class="paging clearfix">';
			$config['full_tag_close'] = '</div>';
			$config['cur_tag_open'] = '<a class="active" href="#">';
			$config['cur_tag_close'] = '</a>';

			$config['num_tag_open'] = '';
			$config['num_tag_close'] = '';

			$config['prev_link'] = '&laquo;';
			$config['prev_tag_open'] = '';
			$config['prev_tag_close'] = '';

			$config['next_link'] = '&raquo;';
			$config['next_tag_open'] = '';
			$config['next_tag_close'] = '';
			
			$result					= $this->Search_model->search_sectiuni($term,$lang_id, $config['per_page'], $page/*, $sort_by['by'], $sort_by['sort']*/);
			$config['total_rows']	= $result['count'];
			$this->pagination->initialize($config);
	
			$data['sectiuni']		= $result['sectiuni'];
			foreach ($data['sectiuni'] as &$p)
			{
				//$p->images	= (array)json_decode($p->images);
			}
			$this->load->view('search', $data);
		//}
	}
	
	/*function securimage()
	{
        $this->securimage->show();
    }*/
	
	function securimage()
	{
		$this->load->config('csecurimage');
		$active = $this->config->item('si_active');		
		$allsettings = array_merge($this->config->item($active), $this->config->item('si_general'));

		$this->load->library('securimage/securimage');
		$img = new Securimage($allsettings);
		
		//$img->captcha_type = Securimage::SI_CAPTCHA_MATHEMATIC;
		
		$img->show(APPPATH . 'libraries/securimage/backgrounds/bg6.jpg');
	}

    function map() 
	{ 
		$this->load->view('map');	
	}

	function sitemap()
	{
        $data['seo_title']			='Sitemap';
		$data['meta']				= 'Sitemap';
		$data['keywords']				= 'sitemap';
		
		//$data['solutii']=$solutii=$this->Page_model->get_subcategorii('23');
        $this->load->view('sitemap',$data);	
	}
	
	// THIS FUNCTION STRIPSLASHES AND ENCODES HTML ENTITIES FOR SECURITY PURPOSES
	// INPUT: $value REPRESENTING A STRING OR ARRAY TO CLEAN
	// OUTPUT: THE ARRAY OR STRING WITH HTML CHARACTERS ENCODED
	function security($value) {
	if(is_array($value)) {
	 // $value = array_map('security', $value);
	  $value=array_map('cart::security', $value);
	} else {
	  if(!get_magic_quotes_gpc()) {
		$value = htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
	  } else {
		$value = htmlspecialchars(stripslashes($value), ENT_QUOTES, 'UTF-8');
	  }
	  $value = str_replace("\\", "\\\\", $value);
	}
	return $value;
	} // END security() FUNCTION
	
	/*function check_captcha($str)
	{
		if($this->securimage->check($str) == false)
		{
			$this->form_validation->set_message('check_captcha',lang('captcha_err'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}*/
	
	function check_captcha($str)
	{
		$this->load->library('securimage/securimage');
		$securimage = new Securimage();	

		if( ! $securimage->check($str))
		{
			$this->form_validation->set_message('check_captcha',lang('captcha_err'));
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	
	function search($code=false, $page = 0)
	{
		$this->load->model('Search_model');
		
		//check to see if we have a search term
		if(!$code)
		{
			//if the term is in post, save it to the db and give me a reference
			$term		= $this->input->post('term', true);
			$code		= $this->Search_model->record_term($term);
			
			// no code? redirect so we can have the code in place for the sorting.
			// I know this isn't the best way...
			redirect('cart/search/'.$code.'/'.$page);
		}
		else
		{
			//if we have the md5 string, get the term
			$term	= $this->Search_model->get_term($code);
		}
		
		if(empty($term))
		{
			//if there is still no search term throw an error
			//if there is still no search term throw an error
			$this->session->set_flashdata('error_search', lang('search_error'));
			redirect('cart');
		}
		$data['page_title']			= lang('search');
		$data['gift_cards_enabled']	= $this->gift_cards_enabled;
		$data['seo_title']			= lang('search');
		
		//fix for the category view page.
		$data['base_url']			= array();
		
		$sort_array = array(
							'name/asc' => array('by' => 'name', 'sort'=>'ASC'),
							'name/desc' => array('by' => 'name', 'sort'=>'DESC'),
							'price/asc' => array('by' => 'price', 'sort'=>'ASC'),
							'price/desc' => array('by' => 'price', 'sort'=>'DESC'),
							);
		$sort_by	= array('by'=>false, 'sort'=>false);
	
		if(isset($_GET['by']))
		{
			if(isset($sort_array[$_GET['by']]))
			{
				$sort_by	= $sort_array[$_GET['by']];
			}
		}
		

		if(empty($term))
		{
			//if there is still no search term throw an error
			$this->load->view('search_error', $data);
		}
		else
		{
	
			$data['page_title']	= lang('search');
			$data['gift_cards_enabled'] = $this->gift_cards_enabled;
		
			//set up pagination
			$this->load->library('pagination');
			$config['base_url']		= base_url().'cart/search/'.$code.'/';
			$config['uri_segment']	= 4;
			$config['per_page']		= 42;
			
			$config['first_link'] = '&laquo;';
			$config['first_tag_open'] = '';
			$config['first_tag_close'] = '';
			$config['last_link'] = '&raquo;';
			$config['last_tag_open'] = '';
			$config['last_tag_close'] = '';

			$config['full_tag_open'] = '<div class="paginationss"><ul>';
			$config['full_tag_close'] = '</ul></div>';
			$config['cur_tag_open'] = '<li class="active"><a href="#">';
			$config['cur_tag_close'] = '</a></li>';

			$config['num_tag_open'] = '';
			$config['num_tag_close'] = '';

			$config['prev_link'] = '&laquo;';
			$config['prev_tag_open'] = '';
			$config['prev_tag_close'] = '';

			$config['next_link'] = '&raquo;';
			$config['next_tag_open'] = '';
			$config['next_tag_close'] = '';
			
			$result					= $this->Product_model->search_products($term, $config['per_page'], $page, $sort_by['by'], $sort_by['sort']);
			$config['total_rows']	= $result['count'];
			$this->pagination->initialize($config);
	
			$data['products']		= $result['products'];
			foreach ($data['products'] as &$p)
			{
				$p->images	= (array)json_decode($p->images);
				//$p->options	= $this->Option_model->get_product_options($p->id);
				/*if(!empty($p->producers))
				{
				   $producator_id=$p->producers[0];
				   $this->load->model('Producator_model');
				   $p->producator	= $this->Producator_model->get_producator($producator_id);
				}*/
			}
			$this->load->view('search', $data);
		}
	}
	
	function category($id)
	{
		//get the category
		$data['category']			= $this->Category_model->get_category($id);
		$this->section=$data['category']->slug;
		//print_r($data['category']);die;
				
		if (!$data['category'])
		{
			show_404();
		}
		
		//set up pagination
		$segments	= $this->uri->total_segments();
		$base_url	= $this->uri->segment_array();
		
		$url_=$base_url[1];
		
		if($url_==$data['category']->slug)
		{
			$category_parent			= $this->Category_model->get_category($data['category']->parent_id);
			if(!empty($category_parent)){$data['category_parent']=$category_parent;}
		}
		
		if($data['category']->slug == $base_url[count($base_url)])
		{
			$page	= 0;
			$segments++;
		}
		else
		{
			$page	= array_splice($base_url, -1, 1);
			$page	= $page[0];
		}
		
		$data['base_url']	= $base_url;
		$base_url			= implode('/', $base_url);
		
		/*$data['subcategories']		= $this->Category_model->get_categories($data['category']->id); //pt listing subcategorii
		$data['category2']			= $this->Category_model->get_category($data['category']->parent_id);
		$data['subcategories2']		= $this->Category_model->get_categories($data['category']->parent_id); //pt listing produse*/
				
		$data['subcategories']		= $this->Category_model->get_categories($data['category']->id);
		$data['product_columns']	= $this->config->item('product_columns');
		$data['gift_cards_enabled'] = $this->gift_cards_enabled;
		
		$data['meta']		= $data['category']->meta;
		$data['keywords']				= $data['category']->keywords;
		$data['seo_title']	= (!empty($data['category']->seo_title))?$data['category']->seo_title:$data['category']->name;
		$data['page_title']	= $data['category']->name;
		$data['image']				= $data['category']->image;
		$data['banner_imagine']				= $data['category']->banner;
		$data['categ_id']				= $data['category']->id;
		$data['parent_id']				= $data['category']->parent_id;
		
		//print_r($data['banner']	);die;
		$sort_array = array(
							'name/asc' => array('by' => 'products.name', 'sort'=>'ASC'),
							'name/desc' => array('by' => 'products.name', 'sort'=>'DESC'),
							'price/asc' => array('by' => 'products.price', 'sort'=>'ASC'),
							'price/desc' => array('by' => 'products.price', 'sort'=>'DESC'),
							);
		$sort_by	= array('by'=>'sequence', 'sort'=>'ASC');
	
		if(isset($_GET['by']))
		{
			if(isset($sort_array[$_GET['by']]))
			{
				$sort_by	= $sort_array[$_GET['by']];
			}
		}
		
		//set up pagination
		$this->load->library('pagination');
		$config['base_url']		= site_url($base_url);
		$config['uri_segment']	= $segments;
		$config['per_page']		= 21;
		$config['total_rows']	= $this->Product_model->count_products($data['category']->id);
		
		$config['first_link'] = '&laquo;';
		//$config['first_tag_open'] = '<li>';
		//$config['first_tag_close'] = '</li>';
		$config['last_link'] = '&raquo;';
		//$config['last_tag_open'] = '<li>';
		//$config['last_tag_close'] = '</li>';

	    $config['full_tag_open'] = '<div class="paginationss"><ul>';
		$config['full_tag_close'] = '</ul></div>';
		$config['cur_tag_open'] = '<li class="active"><a href="#">';
		$config['cur_tag_close'] = '</a></li>';
		
		//$config['num_tag_open'] = '<li>';
		//$config['num_tag_close'] = '</li>';
		
		$config['prev_link'] = '&laquo;';
		//$config['prev_tag_open'] = '<li>';
		//$config['prev_tag_close'] = '</li>';

		$config['next_link'] = '&raquo;';
		//$config['next_tag_open'] = '<li>';
		//$config['next_tag_close'] = '</li>';
		
		$this->pagination->initialize($config);
		
		//grab the products using the pagination lib
		$data['products']	= $this->Product_model->get_products($data['category']->id, $config['per_page'], $page, $sort_by['by'], $sort_by['sort']);
		//print_r($data['products']);die;
		
		foreach ($data['products'] as &$p)
		{
			$p->images	= (array)json_decode($p->images);
			/*if(!empty($p->producers))
			{
			   $producator_id=$p->producers[0];
			   $this->load->model('Producator_model');
			   $p->producator	= $this->Producator_model->get_producator($producator_id);
			}*/
			//$p->options	= $this->Option_model->get_product_options($p->id);
		}
		//print_r($data['products']);die;
		
		//if($data['category']->parent_id=='0'){$this->load->view('category_with_subcategories', $data);}
		$this->load->view('category_with_products', $data);
		//$this->load->view('category', $data);
	}
	
	function product($id)
	{
		//get the product
		$data['product']	= $this->Product_model->get_product($id);
		
		$data['form']	= $this->Page_model->get_page('46');
		
		//preia id-ul producatorului
		/*if(!empty($data['product']->producers))
		{
		   $producator_id=$data['product']->producers[0];
		   $this->load->model('Producator_model');
		   $data['producator']	= $this->Producator_model->get_producator($producator_id);
		}*/
		
		//print_r($data['product']);die;
		
		if(!$data['product'] || $data['product']->enabled==0)
		{
			show_404();
		}
		
		/*$this->load->model('rating_model');
		$data['grade']	=$this->rating_model->get_grade($id);
		$data['nr_users']	=$this->rating_model->get_nr_users($id);*/
		
		$data['base_url']			= $this->uri->segment_array();
		$slug=$data['base_url'][1];
		
		if($slug!=$data['product']->slug)
		{
			$data['category']			= $this->Category_model->get_category_by_slug($slug);
			//print_r($data['category']);die;
			$category_parent			= $this->Category_model->get_category($data['category']->parent_id);
			$data['subcategories']		= $this->Category_model->get_categories($data['category']->parent_id); //pt listing subcategorii
			
			if(!empty($category_parent)){$data['category_parent']=$category_parent;}
			//print_r($data['category']->slug);die;
			$this->section=$data['category']->slug;
		}
				
		// load the digital language stuff
		$this->lang->load('digital_product');
		
		//$related			= $data['product']->related_products;
		//$data['related']	= array();
		
		$related			= (array)json_decode($data['product']->related_products);
		$data['related']	= array();
		foreach($related as $r)
		{
			$r					= $this->Product_model->get_product($r);
			if($r)
			{
				$r->images			= (array)json_decode($r->images);
				//$r->options			= $this->Option_model->get_product_options($r->id);
				$data['related'][]	= $r;
			}
		}
				
		$data['posted_options']	= $this->session->flashdata('option_values');

		$data['page_title']			= $data['product']->name;
		$data['meta']				= $data['product']->meta;
		$data['keywords']				= $data['product']->keywords;
		$data['seo_title']			= (!empty($data['product']->seo_title))?$data['product']->seo_title:$data['product']->name;
			
		if($data['product']->images == 'false')
		{
			$data['product']->images = array();
		}
		else
		{
			$data['product']->images	= array_values((array)json_decode($data['product']->images));
		}
		
		if($data['product']->colors_images == 'false')
		{
			$data['product']->colors_images = array();
		}
		else
		{
			$data['product']->colors_images	= array_values((array)json_decode($data['product']->colors_images));
		}
		$data['gift_cards_enabled'] = $this->gift_cards_enabled;
		
		//get pdfs
		 $this->load->model('Digital_Product_model');		
		 $fisiere_pdf = $this->Digital_Product_model->get_files_by_product_id($id);  
		 $data['fisiere_pdf']		=$fisiere_pdf;
		//end get pdfs	
		
		//preia id-ul colectiei
		/*if(!empty($data['product']->colectii))
		{
		   if($data['product']->colectii[0]!='0')
		   {
		   $colectie_id=$data['product']->colectii[0];
		   $data['produse_colectie']	= $this->Product_model->get_products_colectii($colectie_id);
		   if(!empty($data['produse_colectie']))
		   {
			foreach ($data['produse_colectie'] as &$p)
				{
					if(!empty($p->producers))
					{
					   $producator_id=$p->producers[0];
					   $this->load->model('Producator_model');
					   $p->producator	= $this->Producator_model->get_producator($producator_id);
					}
				}
			}
		  // print_r($data['produse_colectie']);die;
		   }
		}*/
		
		$data['termeni']	= FALSE;	//TRUE daca vrei sa fie bifat automat	
	
		
		
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('<div>', '</div>');	
		$this->form_validation->set_rules('nume', 'Nume', 'trim|required|max_length[32]');
		$this->form_validation->set_rules('email', 'E-mail', 'trim|required|valid_email|max_length[128]');
		$this->form_validation->set_rules('phone', 'Telefon', 'trim|required|max_length[32]');
		$this->form_validation->set_rules('mesaj', 'Mesaj', 'trim|required|max_length[255]');
		//$this->form_validation->set_rules('captcha', 'Cod securitate', 'trim|required|callback_check_captcha');
		$this->form_validation->set_rules('g-recaptcha-response','Cod Securitate','callback_recaptcha');
		$this->form_validation->set_rules('termeni', 'Prelucrarea datelor personale', 'trim|required');
		
		if ($this->form_validation->run() == FALSE)
		{
			//echo validation_errors();
			$this->load->view('product', $data);	}
		else
		{
				$this->load->library('email');
				$config['protocol'] = 'mail';
				$config['mailtype']="html";
				$this->email->initialize($config);
				
				$this->email->from($this->contact_email)	                
						->to($this->administrator_email)
						->subject('Solicita oferta')
						->message("<html><head></head>
								   <body>
								   <h3>Solicita oferta:</h3>
								   <ul>
								   <li><b>Sunt interesat de acest produs: </b> ".$data['product']->name."</li>
								   <li><b>Nume: </b> ".$this->input->post('nume')."</li>
								   <li><b>E-mail: </b> ".$this->input->post('email')."</li>     
								   <li><b>Telefon: </b> ".$this->input->post('phone')."</li>     
								   </ul>
								   <p>".$this->input->post('mesaj')."</p> 
								   </body>
								   </html>")
						->send();
				$data['notificare']="Mesajul a fost trimis cu succes!";
				$this->load->view('product', $data);	
	     }
		
					
		//$this->load->view('product', $data);
	}
	
	function download($id)
	{
		$this->load->helper('download');
		$this->load->model('Digital_Product_model');
		$filedata = $this->Digital_Product_model->get_files_by_id($id);
		force_download('uploads/digital_uploads/', $filedata[0]['filename']);
	}
	
}
?>