<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There area two reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router what URI segments to use if those provided
| in the URL cannot be matched to a valid route.
|
*/

//$route['404_override'] = '';
$route['default_controller']	= "cart";
$route['404_override'] = 'page_missing';
//$route['translate_uri_dashes'] = FALSE;



//this for the admininstration console
$route['admin']					= 'admin/dashboard';
$route['admin/media/(:any)']		= 'admin/media/$1'; //for editor text admin redactor

//get routes from database
include('database.php');

$route['abonare']="cart/abonare";
$route['dezabonare']="cart/dezabonare";
$route['cart/securimage']="cart/securimage";

$route['captcha']="cart/securimage";
$route['sitemap']="cart/sitemap";

//Administrare newsletter
$route['admin-newsletter-users']="admin/adm_newsletter";
$route['admin-adauga-abonat-newsletter']="admin/adm_newsletter/adauga";
$route['admin-editeaza-abonat-newsletter/:num']="admin/adm_newsletter/editeaza";
$route['admin-sterge-abonat-newsletter/:num']="admin/adm_newsletter/sterge";
$route['admin-newsletter-export']="admin/adm_newsletter/export";
$route['admin-trimite-newsletter']="admin/adm_newsletter/trimite";
$route['admin-arhiva-mesaje']="admin/adm_newsletter/arhiva";
$route['admin-editeaza-mesaj-newsletter/:num']="admin/adm_newsletter/edit_mesaj";
$route['admin-sterge-mesaj-newsletter/:num']="admin/adm_newsletter/sterge_mesaj";


if($db[$active_group]['pconnect'])
{
	$connection = mysqli_connect($db[$active_group]['hostname'],$db[$active_group]['username'],$db[$active_group]['password'],$db[$active_group]['database']);	
}
else
{
	$connection = mysqli_connect($db[$active_group]['hostname'],$db[$active_group]['username'],$db[$active_group]['password'],$db[$active_group]['database']);	
}
mysqli_select_db($connection, $db[$active_group]['database']) or die("Unable to select database");

$routes	= mysqli_query($connection,'SELECT * FROM '.$db[$active_group]['dbprefix'].'routes');

while($row = mysqli_fetch_array($routes))
{
	//if "category" is in the route, then add some stuff for pagination
	if(strpos($row['route'], 'category'))
	{
		$route[$row['slug']] = $row['route'];

		$row['slug'] 	.= '/(:num)';
		$row['route'] 	.= '/$1';
	}
	$route[$row['slug']] = $row['route'];
}

mysqli_free_result($routes);
//in case we're using pconnect
mysqli_close($connection);

$route['produse']="produse/index";

//Administrare fisiere pdf cu text pentru sectiuni
$route['admin-fisiere-pagina/:num']="admin/adm_fisiere_pagini";
$route['admin-adauga-fisier-pagina/:num']="admin/adm_fisiere_pagini/adauga";
$route['admin-editeaza-fisier-pagina/:num']="admin/adm_fisiere_pagini/editeaza";
$route['admin-sterge-fisier-pagina/:num']="admin/adm_fisiere_pagini/sterge";
$route['admin-modifica-pozitie-fisier']="admin/adm_fisiere_pagini/organize";
//$route['admin-modifica-pozitie-fisier/:any']="admin/adm_fisiere_pagini/modifica_pozitie";

$route['contact']="cart/contact";
$route['search']="cart/search";
$route['cart/search/:num']="cart/search/$1";

?>