<?php
Class Category_model extends CI_Model
{

	function get_categories($parent = false)
	{
		if ($parent !== false)
		{
			$this->db->where("parent_id = $parent");
		}
		$this->db->select('id');
		$this->db->order_by('categories.sequence', 'ASC');
		
		//this will alphabetize them if there is no sequence
		$this->db->order_by('name', 'ASC');
		$result	= $this->db->get('categories');
		
		$categories	= array();
		foreach($result->result() as $cat)
		{
			$categories[]	= $this->get_category($cat->id);
		}
		
		return $categories;
	}
	
	
	function get_categories_rss()
	{
		$this->db->select('id');
		$this->db->order_by('categories.parent_id', 'ASC');
		//$this->db->order_by('name', 'ASC');
		$result	= $this->db->get('categories');
		
		$categories	= array();
		foreach($result->result() as $cat)
		{
			$categories[]	= $this->get_category_rss($cat->id);
		}
		
		return $categories;
	}
	
	function get_category_rss($id)
	{ 
	    $this->db->select('categories.id,categories.name,categories.slug');
		$this->db->order_by('sequence', 'DESC');
		return $this->db->get_where('categories', array('id'=>$id))->row();
	}
	
	function category_autocomplete($name, $limit)
	{
		return	$this->db->like('name', $name)->get('categories', $limit)->result();
	}
	
	//this is for building a menu
	function get_categories_tierd($parent=0)
	{
		$categories	= array();
		$result	= $this->get_categories($parent);
		foreach ($result as $category)
		{
			$categories[$category->id]['category']	= $category;
			$categories[$category->id]['children']	= $this->get_categories_tierd($category->id);
		}
		return $categories;
	}
	
	function get_category($id)
	{
		return $this->db->get_where('categories', array('id'=>$id))->row();
	}
	
	function get_category_by_slug($slug)
	{
		return $this->db->get_where('categories', array('slug'=>$slug))->row();
	}
	
	function get_category_products_admin($id)
	{
		$this->db->order_by('sequence', 'ASC');
		$result	= $this->db->get_where('category_products', array('category_id'=>$id));
		$result	= $result->result();
		
		$contents	= array();
		foreach ($result as $product)
		{
			$result2	= $this->db->get_where('products', array('id'=>$product->product_id));
			$result2	= $result2->row();
			
			$contents[]	= $result2;	
		}
		
		return $contents;
	}
	
	function get_category_products($id, $limit, $offset)
	{
		$this->db->order_by('sequence', 'ASC');
		$result	= $this->db->get_where('category_products', array('category_id'=>$id), $limit, $offset);
		$result	= $result->result();
		
		$contents	= array();
		$count		= 1;
		foreach ($result as $product)
		{
			$result2	= $this->db->get_where('products', array('id'=>$product->product_id));
			$result2	= $result2->row();
			
			$contents[$count]	= $result2;
			$count++;
		}
		
		return $contents;
	}
	
	function organize_contents($id, $products)
	{
		//first clear out the contents of the category
		$this->db->where('category_id', $id);
		$this->db->delete('category_products');
		
		//now loop through the products we have and add them in
		$sequence = 0;
		foreach ($products as $product)
		{
			$this->db->insert('category_products', array('category_id'=>$id, 'product_id'=>$product, 'sequence'=>$sequence));
			$sequence++;
		}
	}
	
	function save($category)
	{
		if ($category['id'])
		{
			$this->db->where('id', $category['id']);
			$this->db->update('categories', $category);
			
			return $category['id'];
		}
		else
		{
			$this->db->insert('categories', $category);
			return $this->db->insert_id();
		}
	}
	
	/*function delete($id)
	{
		$this->db->where('id', $id);
		$this->db->delete('categories');
		
		$this->db->where('category_id', $id);
		$this->db->delete('category_products');
	}*/
	
	/////////*delete categories*/////////
	function delete($id)
	{
		$tree=array();
		$this->get_childrens_tree($id,$tree);
		foreach($tree as $key=>$item)
		{
			$categories=$this->get_categories_by_id($key);
			$categories=$categories[0];
			
			$banner=$this->config->item('uploads_path')."uploads/categories/banners/".$categories['banner']; if(is_file($banner)) @unlink($banner); 
			$banner1=$this->config->item('uploads_path')."uploads/categories/banners/small/".$categories['banner']; if(is_file($banner1)) @unlink($banner1); 
			
			$fisier=$this->config->item('uploads_path')."uploads/categories/images/".$categories['image'];
			$fisier2=$this->config->item('uploads_path')."uploads/categories/images/small/".$categories['image'];
	
			if(is_file($fisier)) @unlink($fisier); 
			if(is_file($fisier2)) @unlink($fisier2);
			
			/*if($categories['images']!='false'){$images	= (array)json_decode($categories['images']);}else{$images	=array();}
			if(count($images) > 0):
			  foreach($images as $image):
				 @unlink($this->config->item('uploads_path')."uploads/categories/galerie_foto/small/".$image->filename);
				 @unlink($this->config->item('uploads_path')."uploads/categories/galerie_foto/full/".$image->filename);
			  endforeach;
			endif;*/
			
			//stergem categoria, subcategoriile daca exista; 
			$this->db->delete('categories', array('id' => $key)); 
			//stergem toate routarile categoriei care o stergem si subcategoriilor acesteia
			$this->db->delete('routes', array('id' => $categories['route_id']));
			//stergem toate legaturile cu anumite produse bifate atat pentru categoria stersa cat si pt toate subcategoriile acesteia
			$this->db->delete('category_products', array('category_id' => $key)); 
			
		}
	}
	//luam categoriile in functie de id
	function get_categories_by_id($id)
	{
		$this->db->select('*');
		$this->db->from('categories');
		$this->db->where('categories.id',$id);
		$query = $this->db->get();
		return $query ->result_array();
	}
	//pentru fiecare categorie luam arborele copiilor (subcategoriilor)
	function get_childrens_tree($category_id,&$tree)
	{ 
	   $tree[$category_id] = 1;
	   $sql = "select * from categories where parent_id = '$category_id'";
	   $query = $this->db->query($sql);
	   $rows = $query->result_array();
	   if(count($rows)>0)
	   {
		   foreach($rows as $row)
			   $this->get_childrens_tree($row['id'],$tree);
	   }
	}
	/////////*end delete categories*/////////
}
?>