<?php
Class question_model extends CI_Model
{
	function __construct()
	{
			parent::__construct();
	}

	function get_questions($limit = false)
	{
		if($limit)
		{
			$this->db->limit($limit);
		}
		return $this->db->order_by('sequence asc')->get('questions')->result();
	}
		
	function get_homepage_questions($limit = false)
	{
		$questions	= $this->db->order_by('sequence asc')->get('questions')->result();
		
		$return	= array();
		foreach ($questions as $question)
		{
			if ($question->enable_on == '0000-00-00')
			{
				$enable_test	= false;
				$enable			= '';
			}
			else
			{
				$eo			 	= explode('-', $question->enable_on);
				$enable_test	= $eo[0].$eo[1].$eo[2];
				$enable			= $eo[1].'-'.$eo[2].'-'.$eo[0];
			}

			if ($question->disable_on == '0000-00-00')
			{
				$disable_test	= false;
				$disable		= '';
			}
			else
			{
				$do			 	= explode('-', $question->disable_on);
				$disable_test	= $do[0].$do[1].$do[2];
				$disable		= $do[1].'-'.$do[2].'-'.$do[0];
			}

			$curDate		= date('Ymd');

			if (($enable_test && $enable_test > $curDate) || ($disable_test && $disable_test <= $curDate))
			{
				//fails to make it. rewrite this if statement one day to work opposite of how it does.
			}
			else
			{
				$return[]	= $question;
			}
			
			if($limit && $limit <= count($return))
			{
				break;
			}
		}
		return $return;
	}
	
	function get_homepage_questions_multilingv($limit = false,$lang_id)
	{
		$questions	= $this->db->order_by('sequence asc')->where('lang_id',$lang_id)->get('questions')->result();
		
		$return	= array();
		foreach ($questions as $question)
		{
			if ($question->enable_on == '0000-00-00')
			{
				$enable_test	= false;
				$enable			= '';
			}
			else
			{
				$eo			 	= explode('-', $question->enable_on);
				$enable_test	= $eo[0].$eo[1].$eo[2];
				$enable			= $eo[1].'-'.$eo[2].'-'.$eo[0];
			}

			if ($question->disable_on == '0000-00-00')
			{
				$disable_test	= false;
				$disable		= '';
			}
			else
			{
				$do			 	= explode('-', $question->disable_on);
				$disable_test	= $do[0].$do[1].$do[2];
				$disable		= $do[1].'-'.$do[2].'-'.$do[0];
			}

			$curDate		= date('Ymd');

			if (($enable_test && $enable_test > $curDate) || ($disable_test && $disable_test <= $curDate))
			{
				//fails to make it. rewrite this if statement one day to work opposite of how it does.
			}
			else
			{
				$return[]	= $question;
			}
			
			if($limit && $limit <= count($return))
			{
				break;
			}
		}
		return $return;
	}
	
	
	function get_homepage_questions_top($limit = false)
	{
		$questions	= $this->db->order_by('sequence desc')->where('up','1')->get('questions')->result();
		
		$return	= array();
		foreach ($questions as $question)
		{
			if ($question->enable_on == '0000-00-00')
			{
				$enable_test	= false;
				$enable			= '';
			}
			else
			{
				$eo			 	= explode('-', $question->enable_on);
				$enable_test	= $eo[0].$eo[1].$eo[2];
				$enable			= $eo[1].'-'.$eo[2].'-'.$eo[0];
			}

			if ($question->disable_on == '0000-00-00')
			{
				$disable_test	= false;
				$disable		= '';
			}
			else
			{
				$do			 	= explode('-', $question->disable_on);
				$disable_test	= $do[0].$do[1].$do[2];
				$disable		= $do[1].'-'.$do[2].'-'.$do[0];
			}

			$curDate		= date('Ymd');

			if (($enable_test && $enable_test > $curDate) || ($disable_test && $disable_test <= $curDate))
			{
				//fails to make it. rewrite this if statement one day to work opposite of how it does.
			}
			else
			{
				$return[]	= $question;
			}
			
			if($limit && $limit <= count($return))
			{
				break;
			}
		}
		return $return;
	}
	
	function get_question($id)
	{
		$this->db->where('id', $id);
		$result = $this->db->get('questions');
		$result = $result->row();
		
		if ($result)
		{
			if ($result->enable_on == '0000-00-00')
			{
				$result->enable_on = '';
			}
			
			if ($result->disable_on == '0000-00-00')
			{
				$result->disable_on = '';
			}
		
			return $result;
		}
		else
		{ 
			return array();
		}
	}
	
	function item($id){

		return $this->db->where('id',$id)

						->get('questions')

						->row();
	}
	
	function delete($id)
	{
		
		$fisier=$this->config->item('uploads_path')."uploads/questions/".$this->item($id)->image;
		$fisier2=$this->config->item('uploads_path')."uploads/questions/small/".$this->item($id)->image;
		
		if(is_file($fisier)) @unlink($fisier); 
		if(is_file($fisier2)) @unlink($fisier2);
		
		$question	= $this->get_question($id);
		if ($question)
		{
			$this->db->where('id', $id);
			$this->db->delete('questions');
			
			return 'The "'.$question->title.'" question has been removed.';
		}
		else
		{
			return 'The question could not be found.';
		}
	}
	
	function get_next_sequence()
	{
		$this->db->select('sequence');
		$this->db->order_by('sequence desc');
		$this->db->limit(1);
		$result = $this->db->get('questions');
		$result = $result->row();
		if ($result)
		{
			return $result->sequence + 1;
		}
		else
		{
			return 0;
		}
	}
	
	function save($data)
	{
		if(isset($data['id']))
		{
			$this->db->where('id', $data['id']);
			$this->db->update('questions', $data);
		}
		else
		{
			$data['sequence'] = $this->get_next_sequence();
			$this->db->insert('questions', $data);
		}
	}
	
	function organize($questions)
	{
		foreach ($questions as $sequence => $id)
		{
			$data = array('sequence' => $sequence);
			$this->db->where('id', $id);
			$this->db->update('questions', $data);
		}
	}
}
?>