<?php
Class know_model extends CI_Model
{
	function __construct()
	{
			parent::__construct();
	}

	function get_knows($limit = false)
	{
		if($limit)
		{
			$this->db->limit($limit);
		}
		return $this->db->order_by('sequence asc')->get('knows')->result();
	}
		
	function get_homepage_knows($limit = false)
	{
		$knows	= $this->db->order_by('sequence asc')->get('knows')->result();
		
		$return	= array();
		foreach ($knows as $know)
		{
			if ($know->enable_on == '0000-00-00')
			{
				$enable_test	= false;
				$enable			= '';
			}
			else
			{
				$eo			 	= explode('-', $know->enable_on);
				$enable_test	= $eo[0].$eo[1].$eo[2];
				$enable			= $eo[1].'-'.$eo[2].'-'.$eo[0];
			}

			if ($know->disable_on == '0000-00-00')
			{
				$disable_test	= false;
				$disable		= '';
			}
			else
			{
				$do			 	= explode('-', $know->disable_on);
				$disable_test	= $do[0].$do[1].$do[2];
				$disable		= $do[1].'-'.$do[2].'-'.$do[0];
			}

			$curDate		= date('Ymd');

			if (($enable_test && $enable_test > $curDate) || ($disable_test && $disable_test <= $curDate))
			{
				//fails to make it. rewrite this if statement one day to work opposite of how it does.
			}
			else
			{
				$return[]	= $know;
			}
			
			if($limit && $limit <= count($return))
			{
				break;
			}
		}
		return $return;
	}
	
	function get_homepage_knows_multilingv($limit = false,$lang_id)
	{
		$knows	= $this->db->order_by('sequence asc')->where('lang_id',$lang_id)->get('knows')->result();
		
		$return	= array();
		foreach ($knows as $know)
		{
			if ($know->enable_on == '0000-00-00')
			{
				$enable_test	= false;
				$enable			= '';
			}
			else
			{
				$eo			 	= explode('-', $know->enable_on);
				$enable_test	= $eo[0].$eo[1].$eo[2];
				$enable			= $eo[1].'-'.$eo[2].'-'.$eo[0];
			}

			if ($know->disable_on == '0000-00-00')
			{
				$disable_test	= false;
				$disable		= '';
			}
			else
			{
				$do			 	= explode('-', $know->disable_on);
				$disable_test	= $do[0].$do[1].$do[2];
				$disable		= $do[1].'-'.$do[2].'-'.$do[0];
			}

			$curDate		= date('Ymd');

			if (($enable_test && $enable_test > $curDate) || ($disable_test && $disable_test <= $curDate))
			{
				//fails to make it. rewrite this if statement one day to work opposite of how it does.
			}
			else
			{
				$return[]	= $know;
			}
			
			if($limit && $limit <= count($return))
			{
				break;
			}
		}
		return $return;
	}
	
	
	function get_homepage_knows_top($limit = false)
	{
		$knows	= $this->db->order_by('sequence desc')->where('up','1')->get('knows')->result();
		
		$return	= array();
		foreach ($knows as $know)
		{
			if ($know->enable_on == '0000-00-00')
			{
				$enable_test	= false;
				$enable			= '';
			}
			else
			{
				$eo			 	= explode('-', $know->enable_on);
				$enable_test	= $eo[0].$eo[1].$eo[2];
				$enable			= $eo[1].'-'.$eo[2].'-'.$eo[0];
			}

			if ($know->disable_on == '0000-00-00')
			{
				$disable_test	= false;
				$disable		= '';
			}
			else
			{
				$do			 	= explode('-', $know->disable_on);
				$disable_test	= $do[0].$do[1].$do[2];
				$disable		= $do[1].'-'.$do[2].'-'.$do[0];
			}

			$curDate		= date('Ymd');

			if (($enable_test && $enable_test > $curDate) || ($disable_test && $disable_test <= $curDate))
			{
				//fails to make it. rewrite this if statement one day to work opposite of how it does.
			}
			else
			{
				$return[]	= $know;
			}
			
			if($limit && $limit <= count($return))
			{
				break;
			}
		}
		return $return;
	}
	
	function get_know($id)
	{
		$this->db->where('id', $id);
		$result = $this->db->get('knows');
		$result = $result->row();
		
		if ($result)
		{
			if ($result->enable_on == '0000-00-00')
			{
				$result->enable_on = '';
			}
			
			if ($result->disable_on == '0000-00-00')
			{
				$result->disable_on = '';
			}
		
			return $result;
		}
		else
		{ 
			return array();
		}
	}
	
	function item($id){

		return $this->db->where('id',$id)

						->get('knows')

						->row();
	}
	
	function delete($id)
	{
		$fisier=$this->config->item('uploads_path')."uploads/knows/".$this->item($id)->image;
		$fisier2=$this->config->item('uploads_path')."uploads/knows/small/".$this->item($id)->image;
		
		if(is_file($fisier)) @unlink($fisier); 
		if(is_file($fisier2)) @unlink($fisier2);
		
		$know	= $this->get_know($id);
		if ($know)
		{
			$this->db->where('id', $id);
			$this->db->delete('knows');
			
			return 'The "'.$know->title.'" know has been removed.';
		}
		else
		{
			return 'The know could not be found.';
		}
	}
	
	function get_next_sequence()
	{
		$this->db->select('sequence');
		$this->db->order_by('sequence desc');
		$this->db->limit(1);
		$result = $this->db->get('knows');
		$result = $result->row();
		if ($result)
		{
			return $result->sequence + 1;
		}
		else
		{
			return 0;
		}
	}
	
	function save($data)
	{
		if(isset($data['id']))
		{
			$this->db->where('id', $data['id']);
			$this->db->update('knows', $data);
		}
		else
		{
			$data['sequence'] = $this->get_next_sequence();
			$this->db->insert('knows', $data);
		}
	}
	
	function organize($knows)
	{
		foreach ($knows as $sequence => $id)
		{
			$data = array('sequence' => $sequence);
			$this->db->where('id', $id);
			$this->db->update('knows', $data);
		}
	}
}
?>