<?php
Class Form_model extends CI_Model
{
	function __construct()
	{
		parent::__construct();
		$this->load->helper('formatting_helper');
	}
	
 	/********************************************************************
		forms Management
	********************************************************************/
 
	
	//get page forms
	function get_all_forms($page_id)
	{
		$this->db->where('page_id', $page_id);
		$this->db->order_by('id', 'DESC');
		$result	= $this->db->get('forms');
		
		$return = array();
		foreach($result->result() as $form)
		{
			$form->values	= $this->get_forms_values($form->id);
			$return[]	= $form;
		}
		return $return;
	}
	
	function get_form($id, $as_array = false)
	{
		$result	= $this->db->get_where('forms', array('id'=>$id));
		
		$data	= $result->row();
		
		if($as_array)
		{
			$data->values = $this->get_forms_values($id, true);
		}
		else
		{
			$data->values = $this->get_forms_values($id);
		}
		
		return $data;
	}
	
	function save_form($form, $values)
	{
		if(isset($form['id']))
		{
			$this->db->where('id', $form['id']);
			$this->db->update('forms', $form);
			$id	= $form['id'];
			
			//eliminate existing forms
			$this->delete_forms_values($id);
		}
		else
		{
			$this->db->insert('forms', $form);
			$id	= $this->db->insert_id();
		}
		
		//add forms to the database
		$sequence	= 0;
		foreach($values as $item => $value)
		{
			$value['form_id'] = $id;
			$value['sequence']	= $sequence;
			$value['weight']	= floatval($value['weight']);
			$value['price']		= floatval($value['price']);
			$sequence++;
			$this->db->insert('forms_values', $value);
		}
		return $id;
	}
	
	// for page level forms 
	function clear_forms($page_id)
	{
		// get the list of forms for this page
		$list = $this->db->where('page_id', $page_id)->get('forms')->result();
		
		foreach($list as $opt)
		{
			$this->delete_form($opt->id);
		}
	}
	
	// also deletes child records in forms_values and page_form
	function delete_form($id)
	{
		$this->db->where('id', $id);
		$this->db->delete('forms');
		
		$this->delete_forms_values($id);
	}
	


	/********************************************************************
		form values Management
	********************************************************************/
	
	function get_forms_values($form_id)
	{
		$this->db->where('form_id',$form_id); 
		$this->db->order_by('sequence', 'ASC');
		return $this->db->get('forms_values')->result();
	}
	
	function get_value($value_id) 
	{
		$this->db->where('id', $value_id);
		return $this->db->get('forms_values')->row();
	}
	
	function delete_forms_values($id)
	{
		$this->db->where('form_id', $id);
		$this->db->delete('forms_values');
	}
	

	/********************************************************************
		page forms Management
	********************************************************************/

	function get_page_forms($page_id)
	{
		$this->db->where('page_id',$page_id); 
		$this->db->order_by('sequence', 'ASC');
		
		$result	= $this->db->get('forms');
		
		$return = array();
		foreach($result->result() as $form)
		{
			$form->values	= $this->get_forms_values($form->id);
			$return[]	= $form;
		}
		return $return;
	}

	
	/***************************************************
		forms Live Use Functionality
	****************************************************/
	
	function validate_page_forms(&$page, $post_forms)
	{
		
		if( ! isset($page['id'])) return false;
		
		// set up to catch form errors
		$error = false;
		$msg = 'Campurile urmatoare nu au fost completate si sunt obligatorii:<br/>';
		
		// Get the list of forms for the page 
		//  We will check the submitted forms against this to make sure required forms were selected	
		$db_forms = $this->get_page_forms($page['id']);
		
		// Loop through the forms from the database
		foreach($db_forms as $form)
		{
			// Use the page form to see if we have matching data from the page form
			$form_value = @$post_forms[$form->id];
						
			// are we missing any required values?
			if((int) $form->required && empty($form_value)) 
			{
				// Set our error flag and add to the user message
				//  then continue processing the other forms to built a full list of missing requirements
				$error = true;
				$msg .= "- ". $form->name .'<br/>';	
				continue; // don't bother processing this particular form any further
			}
			
			// process checklist items specially
			   // multi-valued
			if($form->type == 'checklist')
			{

				$opts = array();				
				// tally our adjustments
				
				//check to make sure this is an array before looping
				if(is_array($form_value))
				{
					
					foreach($form_value as $check_value) 
					{
						//$val = $this->get_value($check_value);
						
						foreach($form->values as $check_match)
						{
							if($check_match->id == $check_value)
							{
								$val	= $check_match;
							}
						}
						
						/*$price = '';
						if($val->price > 0)
						{
							$price = ' ('.format_currency($val->price).')';
						}
						$page['price'] 	= $page['price'] + $val->price;
						$page['weight'] 	= $page['weight'] + $val->weight;

						array_push($opts, $val->value.$price);*/
					}
				}
				
				// If only one form was checked, add it as a single value
				if(count($opts)==1) 
				{
					$page['forms'][$form->name] = $opts[0];
				}
				// otherwise, add it as an array of values
				else if(!empty($opts)) 
				{ 
					$page['forms'][$form->name] = $opts;
				}
				
			}
			
			 // handle text fields
			else if($form->type == 'textfield' || $form->type == 'textarea') 
			{
				//get the value and weight of the textfield/textarea and add it!
				
				if($form_value)
				{
					//get the potential price and weight of this field
					$val	= $form->values[0];
										
					//add the weight and price to the page
					//$page['price'] 	= $page['price'] + $val->price;
					//$page['weight'] 	= $page['weight'] + $val->weight;
					
					//if there is additional cost, add it to the item description
					//$price = '';
					//if($val->price > 0)
					//{
					//	$price = ' ('.format_currency($val->price).')';
					//}
					
					//$page['forms'][$form->name] = $form_value.$price;
				}
			}
			
			else
			{
				//make sure that blank forms aren't used
				if ($form_value)
				{
					// we only need the one selected
					//$val = $this->get_value($form_value);
					
					foreach($form->values as $check_match)
					{
						if($check_match->id == $form_value)
						{
							$val	= $check_match;
						}
					}
					
					//adjust page price and weight
					/*$page['price'] 	= $page['price'] + $val->price;
					$page['weight'] 	= $page['weight'] + $val->weight;
					
					$price = '';
					if($val->price > 0)
					{
						$price = ' ('.format_currency($val->price).')';
					}*/
					//add the form to the forms
					//$page['forms'][$form->name] = $val->name.$price.$weight;
					//$page['forms'][$form->name] = $val->name.$price;
				}
			}
		}
		
		if($error)
		{
			return( array( 'validated' => false,
						   'message' => $msg
						  ));
		}
		else
		{
			return( array( 'validated' => true ));
		}
		
	}
}
?>