<?php
Class Categ_model extends CI_Model
{
	function __construct()
	{
			parent::__construct();
	}

	function get_categs($limit = false)
	{
		if($limit)
		{
			$this->db->limit($limit);
		}
		return $this->db->order_by('sequence asc')->get('categs')->result();
	}
		
	function get_homepage_categs($limit = false)
	{
		$categs	= $this->db->order_by('sequence asc')->get('categs')->result();
		
		$return	= array();
		foreach ($categs as $categ)
		{
			if ($categ->enable_on == '0000-00-00')
			{
				$enable_test	= false;
				$enable			= '';
			}
			else
			{
				$eo			 	= explode('-', $categ->enable_on);
				$enable_test	= $eo[0].$eo[1].$eo[2];
				$enable			= $eo[1].'-'.$eo[2].'-'.$eo[0];
			}

			if ($categ->disable_on == '0000-00-00')
			{
				$disable_test	= false;
				$disable		= '';
			}
			else
			{
				$do			 	= explode('-', $categ->disable_on);
				$disable_test	= $do[0].$do[1].$do[2];
				$disable		= $do[1].'-'.$do[2].'-'.$do[0];
			}

			$curDate		= date('Ymd');

			if (($enable_test && $enable_test > $curDate) || ($disable_test && $disable_test <= $curDate))
			{
				//fails to make it. rewrite this if statement one day to work opposite of how it does.
			}
			else
			{
				$return[]	= $categ;
			}
			
			if($limit && $limit <= count($return))
			{
				break;
			}
		}
		return $return;
	}
	
	function get_homepage_categs_multilingv($limit = false,$lang_id)
	{
		$categs	= $this->db->order_by('sequence asc')->where('lang_id',$lang_id)->get('categs')->result();
		
		$return	= array();
		foreach ($categs as $categ)
		{
			if ($categ->enable_on == '0000-00-00')
			{
				$enable_test	= false;
				$enable			= '';
			}
			else
			{
				$eo			 	= explode('-', $categ->enable_on);
				$enable_test	= $eo[0].$eo[1].$eo[2];
				$enable			= $eo[1].'-'.$eo[2].'-'.$eo[0];
			}

			if ($categ->disable_on == '0000-00-00')
			{
				$disable_test	= false;
				$disable		= '';
			}
			else
			{
				$do			 	= explode('-', $categ->disable_on);
				$disable_test	= $do[0].$do[1].$do[2];
				$disable		= $do[1].'-'.$do[2].'-'.$do[0];
			}

			$curDate		= date('Ymd');

			if (($enable_test && $enable_test > $curDate) || ($disable_test && $disable_test <= $curDate))
			{
				//fails to make it. rewrite this if statement one day to work opposite of how it does.
			}
			else
			{
				$return[]	= $categ;
			}
			
			if($limit && $limit <= count($return))
			{
				break;
			}
		}
		return $return;
	}
	
	
	function get_homepage_categs_top($limit = false)
	{
		$categs	= $this->db->order_by('sequence desc')->where('up','1')->get('categs')->result();
		
		$return	= array();
		foreach ($categs as $categ)
		{
			if ($categ->enable_on == '0000-00-00')
			{
				$enable_test	= false;
				$enable			= '';
			}
			else
			{
				$eo			 	= explode('-', $categ->enable_on);
				$enable_test	= $eo[0].$eo[1].$eo[2];
				$enable			= $eo[1].'-'.$eo[2].'-'.$eo[0];
			}

			if ($categ->disable_on == '0000-00-00')
			{
				$disable_test	= false;
				$disable		= '';
			}
			else
			{
				$do			 	= explode('-', $categ->disable_on);
				$disable_test	= $do[0].$do[1].$do[2];
				$disable		= $do[1].'-'.$do[2].'-'.$do[0];
			}

			$curDate		= date('Ymd');

			if (($enable_test && $enable_test > $curDate) || ($disable_test && $disable_test <= $curDate))
			{
				//fails to make it. rewrite this if statement one day to work opposite of how it does.
			}
			else
			{
				$return[]	= $categ;
			}
			
			if($limit && $limit <= count($return))
			{
				break;
			}
		}
		return $return;
	}
	
	function get_categ($id)
	{
		$this->db->where('id', $id);
		$result = $this->db->get('categs');
		$result = $result->row();
		
		if ($result)
		{
			if ($result->enable_on == '0000-00-00')
			{
				$result->enable_on = '';
			}
			
			if ($result->disable_on == '0000-00-00')
			{
				$result->disable_on = '';
			}
		
			return $result;
		}
		else
		{ 
			return array();
		}
	}
	
	function item($id){

		return $this->db->where('id',$id)

						->get('categs')

						->row();
	}
	
	function delete($id)
	{
		$fisier=$this->config->item('uploads_path')."uploads/categs/".$this->item($id)->image;
		$fisier2=$this->config->item('uploads_path')."uploads/categs/small/".$this->item($id)->image;
		
		if(is_file($fisier)) @unlink($fisier); 
		if(is_file($fisier2)) @unlink($fisier2);
		
		$categ	= $this->get_categ($id);
		if ($categ)
		{
			$this->db->where('id', $id);
			$this->db->delete('categs');
			
			return 'The "'.$categ->title.'" categ has been removed.';
		}
		else
		{
			return 'The categ could not be found.';
		}
	}
	
	function get_next_sequence()
	{
		$this->db->select('sequence');
		$this->db->order_by('sequence desc');
		$this->db->limit(1);
		$result = $this->db->get('categs');
		$result = $result->row();
		if ($result)
		{
			return $result->sequence + 1;
		}
		else
		{
			return 0;
		}
	}
	
	function save($data)
	{
		if(isset($data['id']))
		{
			$this->db->where('id', $data['id']);
			$this->db->update('categs', $data);
		}
		else
		{
			$data['sequence'] = $this->get_next_sequence();
			$this->db->insert('categs', $data);
		}
	}
	
	function organize($categs)
	{
		foreach ($categs as $sequence => $id)
		{
			$data = array('sequence' => $sequence);
			$this->db->where('id', $id);
			$this->db->update('categs', $data);
		}
	}
}
?>