<?php
Class Banner_left_model extends CI_Model
{
	function get_banners_left($limit = false)
	{
		if($limit)
		{
			$this->db->limit($limit);
		}
		return $this->db->order_by('sequence asc')->get('banners_left')->result();
	}
	
	function get_homepage_banners_left($limit = false)
	{
		$banners_left	= $this->db->order_by('sequence asc')->get('banners_left')->result();
		//$count	= 1;
		$return	= array();
		foreach ($banners_left as $banner)
		{
			if ($banner->enable_on == '0000-00-00')
			{
				$enable_test	= false;
				$enable			= '';
			}
			else
			{
				$eo			 	= explode('-', $banner->enable_on);
				$enable_test	= $eo[0].$eo[1].$eo[2];
				$enable			= $eo[1].'-'.$eo[2].'-'.$eo[0];
			}

			if ($banner->disable_on == '0000-00-00')
			{
				$disable_test	= false;
				$disable		= '';
			}
			else
			{
				$do			 	= explode('-', $banner->disable_on);
				$disable_test	= $do[0].$do[1].$do[2];
				$disable		= $do[1].'-'.$do[2].'-'.$do[0];
			}

			$curDate		= date('Ymd');

			if (($enable_test && $enable_test > $curDate) || ($disable_test && $disable_test <= $curDate))
			{
				//unset($banner);
			}
			else
			{
				//$count++;
				$return[]	= $banner;
			}
			
			if($limit && $limit <= count($return))
			{
				break;
			}
		}
		
		//print_r($return);die;
		return $return;
	}
	
	function get_banner($id)
	{
		$this->db->where('id', $id);
		$result = $this->db->get('banners_left');
		$result = $result->row();
		
		if ($result)
		{
			if ($result->enable_on == '0000-00-00')
			{
				$result->enable_on = '';
			}
			
			if ($result->disable_on == '0000-00-00')
			{
				$result->disable_on = '';
			}
		
			return $result;
		}
		else
		{ 
			return array();
		}
	}
	
	function item($id){

		return $this->db->where('id',$id)

						->get('banners_left')

						->row();
	}
	
	function delete($id)
	{
		$fisier=$this->config->item('uploads_path')."uploads/banners_left/".$this->item($id)->image;
		$fisier2=$this->config->item('uploads_path')."uploads/banners_left/small/".$this->item($id)->image;
		
		if(is_file($fisier)) @unlink($fisier); 
		if(is_file($fisier2)) @unlink($fisier2);
		
		$banner	= $this->get_banner($id);
		if ($banner)
		{
			$this->db->where('id', $id);
			$this->db->delete('banners_left');
			
			return 'The "'.$banner->title.'" banner has been removed.';
		}
		else
		{
			return 'The banner could not be found.';
		}
	}
	
	function get_next_sequence()
	{//die;
		$this->db->select('sequence');
		$this->db->order_by('sequence asc');
		$this->db->limit(1);
		$result = $this->db->get('banners_left');
		$result = $result->row();
		if ($result)
		{
			return $result->sequence + 1;
		}
		else
		{
			return 0;
		}
	}
	
	function save_banner($data)
	{
		if(isset($data['id']))
		{
			$this->db->where('id', $data['id']);
			$this->db->update('banners_left', $data);
		}
		else
		{
			$data['sequence'] = $this->get_next_sequence();
			$this->db->insert('banners_left', $data);
		}
	}
	
	function organize($banners_left)
	{
		foreach ($banners_left as $sequence => $id)
		{
			$data = array('sequence' => $sequence);
			$this->db->where('id', $id);
			$this->db->update('banners_left', $data);
		}
	}
}
?>