<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Sort
{
    var $ci;
    var $table = false;
    
    var $field_id = false;
    var $value_id = false;
    
    var $field_for_filter = false;
    
    var $field_sort_order = false;
    var $value_sort_order = false;
	

    function Sort($config)
    {    
        $this->ci =& get_instance();
        
        if(isset($config['table']))
            $this->table = $config['table'];
        if(isset($config['field_id']))
            $this->field_id = $config['field_id'];
        if(isset($config['value_id']))
            $this->value_id = $config['value_id'];
        if(isset($config['field_for_filter']))
            $this->field_for_filter = $config['field_for_filter'];
        if(isset($config['field_sort_order']))
            $this->field_sort_order = $config['field_sort_order'];
        if(isset($config['value_sort_order']))
            $this->value_sort_order = $config['value_sort_order'];            
    }
    
    function move()
    {
        $this->ci =& get_instance();
    
        if(empty($this->table) || empty($this->field_id) || empty($this->value_id) || empty($this->field_sort_order) || empty($this->value_sort_order)) die;
        
        $this->ci->db->select('*');
        $this->ci->db->from($this->table);
        $this->ci->db->where($this->field_id, $this->value_id);
        $query = $this->ci->db->get();
        $rows = $query->result_array();
        if(!empty($rows))
        {
            $old_sort_order = $rows[0][$this->field_sort_order];
            $this->ci->db->select('*');
            $this->ci->db->from($this->table);
            $this->ci->db->where($this->field_sort_order, $this->value_sort_order);
            if(!empty($this->field_for_filter))
                $this->ci->db->where($this->field_for_filter, $rows[0][$this->field_for_filter]);
            $query = $this->ci->db->get();
            $rows2 = $query->result_array();
            if(!empty($rows2))
            {
                $row_id2 = $rows2[0][$this->field_id];
                $this->ci->db->update($this->table, array($this->field_sort_order=>$this->value_sort_order), array($this->field_id=>$this->value_id));
                $this->ci->db->update($this->table, array($this->field_sort_order=>$old_sort_order), array($this->field_id=>$row_id2));
            }
        }
    }
    
    /**
    
        Functia move_up_down este folosita pentru a muta o categoria in lista sortata cu o pozitie in sus sau in jos
        
        @param int $category_id id-ul categorie care poate fi incrementata sau decrementata,
        @param string $action accepta doua stringuri 'up' pentru a muta categoria spre inceputul listei si 'down' pentru a muat categoria spre sfarsitul liste sortate.
        
    */
    function move_up_down($action = false)
    {
        $query = $this->ci->db->getwhere($this->table, array($this->field_id => $this->value_id));
        $result = $query->row_array();
        $this->ci->db->select('*');
        $this->ci->db->from($this->table);
        if(!empty($this->field_for_filter)) $this->ci->db->where($this->field_for_filter, $result[$this->field_for_filter]);
        $this->ci->db->orderby($this->field_sort_order);
        $row = $this->ci->db->get();
        $result = $row->result_array();

        if($action == 'up')//daca vream sa decrementam pozitia
        {
            foreach($result as $key => $value)
            {
                if($value[$this->field_id] == $this->value_id)
                {
                    $old_id = $value[$this->field_sort_order]; //vechia pozitie

                    if($key>0)//daca am ajuns la inceput nu se mai incrementeaza pozitia;
                    {  
                        $new_id = $result[$key-1][$this->field_sort_order];//noua pozitie
                        $item_id = $result[$key-1][$this->field_id];//id-ul cu care se va face rocada
                        //setam noua pozitea categoriei decrementate
                        $this->ci->db->update($this->table, array($this->field_sort_order => $new_id), array($this->field_id => $this->value_id));
                        //setam la categoria cu care se face rocada pozitea initiala a categoriei decrementate
                        $this->ci->db->update($this->table, array($this->field_sort_order => $old_id), array($this->field_id => $item_id));
                    }
                }
            }
        }
        
        
        if($action=='down')//daca vream sa incrementam pozitia
        {
            $len = count($result)-1;
            foreach($result as $key => $value)
            {
                if($value[$this->field_id] == $this->value_id)
                {
                    $old_id = $value[$this->field_sort_order];//vechia pozitie
                    if($key<$len)//daca am ajuns la sfarsit nu se mai incrementeaza pozitia;
                    {
                        $new_id = $result[$key+1][$this->field_sort_order];//noua pozitie
                        $item_id = $result[$key+1][$this->field_id];//id-ul categoriei cu care se va face rocada
                        //setam noua pozitea categoriei incrementate
                        $this->ci->db->update($this->table, array($this->field_sort_order => $new_id), array($this->field_id => $this->value_id));
                        //setam la categoria cu care se face rocada pozitea initiala a categoriei incrementate
                        $this->ci->db->update($this->table, array($this->field_sort_order => $old_id), array($this->field_id => $item_id));
                    }
                }
            }
        }
    }
    
    function get_max_sort_order($value_for_filter = false)
    {//print_r($this->field_sort_order);die;
        $this->ci->db->select_max($this->field_sort_order, 'maxim');
        $this->ci->db->from($this->table);
        if(!empty($this->field_for_filter) && !empty($value_for_filter))
            $this->ci->db->where($this->field_for_filter, $value_for_filter);
        $query = $this->ci->db->get();
        $rows = $query->result_array();
        if(count($rows)) return $rows[0]['maxim'];
        return 0;
    }

}
?>