<?php
function format_date($date){	
	if ($date != '' && $date != '0000-00-00')
	{
		$d	= explode('-', $date);
	
		$m	= Array(
		'January'
		,'February'
		,'March'
		,'April'
		,'May'
		,'June'
		,'July'
		,'August'
		,'September'
		,'October'
		,'November'
		,'December'
		);
	
		return $m[$d[1]-1].' '.$d[2].', '.$d[0]; 
	}
	else
	{
		return false;
	}
}
function format_datetime($datetime)
{
	$d	= explode(' ', format_date($datetime));
	
	$t	= $d[2];
	
	$t	= explode(':', $t);
	
	$ap	= 'am';
	if($t[0] > 12)
	{
		$t[0] = $t[0]-12;
		$ap	= 'pm';
	}
	elseif($t[0] == 0)
	{
		$t[0] = 12;
	}
	elseif ($t[0] == 12)
	{
		$ap = 'pm';
	}
	
	return $d[0].' '.$d[1].', '.$d[3].' at '.$t[0].':'.$t[1].$ap;
}

function reverse_format($date)
{
	if(empty($date)) 
	{
		return;
	}
	
	$d = explode('-', $date);
	
	return "{$d[1]}-{$d[2]}-{$d[0]}";
}

function format_ymd($date)
{
	if(empty($date) || $date == '00-00-0000')
	{
		return '';
	}
	else
	{
		$d = explode('-', $date);
		return $d[2].'-'.$d[0].'-'.$d[1];
	}
}

function format_mdy($date)
{
	if(empty($date) || $date == '0000-00-00')
	{
		return '';
	}
	else
	{
		return date('m-d-Y', strtotime($date));
	}
	
}

function format_dmy($date)
{
	if(empty($date) || $date == '0000-00-00')
	{
		return '';
	}
	else
	{
		return date('d-m-Y', strtotime($date));
	}
	
}

function format_ydm($date)
{
	if(empty($date) || $date == '00-00-0000')
	{
		return '';
	}
	else
	{
		$d = explode('-', $date);
		return $d[2].'-'.$d[1].'-'.$d[0];
	}
}




/* End of file welcome.php */
/* Location: ./system/application/helpers/MY_date_helper.php */
?>
