<?php
class sectiuni_en extends Admin_Controller
{
	
	function __construct()
	{
		parent::__construct();
		
		force_ssl();

		$this->auth->check_access('Admin', true);
		$this->load->model('sectiune_model');
		$this->lang->load('sectiune');
		$this->load->helper('form');
		$this->load->library('form_validation');
		$this->lang->load('common');
	}
		
	function index()
	{
		$data['page_title']	= lang('sectiuni');
		//$data['sectiuni']		= $this->sectiune_model->get_sectiuni();
		$data['sectiuni']		= $this->sectiune_model->get_sectiuni_multilingv(0,2);
		
		$this->load->view($this->config->item('admin_folder').'/sectiuni_en/sectiuni', $data);
	}
	
	/********************************************************************
	edit sectiune
	********************************************************************/
	function form($id = false)
	{
		/*$config['upload_path']		= 'uploads/sectiuni';
		$config['allowed_types']	= 'gif|jpg|png';
		$config['max_size']			= $this->config->item('size_limit');
		$config['encrypt_name']		= true;
		$this->load->library('upload', $config);*/
		
		$this->load->helper('url');		
		
		//set the default values
		$data['id']			= '';
		$data['title']		= '';
		$data['menu_title']	= '';
		$data['slug']		= '';
		//$data['sequence']	= 0;
		$data['parent_id']	= 0;
		$data['lang_id']	= 1;
		$data['content']	= '';
		$data['scurta_descriere']	= '';
		$data['seo_title']	= '';
		$data['meta']		= '';
		$data['keywords']		= '';
		$data['image']		= '';
		$data['banner']		= '';
		$data['tip']		= 'sectiune';
		$data['images']				= array();
		
		$data['page_title']	= lang('sectiune_form');
		$data['sectiuni']		= $this->sectiune_model->get_sectiuni_multilingv(0,2);
		
		if($id)
		{
			
			$sectiune			= $this->sectiune_model->get_sectiune($id);
			if(!$sectiune)
			{
				//sectiune does not exist
				$this->session->set_flashdata('error', lang('error_sectiune_not_found'));
				redirect($this->config->item('admin_folder').'/sectiuni_en');
			}
			
			//set values to db values
			$data['id']				= $sectiune->id;
			$data['tip']			= $sectiune->tip;
			$data['parent_id']		= $sectiune->parent_id;
			$data['lang_id']		= $sectiune->lang_id;
			$data['title']			= $sectiune->title;
			$data['menu_title']		= $sectiune->menu_title;
			//$data['sequence']		= $sectiune->sequence;
			$data['content']		= $sectiune->content;
			$data['scurta_descriere']		= $sectiune->scurta_descriere;
			$data['seo_title']		= $sectiune->seo_title;
			$data['meta']			= $sectiune->meta;
			$data['keywords']			= $sectiune->keywords;
			$data['slug']			= $sectiune->slug;
			$data['image']			= $sectiune->image;
			$data['banner']			= $sectiune->banner;
			
			//make sure we haven't submitted the form yet before we pull in the images/related products from the database
			if(!$this->input->post('submit'))
			{
				$data['images']				= (array)json_decode($sectiune->images);
			}
		}
		
		$this->form_validation->set_rules('title', 'lang:title', 'trim|required');
		$this->form_validation->set_rules('menu_title', 'lang:menu_title', 'trim');
		$this->form_validation->set_rules('slug', 'lang:slug', 'trim');
		$this->form_validation->set_rules('seo_title', 'lang:seo_title', 'trim');
		$this->form_validation->set_rules('meta', 'lang:meta', 'trim');
		$this->form_validation->set_rules('keywords', 'lang:keywords', 'trim');
		//$this->form_validation->set_rules('sequence', 'lang:sequence', 'trim|integer');
		$this->form_validation->set_rules('parent_id', 'lang:parent_id', 'trim|integer');
		$this->form_validation->set_rules('lang_id', 'lang:lang_id', 'trim|integer');
		$this->form_validation->set_rules('content', 'lang:content', 'trim');
		$this->form_validation->set_rules('scurta_descriere', 'lang:scurta_descriere', 'trim');
		$this->form_validation->set_rules('image', 'lang:image', 'trim');
		$this->form_validation->set_rules('banner', 'lang:banner', 'trim');
		
		
		if($this->input->post('submit'))
		{
			//reset the product forms that were submitted in the post
			$data['images']				= $this->input->post('images');
		}
		// Validate the form
		if($this->form_validation->run() == false)
		{
			$data['error'] = validation_errors();
			$this->load->view($this->config->item('admin_folder').'/sectiuni_en/sectiune_form', $data);
		}
		else
		{
			$this->load->helper('text');
			
			//first check the slug field
			$slug = $this->input->post('slug');
			
			//if it's empty assign the name field
			if(empty($slug) || $slug=='')
			{
				$slug = $this->input->post('title');
			}
			
			$slug	= url_title(convert_accented_characters($slug), 'dash', TRUE);
			
			//validate the slug
			$this->load->model('Routes_model');
			if($id)
			{
				$slug		= $this->Routes_model->validate_slug($slug, $sectiune->route_id);
				$route_id	= $sectiune->route_id;
			}
			else
			{
				$slug			= $this->Routes_model->validate_slug($slug);
				$route['slug']	= $slug;	
				$route_id		= $this->Routes_model->save($route);
			}
			
			$save = array();
			$save['id']			= $id;
			$save['parent_id']	= $this->input->post('parent_id');
			$save['lang_id']	= $this->input->post('lang_id');
			$save['title']		= $this->input->post('title');
			$save['menu_title']	= $this->input->post('menu_title'); 
			//$save['sequence']	= $this->input->post('sequence');
			$save['content']	= $this->input->post('content');
			$save['scurta_descriere']	= $this->input->post('scurta_descriere');
			$save['seo_title']	= $this->input->post('seo_title');
			$save['meta']		= $this->input->post('meta');
			$save['keywords']		= $this->input->post('keywords');
			$save['route_id']	= $route_id;
			$save['slug']		= $slug;
			$save['tip']		= $this->input->post('tip'); 
			//$save['image']		=  $this->input->post('image');
			//$save['banner']		=  $this->input->post('banner');
			
			//set the menu title to the sectiune title if if is empty
			if ($save['menu_title'] == '')
			{
				$save['menu_title']	= $this->input->post('title');
			}
			
			$post_images				= $this->input->post('images');
			if($primary	= $this->input->post('primary_image'))
			{
				if($post_images)
				{
					foreach($post_images as $key => &$pi)
					{
						if($primary == $key)
						{
							$pi['primary']	= true;
							continue;
						}
					}	
				}
				
			}
			$save['images']				= json_encode($post_images);
			
			if(isset($_FILES['banner']) && !empty($_FILES['banner']['name']))
		    {
				//die;
				$config['upload_path']		= 'uploads/sectiuni/banners';
				$config['allowed_types']	= 'gif|jpg|png';
				$config['max_size']			= $this->config->item('size_limit');
				$config['max_width']		= '980';
				$config['max_height']		= '140';
				$config['encrypt_name']		= true;
				$this->load->library('upload', $config);
				$this->upload->initialize($config); 
				
				$uploaded_banner	= $this->upload->do_upload('banner');
				//print_r($uploaded_banner);die;
				if($id)
				{
					//delete the original file if another is uploaded
					if($uploaded_banner)
					{
						if($data['banner'] != '')
						{
							$file = array();
							$file[] = 'uploads/sectiuni/banners/'.$data['banner'];
							//delete the existing file if needed
							foreach($file as $f){if(file_exists($f)){@unlink($f);}}
						}
					}
				 }
				if($uploaded_banner)
				{
					$banner			= $this->upload->data();
					$save['banner']	= $banner['file_name'];
				}
			}
			
			if(isset($_FILES['image']) && !empty($_FILES['image']['name']))
		    {
				$config['upload_path']		= 'uploads/sectiuni/images';
				$config['allowed_types']	= 'gif|jpg|png';
				$config['max_size']			= $this->config->item('size_limit');
				//$config['max_width']		= '980';
				//$config['max_height']		= '530';
				$config['encrypt_name']		= true;
				$this->load->library('upload', $config);
				$this->upload->initialize($config); 
				
				$uploaded	= $this->upload->do_upload('image');
				if($id)
				{
					//delete the original file if another is uploaded
					if($uploaded)
					{
						if($data['image'] != '')
						{
							$file = array();
							$file[] = 'uploads/sectiuni/images/'.$data['image'];
							$file[] = 'uploads/sectiuni/images/small/'.$data['image'];
							//delete the existing file if needed
							foreach($file as $f){if(file_exists($f)){@unlink($f);}}
						}
					}
				}
				if($uploaded)
				{
					$image			= $this->upload->data();
					$save['image']	= $image['file_name'];
					
					$this->load->library('image_lib');
					//this is the larger image
					$config['image_library'] = 'gd2';
					$config['source_image'] = 'uploads/sectiuni/images/'.$save['image'];
					$config['new_image']	= 'uploads/sectiuni/images/small/'.$save['image'];
					$config['maintain_ratio'] = TRUE;
					$config['width'] = 235;
					$config['height'] = 170; //350/253 - 800/580
					$this->image_lib->initialize($config);
					$this->image_lib->resize();
					$this->image_lib->clear();
				 }
			}
			
			//save the sectiune
			$sectiune_id	= $this->sectiune_model->save($save);
			
			//save the route
			$route['id']	= $route_id;
			$route['slug']	= $slug;
			$route['route']	= 'cart/sectiune/'.$sectiune_id;
			
			$this->Routes_model->save($route);
			
			$this->session->set_flashdata('message', lang('message_saved_sectiune'));
			
			//go back to the sectiune list
			redirect($this->config->item('admin_folder').'/sectiuni_en');
		}
	}
	
	function link_form($id = false)
	{
	
		$this->load->helper('url');
		$this->load->helper('form');
		$this->load->library('form_validation');
		
		//set the default values
		$data['id']			= '';
		$data['tip']			= 'link';
		$data['title']		= '';
		$data['url']		= '';
		$data['new_window']	= false;
		//$data['sequence']	= 0;
		$data['parent_id']	= 0;

		
		$data['page_title']	= lang('link_form');
		$data['sectiuni']		= $this->sectiune_model->get_sectiuni();
		if($id)
		{
			$sectiune			= $this->sectiune_model->get_sectiune($id);

			if(!$sectiune)
			{
				//sectiune does not exist
				$this->session->set_flashdata('error', lang('error_link_not_found'));
				redirect($this->config->item('admin_folder').'/sectiuni_en');
			}
			
			
			//set values to db values
			$data['id']			= $sectiune->id;
			$data['tip']			= $sectiune->tip;
			$data['parent_id']	= $sectiune->parent_id;
			$data['title']		= $sectiune->title;
			$data['url']		= $sectiune->url;
			$data['new_window']	= (bool)$sectiune->new_window;
			//$data['sequence']	= $sectiune->sequence;
		}
		
		$this->form_validation->set_rules('title', 'lang:title', 'trim|required');
		$this->form_validation->set_rules('url', 'lang:url', 'trim|required');
	//	$this->form_validation->set_rules('sequence', 'lang:sequence', 'trim|integer');
		$this->form_validation->set_rules('new_window', 'lang:new_window', 'trim|integer');
		$this->form_validation->set_rules('parent_id', 'lang:parent_id', 'trim|integer');
		
		// Validate the form
		if($this->form_validation->run() == false)
		{
			$this->load->view($this->config->item('admin_folder').'/sectiuni_en/link_form', $data);
		}
		else
		{	
			$save = array();
			$save['id']			= $id;
			$save['parent_id']	= $this->input->post('parent_id');
			$save['title']		= $this->input->post('title');
			$save['menu_title']	= $this->input->post('title'); 
			$save['url']		= $this->input->post('url');
		//	$save['sequence']	= $this->input->post('sequence');
			$save['new_window']	= $this->input->post('new_window');
			$save['tip']		= $this->input->post('tip'); 
			
			//save the sectiune
			$this->sectiune_model->save($save);
			
			$this->session->set_flashdata('message', lang('message_saved_link'));
			
			//go back to the sectiune list
			redirect($this->config->item('admin_folder').'/sectiuni_en');
		}
	}
	
	
	function delete_image($id,$image)
    {
		if ($image)
		{
		    $this->db->update('sectiuni',array('image'=>''),array('id'=>$id));
			@unlink('uploads/sectiuni/images/' . $image);
			@unlink('uploads/sectiuni/images/small/' . $image);
			
			$this->session->set_flashdata('message', lang('message_delete_imagine'));
			redirect($this->config->item('admin_folder').'/sectiuni_en/form/'.$id);
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_not_found'));
		}
    }
	
	function delete_banner($id,$banner)
    {
		if($banner)
		{
		    $this->db->update('sectiuni',array('banner'=>''),array('id'=>$id));
			@unlink('uploads/sectiuni/banners/' . $banner);
			
			$this->session->set_flashdata('message', lang('message_delete_banner'));
			redirect($this->config->item('admin_folder').'/sectiuni_en/form/'.$id);
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_not_found'));
		}
    }
	
	
	/********************************************************************
	delete sectiune
	********************************************************************/
	function delete($id)
	{
		
		$sectiune	= $this->sectiune_model->get_sectiune($id);
		
		if($sectiune)
		{
			$this->load->model('Routes_model');
			
			$this->Routes_model->delete($sectiune->route_id);
			$this->sectiune_model->delete_sectiune($id);
			$this->session->set_flashdata('message', lang('message_deleted_sectiune'));
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_sectiune_not_found'));
		}
		
		redirect($this->config->item('admin_folder').'/sectiuni_en');
	}
	
	/*function organize()
	{
		$sectiuni	= $this->input->post('sectiuni');
		$this->sectiune_model->organize($sectiuni,$parent_id);
	}*/
	
	function move($id,$direction)
	{
		$sequence=$this->sectiune_model->get_sequence($id);
		$target=$this->sectiune_model->get_target_sequence($direction,$sequence);
		if($target==NULL) header('location:'.$this->config->item('base_url').'/admin/sectiuni_en');
		else 
			{
				$this->sectiune_model->move($sequence,$target);
				header('location:'.$this->config->item('base_url').'/admin/sectiuni_en');
			}
	}
	
	function sectiune_image_form()
	{
		$data['file_name'] = false;
		$data['error']	= false;
		$this->load->view($this->config->item('admin_folder').'/sectiuni_en/iframe/sectiune_image_uploader', $data);
	}
	
	function sectiune_image_upload()
	{
		$data['file_name'] = false;
		$data['error']	= false;
		
		$config['allowed_types'] = 'gif|jpg|png';
		//$config['max_size']	= $this->config->item('size_limit');
		$config['upload_path'] = 'uploads/sectiuni/galerie_foto/full';
		$config['encrypt_name'] = true;
		$config['remove_spaces'] = true;

		$this->load->library('upload', $config);
		
		if ( $this->upload->do_upload())
		{
			$upload_data	= $this->upload->data();
			
			$this->load->library('image_lib');
			/*
			
			I find that ImageMagick is more efficient that GD2 but not everyone has it
			if your server has ImageMagick then you can change out the line
			
			$config['image_library'] = 'gd2';
			
			with
			
			$config['library_path']		= '/usr/bin/convert'; //make sure you use the correct path to ImageMagic
			$config['image_library']	= 'ImageMagick';
			*/			
			
			//this is the larger image
			$config['image_library'] = 'gd2';
			$config['source_image'] = 'uploads/sectiuni/galerie_foto/full/'.$upload_data['file_name'];
			$config['new_image']	= 'uploads/sectiuni/galerie_foto/small/'.$upload_data['file_name'];
			$config['maintain_ratio'] = TRUE;
			$config['width'] = 148;
			$config['height'] = 96; //800/520
			$this->image_lib->initialize($config);
			$this->image_lib->resize();
			$this->image_lib->clear();

			//small image
			/*$config['image_library'] = 'gd2';
			$config['source_image'] = 'uploads/sectiuni/images/medium/'.$upload_data['file_name'];
			$config['new_image']	= 'uploads/sectiuni/images/small/'.$upload_data['file_name'];
			$config['maintain_ratio'] = TRUE;
			$config['width'] = 235;
			$config['height'] = 235;
			$this->image_lib->initialize($config); 
			$this->image_lib->resize();
			$this->image_lib->clear();*/

			//cropped thumbnail
			/*$config['image_library'] = 'gd2';
			$config['source_image'] = 'uploads/sectiuni/images/small/'.$upload_data['file_name'];
			$config['new_image']	= 'uploads/sectiuni/images/thumbnails/'.$upload_data['file_name'];
			$config['maintain_ratio'] = TRUE;
			$config['width'] = 150;
			$config['height'] = 150;
			$this->image_lib->initialize($config); 	
			$this->image_lib->resize();	
			$this->image_lib->clear();*/

			$data['file_name']	= $upload_data['file_name'];
		}
		
		if($this->upload->display_errors() != '')
		{
			$data['error'] = $this->upload->display_errors();
		}
		$this->load->view($this->config->item('admin_folder').'/sectiuni_en/iframe/sectiune_image_uploader', $data);
	}
	
	function formular($id = false)
	{
		$this->sectiune_id	= $id;
		$this->load->library('form_validation');
		$this->load->model(array('Form_model'));
		$this->form_validation->set_error_delimiters('<div class="error">', '</div>');
		
		$data['page_title']		= lang('sectiune_form');

		//default values are empty if the sectiune is new
		//$data['id']					= '';

		if ($id)
		{	
			// get sectiune & forms data
			$data['sectiune_forms']	= $this->Form_model->get_sectiune_forms($id);
			$sectiune			= $this->sectiune_model->get_sectiune($id);
			//if the sectiune does not exist, redirect them to the sectiune list with an error
			if (!$sectiune)
			{
				$this->session->set_flashdata('error', lang('error_not_found'));
				redirect($this->config->item('admin_folder').'/sectiuni_en');
			}
			//set values to db values
			$data['id']					= $id;
		}
		
		//no error checking on these
		$this->form_validation->set_rules('caption', 'Caption');

		if($this->input->post('submit'))
		{
			//reset the sectiune forms that were submitted in the post
			$data['sectiune_forms']	= $this->input->post('form');
		}
		
		if ($this->form_validation->run() == FALSE)
		{
			$this->load->view($this->config->item('admin_folder').'/sectiuni_en/formular', $data);
		}
		else
		{
			$save['id']					= $id;
			// format forms
			$forms	= array();
			if($this->input->post('form'))
			{
				//print_r($this->input->post('form'));die;
				foreach ($this->input->post('form') as $keey => $form)
				{
					$forms[]	= $form;
				}
			}	
			// save sectiune 
			///$sectiune_id	= $this->sectiune_model->save($save, $forms,false);
			$this->sectiune_model->save_formular($save, $forms);
			$this->session->set_flashdata('message', lang('message_saved_sectiune'));
	
			//go back to the sectiune list
			redirect($this->config->item('admin_folder').'/sectiuni_en');
		}
	}

}	
?>