<?php

class Settings extends Admin_Controller {
	
	function __construct()
	{
		parent::__construct();
		force_ssl();

		$this->auth->check_access('Admin', true);
		$this->load->model('Settings_model');
		$this->load->model('Messages_model');
		$this->load->model('general_settings_model');
		$this->lang->load('settings');
		$this->lang->load('common');
	}
	
	function index()
	{
		//$data['general_settings'] = $this->general_settings_model->get_list(); //setarile multilingv
		$data['general_settings'] = $this->general_settings_model->get_list(1); //doar setarile din romana
		
		$data['page_title']	= lang('settings');
		$this->load->view($this->config->item('admin_folder').'/settings', $data);
	}
	
	
	
	function delete_message($id)
	{
		$this->Messages_model->delete_message($id);
		
		$this->session->set_flashdata('message', lang('message_deleted_message'));
		redirect($this->config->item('admin_folder').'/settings');
	}
	
	function general_settings_form($id=false)
	{
		$data['page_title'] = lang('general_settings_form');

		$data['id']			= $id;
		$data['name']		= '';
		$data['valoare']	= '';
		$data['deletable']	= 1;
		
		if($id)
		{
			$general_settings = $this->general_settings_model->get_general_settings($id);
			$data['name']		= $general_settings['name'];
			$data['valoare']	= $general_settings['valoare'];
			$data['deletable']	= $general_settings['deletable'];
		}
		
		$this->load->helper('form');
		$this->load->library('form_validation');
		$this->form_validation->set_rules('name', 'lang:settings_name', 'trim|required|max_length[100]');
		//$this->form_validation->set_rules('valoare', 'lang:valoare', 'trim|required|max_length[100]');
		
		if ($this->form_validation->run() == FALSE)
		{
			$data['errors'] = validation_errors();
			$this->load->view($this->config->item('admin_folder').'/general_settings_form', $data);
		}
		else
		{
			
			$save['id']			= $id;
			$save['name']		= $this->input->post('name');
			$save['valoare']	= $this->input->post('valoare');
			
			$this->general_settings_model->save_general_settings($save);
			
			$this->session->set_flashdata('message', lang('general_settings_saved'));
			redirect($this->config->item('admin_folder').'/settings');
		}
	}
	
	function delete_general_settings($id)
	{
		$this->general_settings_model->delete_general_settings($id);
		
		$this->session->set_flashdata('message', lang('general_settings_deleted'));
		redirect($this->config->item('admin_folder').'/settings');
	}
}
?>