<?php
class Services extends Admin_Controller
{
	function __construct()
	{
		parent::__construct();

		force_ssl();
		$this->auth->check_access('Admin', true);
		
		$this->lang->load('service');
		$this->lang->load('common');
		$this->load->model('service_model');
		$this->load->helper('date');

	}
		
	function index()
	{
		$data['services']		= $this->service_model->get_services();
		$data['page_title']		= lang('services');
		
		$this->load->view($this->config->item('admin_folder').'/services/services', $data);
	}
	
	function organize()
	{
		$services	= $this->input->post('services');
		$this->service_model->organize($services);
	}
	
	/*function delete($id)
	{
		$this->service_model->delete($id);
		
		$this->session->set_flashdata('message', lang('message_delete_service'));
		redirect($this->config->item('admin_folder').'/services');
	}*/
	
	function delete($id)
	{
		
		$service	= $this->service_model->get_service($id);
		
		if($service)
		{
			$this->load->model('Routes_model');
			
			$this->Routes_model->delete($service->route_id);
			$this->service_model->delete_service($id);
			$this->session->set_flashdata('message', lang('message_deleted_service'));
		}
		else
		{
			$this->session->set_flashdata('error', 'Serviciul nu a fost gasit.');
		}
		
		redirect($this->config->item('admin_folder').'/services');
	}
	
	/********************************************************************
	this function is called by an ajax script, it re-sorts the services
	********************************************************************/
	
	function form($id = false)
	{
		
		//$config['upload_path']		= 'uploads/services';
		//$config['allowed_types']	= 'gif|jpg|png|jpeg';
		//$config['max_size']			= $this->config->item('size_limit');
		
		//$config['max_width']		= '1920';
	   // $config['max_height']		= '1080';
		$config['encrypt_name']		= true;
		$this->load->library('upload', $config);
		
		
		$this->load->helper('form');
		$this->load->library('form_validation');
		
		//set the default values
		$data	= array(	 'id'=>$id
							,'title'=>''
							,'slug'=>''
							,'titlu'=>''
							//,'lang_id'=>''
							,'short_text'=>''
							,'text'=>''
							//,'enable_on'=>''
							//,'disable_on'=>''
							,'image'=>''
							,'banner'=>''
							,'seo_title'=>''
							,'meta'=>''
							,'keywords'=>''
							,'data_adaugare'=>''
							//,'homepage'=>''
							//,'link'=>''
							//,'new_window'=>false	
						);
		
		if($id)
		{
			$data				= (array) $this->service_model->get_service($id);
			//$data['enable_on']	= format_mdy($data['enable_on']);
			//$data['disable_on']	= format_mdy($data['disable_on']);
			//$data['new_window']	= (bool) $data['new_window'];
			//$data['homepage']	= (bool) $data['homepage'];
			$data['text']	= $data['text'];
			$data['short_text']	= $data['short_text'];
			$data['seo_title']		= $data['seo_title'];
			$data['meta']			= $data['meta'];
			$data['keywords']			= $data['keywords'];
			$data['slug']			= $data['slug'];
			$data['data_adaugare']	= format_mdy($data['data_adaugare']);
			
			$service			= $this->service_model->get_service($id);
		}
		
		$data['page_title']	= lang('service_form');
		
		$this->form_validation->set_rules('title', 'lang:title', 'trim|required|full_decode');
		$this->form_validation->set_rules('slug', 'Url key', 'trim');
		$this->form_validation->set_rules('titlu', 'Subtitlu', 'trim');
		//$this->form_validation->set_rules('enable_on', 'lang:enable_on', 'trim');
		//$this->form_validation->set_rules('disable_on', 'lang:disable_on', 'trim|callback_date_check');
		//$this->form_validation->set_rules('lang_id', 'lang:lang_id', 'trim|integer');
		$this->form_validation->set_rules('image', 'Imagine listing', 'trim');
		$this->form_validation->set_rules('banner', 'Imagine principala', 'trim');
		//$this->form_validation->set_rules('link', 'lang:link', 'trim');
		//$this->form_validation->set_rules('new_window', 'lang:new_window', 'trim');
		//$this->form_validation->set_rules('homepage', 'lang:homepage', 'trim');
		$this->form_validation->set_rules('text', 'Text', 'trim');
		$this->form_validation->set_rules('short_text', 'Scurta descriere', 'trim');
		$this->form_validation->set_rules('data_adaugare', 'Data adaugare', 'trim|required');
		
		if ($this->form_validation->run() == false)
		{
			$data['error'] = validation_errors();
			$this->load->view($this->config->item('admin_folder').'/services/service_form', $data);
		}
		else
		{	
			
			$uploaded	= $this->upload->do_upload('image');
			
			$save['id']			= $id;
			$save['title']			= $this->input->post('title');
			$save['titlu']			= $this->input->post('titlu');
			$save['text']			= $this->input->post('text');
			$save['seo_title']	= $this->input->post('seo_title');
			$save['meta']		= $this->input->post('meta');
			$save['keywords']		= $this->input->post('keywords');
			$save['short_text']		= $this->input->post('short_text');
			
			$save['data_adaugare']		= format_ymd($this->input->post('data_adaugare'));
			
			$this->load->helper('text');
			//first check the slug field
			$slug = $this->input->post('slug');
			//if it's empty assign the name field
			if(empty($slug) || $slug=='')
			{
				$slug = $this->input->post('title');
			}
			$slug	= url_title(convert_accented_characters($slug), 'dash', TRUE);
			
			//validate the slug
			$this->load->model('Routes_model');
			if($id)
			{
				$slug		= $this->Routes_model->validate_slug($slug, $service->route_id);
				$route_id	= $service->route_id;
			}
			else
			{
				$slug			= $this->Routes_model->validate_slug($slug);
				$route['slug']	= $slug;	
				$route_id		= $this->Routes_model->save($route);
			}
			
			$save['slug']		= $slug;
			$save['route_id']	= $route_id;
			//$save['enable_on']		= format_ymd($this->input->post('enable_on'));
			//$save['disable_on']		= format_ymd($this->input->post('disable_on'));
			//$save['link']			= $this->input->post('link');
			//if($this->input->post('new_window')){$save['new_window']		= $this->input->post('new_window');}else{$save['new_window']		= 0;}
			//if($this->input->post('homepage')){$save['homepage']		= $this->input->post('homepage');}else{$save['homepage']		= 0;}
			//$save['lang_id']	= $this->input->post('lang_id');
			if ($id)
			{
				$save['id']	= $id;
			}
			
			if(isset($_FILES['banner']) && !empty($_FILES['banner']['name']))
		    {
				//die;
				$config['upload_path']		= 'uploads/services/banners';
				$config['allowed_types']	= 'gif|jpg|png|jpeg';
				$config['max_size']			= $this->config->item('size_limit');
				//$config['max_width']		= '1920';
				//$config['max_height']		= '600';
				$config['encrypt_name']		= true;
				$this->load->library('upload', $config);
				$this->upload->initialize($config); 
				
				$uploaded_banner	= $this->upload->do_upload('banner');
				//print_r($uploaded_banner);die;
				if($id)
				{
					//delete the original file if another is uploaded
					if($uploaded_banner)
					{
						if($data['banner'] != '')
						{
							$file = array();
							$file[] = 'uploads/services/banners/'.$data['banner'];
							//delete the existing file if needed
							foreach($file as $f){if(file_exists($f)){@unlink($f);}}
						}
					}
				 }
				if($uploaded_banner)
				{
					$banner			= $this->upload->data();
					$save['banner']	= $banner['file_name'];
				}
			}
			
			if(isset($_FILES['image']) && !empty($_FILES['image']['name']))
		    {
				$config['upload_path']		= 'uploads/services/images_list';
				$config['allowed_types']	= 'gif|jpg|png|jpeg';
				$config['max_size']			= $this->config->item('size_limit');
				//$config['max_width']		= '1140';
				//$config['max_height']		= '360';
				$config['encrypt_name']		= true;
				$this->load->library('upload', $config);
				$this->upload->initialize($config); 
				
				$uploaded	= $this->upload->do_upload('image');
				if($id)
				{
					//delete the original file if another is uploaded
					if($uploaded)
					{
						if($data['image'] != '')
						{
							$file = array();
							$file[] = 'uploads/services/images_list/'.$data['image'];
							$file[] = 'uploads/services/images_list/small/'.$data['image'];
							//delete the existing file if needed
							foreach($file as $f){if(file_exists($f)){@unlink($f);}}
						}
					}
				}
				if($uploaded)
				{
					$image			= $this->upload->data();
					$save['image']	= $image['file_name'];
					
					$this->load->library('image_lib');
					//this is the larger image
					$config['image_library'] = 'gd2';
					$config['source_image'] = 'uploads/services/images_list/'.$save['image'];
					$config['new_image']	= 'uploads/services/images_list/small/'.$save['image'];
					$config['maintain_ratio'] = TRUE;
					$config['width'] = 75;
					$config['height'] = 75;
					$this->image_lib->initialize($config);
					$this->image_lib->resize();
					$this->image_lib->clear();
				 }
			}
			
			//save the page  //$this->service_model->save_service($save);
			$service_id	= $this->service_model->save($save);
			
			//save the route
			$route['id']	= $route_id;
			$route['slug']	= $slug;
			$route['route']	= 'cart/services/'.$service_id;
			
			$this->Routes_model->save($route);
			
			$this->session->set_flashdata('message', lang('message_service_saved'));
			
			redirect($this->config->item('admin_folder').'/services');
		}	
	}

	function date_check()
	{
		
		if ($this->input->post('disable_on') != '')
		{
			if (format_ymd($this->input->post('disable_on')) <= format_ymd($this->input->post('enable_on')))
			{
				$this->form_validation->set_message('date_check', lang('date_error'));
				return FALSE;
			}
		}
		
		return TRUE;
	}
	
	function delete_image($id,$image)
    {
		if ($image)
		{
		    $this->db->update('services',array('image'=>''),array('id'=>$id));
			@unlink('uploads/services/images_list/' . $image);
			@unlink('uploads/services/images_list/small/' . $image);
			
			$this->session->set_flashdata('message', lang('message_delete_imagine'));
			redirect($this->config->item('admin_folder').'/services/form/'.$id);
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_not_found'));
		}
    }
	
	function delete_banner($id,$banner)
    {
		if($banner)
		{
		    $this->db->update('services',array('banner'=>''),array('id'=>$id));
			@unlink('uploads/services/banners/' . $banner);
			
			$this->session->set_flashdata('message', lang('message_delete_imagine'));
			redirect($this->config->item('admin_folder').'/services/form/'.$id);
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_not_found'));
		}
    }
}
?>