<?php

class Products extends Admin_Controller {	
	
	private $use_inventory = false;
	
	function __construct()
	{		
		parent::__construct();
		force_ssl();

		$this->auth->check_access('Admin', true);
		
		$this->load->model(array('Category_model','Product_model'));
		$this->load->helper('form');
		$this->load->library('form_validation');
		$this->lang->load('product');
		$this->load->helper('date');
	}

	function index($order_by="name", $sort_order="ASC", $code=0, $page=0, $rows=35)
	{
		
		$data['page_title']	= lang('products');
		
		$data['code']		= $code;
		$term				= false;
		$category_id		= false;
		
		//get the category list for the drop menu
		$data['categories']	= $this->Category_model->get_categories_tierd();
		
		$post				= $this->input->post(null, false);
		$this->load->model('Search_model');
		if($post)
		{
			$term			= json_encode($post);
			$code			= $this->Search_model->record_term($term);
			$data['code']	= $code;
		}
		elseif ($code)
		{
			$term			= $this->Search_model->get_term($code);
		}
		
		//store the search term
		$data['term']		= $term;
		$data['order_by']	= $order_by;
		$data['sort_order']	= $sort_order;
		
		$data['products']	= $this->Product_model->products(array('term'=>$term, 'order_by'=>$order_by, 'sort_order'=>$sort_order, 'rows'=>$rows, 'page'=>$page));

		//total number of products
		$data['total']		= $this->Product_model->products(array('term'=>$term, 'order_by'=>$order_by, 'sort_order'=>$sort_order), true);

		
		$this->load->library('pagination');
		
		$config['base_url']			= site_url($this->config->item('admin_folder').'/products/index/'.$order_by.'/'.$sort_order.'/'.$code.'/');
		$config['total_rows']		= $data['total'];
		$config['per_page']			= $rows;
		$config['uri_segment']		= 7;
		$config['first_link']		= 'First';
		$config['first_tag_open']	= '<li>';
		$config['first_tag_close']	= '</li>';
		$config['last_link']		= 'Last';
		$config['last_tag_open']	= '<li>';
		$config['last_tag_close']	= '</li>';

		$config['full_tag_open']	= '<div class="pagination"><ul>';
		$config['full_tag_close']	= '</ul></div>';
		$config['cur_tag_open']		= '<li class="active"><a href="#">';
		$config['cur_tag_close']	= '</a></li>';
		
		$config['num_tag_open']		= '<li>';
		$config['num_tag_close']	= '</li>';
		
		$config['prev_link']		= '&laquo;';
		$config['prev_tag_open']	= '<li>';
		$config['prev_tag_close']	= '</li>';

		$config['next_link']		= '&raquo;';
		$config['next_tag_open']	= '<li>';
		$config['next_tag_close']	= '</li>';
		
		$this->pagination->initialize($config);
		
		$this->load->view($this->config->item('admin_folder').'/products/products', $data);
	}
	
	//basic category search
	function product_autocomplete()
	{
		$name	= trim($this->input->post('name'));
		$limit	= $this->input->post('limit');
		
		if(empty($name))
		{
			echo json_encode(array());
		}
		else
		{
			$results	= $this->Product_model->product_autocomplete($name, $limit);
			
			$return		= array();
			
			foreach($results as $r)
			{
				$return[$r->id]	= $r->name;
			}
			echo json_encode($return);
		}
		
	}
	
	function bulk_save()
	{
		$products	= $this->input->post('product');
		
		if(!$products)
		{
			$this->session->set_flashdata('error',  lang('error_bulk_no_products'));
			redirect($this->config->item('admin_folder').'/products');
		}
				
		foreach($products as $id=>$product)
		{
			$product['id']	= $id;
			$this->Product_model->save($product);
		}
		
		$this->session->set_flashdata('message', lang('message_bulk_update'));
		redirect($this->config->item('admin_folder').'/products');
	}
	
	function form($id = false, $duplicate = false)
	{
		$this->product_id	= $id;
		$this->load->library('form_validation');
		$this->load->model(array('Category_model', 'Digital_Product_model'));
		$this->lang->load('digital_product');
		$this->form_validation->set_error_delimiters('<div class="error">', '</div>');
		
		//$data['categories']		= $this->Category_model->get_categories_tierd();
		$data['product_list']	= $this->Product_model->get_accesories();
		
		//print_r($data['product_list']);die;
		$data['file_list']		= $this->Digital_Product_model->get_list();
		$data['categories']		= $this->Category_model->get_categories_tierd();
		//$data['producers']		= $this->Producator_model->get_producers_tierd();
		//$data['colectii']		= $this->Colectie_model->get_colectii_tierd();

		$data['page_title']		= lang('product_form');

		//default values are empty if the product is new
		$data['id']					= '';
		//$data['sku']				= '';
		$data['name']				= '';
		//$data['culoare']				= '';
		$data['slug']				= '';
		$data['description']		= '';
		$data['info']		= '';
		$data['excerpt']		= '';
		//$data['embed']		= '';
		//$data['producator']		= '';
		//$data['cod_bare']		= '';
		/*$data['materiale']			= '';
		$data['dimensiune']			= '';
		$data['impachetare']			= '';
		$data['montaj']			= '';*/
		$data['price']				= '';
		$data['saleprice']			= '';
		/*$data['weight']				= '';
		$data['volum']				= '';*/
		//$data['track_stock'] 		= '';
		$data['seo_title']			= '';
		$data['meta']				= '';
		$data['keywords']		= '';
	//	$data['shippable']			= '';
	//	$data['taxable']			= '';
	//	$data['fixed_quantity']		= '';
	//	$data['quantity']			= '';
		$data['enabled']			= '';
		//$data['pret_in_site']			= '';
		//$data['transport_gratuit']			= '';
		//$data['produs_nou']			= '';
	//	$data['produs_home']			= '';
	//	$data['tip_produs']			= '';
		//$data['imagine_site']			= '';
		//$data['produs_promotie']			= '';
		//$data['produs_sugerat']			= '';
				
		/*$data['expire_date']				= date('00-00-0000');
		$data['hours']				= '00';
		$data['minutes']				= '00';
		$data['seconds']				= '00';
		$data['ore']= $ore = array_combine($ore = range(0, 23), $ore);
		$data['minute']= $minute = array_combine($minute = range(0, 59), $minute);
		$data['secunde']= $secunde = array_combine($secunde = range(0, 59), $secunde);*/
		
		//$data['accesoriu']			= '';
		$data['related_products']	= array();
		$data['product_categories']	= array();
		//$data['product_producers']	= array();
		//$data['product_colectii']	= array();
		$data['images']				= array();
		$data['colors_images']				= array();
		
		$data['product_files']		= array();
		$data['image_detail']				= '';
		$data['image_list']				= '';
		
		//$data['oferta_titlu']			= '';
		//$data['oferta_text']			= '';

		//create the photos array for later use
		$data['photos']		= array();

		if ($id)
		{	
			// get the existing file associations and create a format we can read from the form to set the checkboxes
			$pr_files 		= $this->Digital_Product_model->get_associations_by_product($id);
			foreach($pr_files as $f)
			{
				$data['product_files'][]  = $f->file_id;
			}
			
			// get product 
			$product					= $this->Product_model->get_product($id);
			
			//if the product does not exist, redirect them to the product list with an error
			if (!$product)
			{
				$this->session->set_flashdata('error', lang('error_not_found'));
				redirect($this->config->item('admin_folder').'/products');
			}
			
			//helps us with the slug generation
			$this->product_name	= $this->input->post('slug', $product->slug);
			
			//set values to db values
			$data['id']					= $id;
			//$data['sku']				= $product->sku;
			$data['name']				= $product->name;
			
		//	$data['producator']		= $product->producator;
		//	$data['cod_bare']		= $product->cod_bare;
			
			//$data['culoare']				= $product->culoare;
			$data['seo_title']			= $product->seo_title;
			$data['meta']				= $product->meta;
			$data['keywords']			= $product->keywords;
			$data['slug']				= $product->slug;
			$data['description']		= $product->description;
			$data['info']		= $product->info;
			//$data['embed']		= $product->embed;
			$data['excerpt']		= $product->excerpt;
		//	$data['producator']		= $product->producator;
		//	$data['cod_bare']		= $product->cod_bare;
			/*$data['materiale']			= $product->materiale;
			$data['impachetare']			= $product->impachetare;
			$data['montaj']			= $product->montaj;
			$data['dimensiune']			= $product->dimensiune;*/
			$data['price']				= $product->price;
			$data['saleprice']			= $product->saleprice;
			/*$data['weight']				= $product->weight;
			$data['volum']				= $product->volum;*/
		//	$data['track_stock'] 		= $product->track_stock;
			//$data['shippable']			= $product->shippable;
		//	$data['quantity']			= $product->quantity;
			//$data['taxable']			= $product->taxable;
		//	$data['fixed_quantity']		= $product->fixed_quantity;
			$data['enabled']			= $product->enabled;
			//$data['pret_in_site']			= $product->pret_in_site;
			//$data['transport_gratuit']			= $product->transport_gratuit;
			//$data['produs_nou']			= $product->produs_nou;
		//	$data['produs_home']			= $product->produs_home;
		//	$data['tip_produs']			= $product->tip_produs;
			//$data['imagine_site']			= $product->imagine_site;
			//$data['produs_promotie']			= $product->produs_promotie;
			//$data['produs_sugerat']			= $product->produs_sugerat;
			
			//$data['expire_date']				= format_dmy($product->expire_date);
			//print_r($product->expire_date);die;
			
			//$data['hours']				= $product->hours;
			//$data['minutes']				= $product->minutes;
			//$data['seconds']				= $product->seconds;
			
			//$data['accesoriu']			= $product->accesoriu;
			$data['image_detail']			= $product->image_detail;
			$data['image_list']			= $product->image_list;
			
		//	$data['oferta_titlu']			= $product->oferta_titlu;
		//	$data['oferta_text']			= $product->oferta_text;
			
			//make sure we haven't submitted the form yet before we pull in the images/related products from the database
			if(!$this->input->post('submit'))
			{
				$data['product_categories']	= $product->categories;
				//$data['product_producers']	= $product->producers;
				//$data['product_colectii']	= $product->colectii;
				
				//for select related products from search modul
				//$data['related_products']	= $product->related_products;
				
				$data['related_products']	= json_decode($product->related_products);
				$data['images']				= (array)json_decode($product->images);
				$data['colors_images']				= (array)json_decode($product->colors_images);
			}
		}
		
		//if $data['related_products'] is not an array, make it one.
		if(!is_array($data['related_products']))
		{
			$data['related_products']	= array();
		}
		if(!is_array($data['product_categories']))
		{
			$data['product_categories']	= array();
		}
		/*if(!is_array($data['product_producers']))
		{
			$data['product_producers']	= array();
		}
		if(!is_array($data['product_colectii']))
		{
			$data['product_colectii']	= array();
		}*/
		
		//no error checking on these
		$this->form_validation->set_rules('caption', 'Caption');
		$this->form_validation->set_rules('primary_photo', 'Primary');

		//$this->form_validation->set_rules('sku', 'lang:sku', 'trim|required');
		$this->form_validation->set_rules('seo_title', 'lang:seo_title', 'trim');
		$this->form_validation->set_rules('meta', 'lang:meta_data', 'trim');
		$this->form_validation->set_rules('keywords', 'lang:keywords', 'trim');
		$this->form_validation->set_rules('name', 'lang:name', 'trim|required|max_length[255]');
		//$this->form_validation->set_rules('producator', 'lang:producator', 'trim');
		//$this->form_validation->set_rules('cod_bare', 'lang:cod_bare', 'trim');
		//$this->form_validation->set_rules('culoare', 'lang:culoare', 'trim');
		$this->form_validation->set_rules('slug', 'lang:slug', 'trim');
		$this->form_validation->set_rules('description', 'lang:description', 'trim');
		//$this->form_validation->set_rules('embed', 'lang:embed', 'trim');
		$this->form_validation->set_rules('excerpt', 'lang:excerpt', 'trim');
	////	$this->form_validation->set_rules('producator', 'lang:producator', 'trim');
	//	$this->form_validation->set_rules('cod_bare', 'lang:cod_bare', 'trim');
		//$this->form_validation->set_rules('materiale', 'lang:materiale', 'trim');
		//$this->form_validation->set_rules('dimensiune', 'lang:dimensiune', 'trim');
		//$this->form_validation->set_rules('impachetare', 'lang:impachetare', 'trim');
		//$this->form_validation->set_rules('montaj', 'lang:montaj', 'trim');
		$this->form_validation->set_rules('price', 'lang:price', 'trim|numeric|floatval');
		$this->form_validation->set_rules('saleprice', 'lang:saleprice', 'trim|numeric|floatval');
		//$this->form_validation->set_rules('weight', 'lang:weight', 'trim|numeric|floatval');
		//$this->form_validation->set_rules('volum', 'lang:volum', 'trim|numeric');
	/*	$this->form_validation->set_rules('track_stock', 'lang:track_stock', 'trim|numeric');
		$this->form_validation->set_rules('quantity', 'lang:quantity', 'trim|numeric');
		$this->form_validation->set_rules('shippable', 'lang:shippable', 'trim|numeric');
		$this->form_validation->set_rules('taxable', 'lang:taxable', 'trim|numeric');
		$this->form_validation->set_rules('fixed_quantity', 'lang:fixed_quantity', 'trim|numeric');*/
		$this->form_validation->set_rules('enabled', 'lang:enabled', 'trim|numeric');
		
		//$this->form_validation->set_rules('pret_in_site', 'lang:pret_in_site', 'trim|numeric');
		//$this->form_validation->set_rules('transport_gratuit', 'lang:transport_gratuit', 'trim|numeric');
		//$this->form_validation->set_rules('produs_nou', 'lang:produs_nou', 'trim|numeric');
		$this->form_validation->set_rules('produs_home', 'lang:produs_home', 'trim|numeric');
		$this->form_validation->set_rules('tip_produs', 'lang:tip_produs', 'trim|numeric');
		//$this->form_validation->set_rules('imagine_site', 'lang:imagine_site', 'trim|numeric');
		//$this->form_validation->set_rules('produs_promotie', 'lang:produs_promotie', 'trim|numeric');
		//$this->form_validation->set_rules('produs_sugerat', 'lang:produs_sugerat', 'trim|numeric');
		//$this->form_validation->set_rules('accesoriu', 'lang:accesoriu', 'trim|numeric');
		
		$this->form_validation->set_rules('image_detail', 'lang:image_detail', 'trim');
		$this->form_validation->set_rules('image_list', 'lang:image_list', 'trim');
		
		/*$this->form_validation->set_rules('expire_date', 'lang:expire_date', 'required|trim');
		$this->form_validation->set_rules('hours', 'lang:hours', 'required|trim|numeric');
		$this->form_validation->set_rules('minutes', 'lang:minutes', 'required|trim|numeric');
		$this->form_validation->set_rules('seconds', 'lang:seconds', 'required|trim|numeric');*/
		
		//$this->form_validation->set_rules('oferta_titlu', 'lang:oferta_titlu', 'trim');
		//$this->form_validation->set_rules('oferta_text', 'lang:oferta_text', 'trim');

		/*
		if we've posted already, get the photo stuff and organize it
		if validation comes back negative, we feed this info back into the system
		if it comes back good, then we send it with the save item
		
		submit button has a value, so we can see when it's posted
		*/
		
		if($duplicate)
		{
			$data['id']	= false;
		}
		if($this->input->post('submit'))
		{
			$data['related_products']	= $this->input->post('related_products');
			$data['product_categories']	= $this->input->post('categories');
			//$data['product_producers']	= $this->input->post('producers');
			//$data['product_colectii']	= $this->input->post('colectii');
			$data['images']				= $this->input->post('images');
			$data['colors_images']				= $this->input->post('colors_images');
			$data['product_files']		= $this->input->post('downloads');
			
		}
		
		if ($this->form_validation->run() == FALSE)
		{
			$this->load->view($this->config->item('admin_folder').'/products/product_form', $data);
		}
		else
		{
			$this->load->helper('text');
			
			//first check the slug field
			$slug = $this->input->post('slug');
			
			//if it's empty assign the name field
			if(empty($slug) || $slug=='')
			{
				$slug = $this->input->post('name');
			}
			
			$slug	= url_title(convert_accented_characters($slug), 'dash', TRUE);
			
			//validate the slug
			$this->load->model('Routes_model');

			if($id)
			{
				$slug		= $this->Routes_model->validate_slug($slug, $product->route_id);
				
				$route_id	= $product->route_id;
				//print_r($route_id);die;
			}
			else
			{
				$slug	= $this->Routes_model->validate_slug($slug);
				
				$route['slug']	= $slug;	
				$route_id	= $this->Routes_model->save($route);
			}

			$save['id']					= $id;
			//$save['sku']				= $this->input->post('sku');
			$save['name']				= $this->input->post('name');
			
			/*if($this->input->post('expire_date'))
			{
				//created_on este de tip datetime
				$save['expire_date'] = format_ydm($this->input->post('expire_date')).' '.$this->input->post('hours').':'.$this->input->post('minutes').':'.$this->input->post('seconds');
				//print_r($data['expire_date']);die;
				
				$save['hours'] = $this->input->post('hours');
				$save['minutes'] = $this->input->post('minutes');
				$save['seconds'] = $this->input->post('seconds');
			}*/
			
			//$save['culoare']				= $this->input->post('culoare');
			$save['seo_title']			= $this->input->post('seo_title');
			$save['meta']				= $this->input->post('meta');
			$save['keywords']		= $this->input->post('keywords');
			$save['description']		= $this->input->post('description');
			$save['info']		= $this->input->post('info');
			$save['excerpt']		= $this->input->post('excerpt');
			//$save['embed']		= $this->input->post('embed');
			
		//	$save['producator']		= $this->input->post('producator');
		//	$save['cod_bare']		= $this->input->post('cod_bare');
			
			/*$save['materiale']			= $this->input->post('materiale');
			$save['dimensiune']			= $this->input->post('dimensiune');
			$save['impachetare']			= $this->input->post('impachetare');
			$save['montaj']			= $this->input->post('montaj');*/
			$save['price']				= $this->input->post('price');
			$save['saleprice']			= $this->input->post('saleprice');
			/*$save['weight']				= $this->input->post('weight');
			$save['volum']				= $this->input->post('volum');*/
			/*$save['track_stock']		= $this->input->post('track_stock');
			$save['fixed_quantity']		= $this->input->post('fixed_quantity');
			$save['quantity']			= $this->input->post('quantity');
			$save['shippable']			= $this->input->post('shippable');
			$save['taxable']			= $this->input->post('taxable');*/
			$save['enabled']			= $this->input->post('enabled');
			//$save['pret_in_site']			= $this->input->post('pret_in_site');
			//$save['transport_gratuit']			= $this->input->post('transport_gratuit');
			//$save['produs_nou']			= $this->input->post('produs_nou');
		//	$save['produs_home']			= $this->input->post('produs_home');
		//	$save['tip_produs']			= $this->input->post('tip_produs');
		//	$save['imagine_site']			= $this->input->post('imagine_site');
			//$save['produs_promotie']			= $this->input->post('produs_promotie');
			//$save['produs_sugerat']			= $this->input->post('produs_sugerat');
			//$save['accesoriu']			= $this->input->post('accesoriu');
			
		//	$save['oferta_titlu']			= $this->input->post('oferta_titlu');
		//	$save['oferta_text']			= $this->input->post('oferta_text');
			
			$post_images				= $this->input->post('images');
			$post_colors_images				= $this->input->post('colors_images');
			
			$save['slug']				= $slug;
			$save['route_id']			= $route_id;
			
			if($primary	= $this->input->post('primary_image'))
			{
				if($post_images)
				{
					foreach($post_images as $key => &$pi)
					{
						if($primary == $key)
						{
							$pi['primary']	= true;
							continue;
						}
					}	
				}
			}
		    $save['images']				= json_encode($post_images);
			
			if($primary2	= $this->input->post('primary_image2'))
			{
				if($post_colors_images)
				{
					foreach($post_colors_images as $ky => &$pi)
					{
						if($primary2 == $ky)
						{
							$pi['primary2']	= true;
							continue;
						}
					}	
				}
			}
		    $save['colors_images']				= json_encode($post_colors_images);
			//print_r($save['colors_images']);die;
			
		    //print_r($_FILES);die;
		   /* if(isset($_FILES['image_list']) && !empty($_FILES['image_list']['name']))
		    {
				//die;
				$config['upload_path']		= 'uploads/products/image_listing';
				$config['allowed_types']	= 'gif|jpg|png';
				$config['max_size']			= $this->config->item('size_limit');
				$config['max_width']		= '150';
				$config['max_height']		= '100';
				$config['encrypt_name']		= true;
				$this->load->library('upload', $config);
				$this->upload->initialize($config); 
				
				$uploaded_image_list	= $this->upload->do_upload('image_list');
				//print_r($uploaded_image_list);die;
				if($id)
				{
					//delete the original file if another is uploaded
					if($uploaded_image_list)
					{
						if($data['image_list'] != '')
						{
							$file = array();
							$file[] = 'uploads/products/image_listing/'.$data['image_list'];
							//delete the existing file if needed
							foreach($file as $f){if(file_exists($f)){@unlink($f);}}
						}
					}
				 }
				if($uploaded_image_list)
				{
					$image_list			= $this->upload->data();
					$save['image_list']	= $image_list['file_name'];
				}
			  }*/
			  
			   if(isset($_FILES['image_detail']) && !empty($_FILES['image_detail']['name']))
		      {//print_r($_FILES['image_detail']);die;
					$config['upload_path']		= 'uploads/products/image_details';
					$config['allowed_types']	= 'gif|jpg|png';
					$config['max_size']			= $this->config->item('size_limit');
					//$config['max_width']		= '980';
					//$config['max_height']		= '530';
					//$config['encrypt_name']		= true;
					$this->load->library('upload', $config);
					$this->upload->initialize($config); 
					
					$uploaded	= $this->upload->do_upload('image_detail');
					if($id)
					{
						//delete the original file if another is uploaded
						if($uploaded)
						{
							if($data['image_detail'] != '')
							{
								$file = array();
								$file[] = 'uploads/products/image_details/'.$data['image_detail'];
								//$file[] = 'uploads/products/image_details/small/'.$data['image_detail'];
								//delete the existing file if needed
								foreach($file as $f){if(file_exists($f)){@unlink($f);}}
							}
						}
					}
					if($uploaded)
					{
						$image_detail			= $this->upload->data();
						$save['image_detail']	= $image_detail['file_name'];
						$this->load->library('image_lib');
						
						//this is the larger image
						$config['image_library'] = 'gd2';
						$config['source_image'] = 'uploads/products/image_details/'.$save['image_detail'];
						$config['new_image']	= 'uploads/products/image_details/small/'.$save['image_detail'];
						$config['maintain_ratio'] = TRUE;
						$config['width'] = 546;
						$config['height'] = 410; //800/600
						$this->image_lib->initialize($config);
						$this->image_lib->resize();
						$this->image_lib->clear();
					 }
			}
			 if(isset($_FILES['image_list']) && !empty($_FILES['image_list']['name']))
		      {//print_r($_FILES['image_detail']);die;
					$config['upload_path']		= 'uploads/products/image_listing';
					$config['allowed_types']	= 'gif|jpg|png';
					$config['max_size']			= $this->config->item('size_limit');
					//$config['max_width']		= '980';
					//$config['max_height']		= '530';
					//$config['encrypt_name']		= true;
					$this->load->library('upload', $config);
					$this->upload->initialize($config); 
					
					$uploaded	= $this->upload->do_upload('image_list');
					if($id)
					{
						//delete the original file if another is uploaded
						if($uploaded)
						{
							if($data['image_list'] != '')
							{
								$file = array();
								$file[] = 'uploads/products/image_listing/'.$data['image_list'];
								//$file[] = 'uploads/products/image_lists/small/'.$data['image_list'];
								//delete the existing file if needed
								foreach($file as $f){if(file_exists($f)){@unlink($f);}}
							}
						}
					}
					if($uploaded)
					{
						$image_list			= $this->upload->data();
						$save['image_list']	= $image_list['file_name'];
						$this->load->library('image_lib');
						
						//this is the larger image
						$config['image_library'] = 'gd2';
						$config['source_image'] = 'uploads/products/image_listing/'.$save['image_list'];
						$config['new_image']	= 'uploads/products/image_listing/small/'.$save['image_list'];
						$config['maintain_ratio'] = TRUE;
						$config['width'] = 365;
						$config['height'] = 274; //800/600
						$this->image_lib->initialize($config);
						$this->image_lib->resize();
						$this->image_lib->clear();
					 }
			    }
			 /* if(isset($_FILES['image_detail']) && !empty($_FILES['image_detail']['name']))
		      {//print_r($_FILES['image_detail']);die;
					$config['upload_path']		= 'uploads/products/image_details/full';
					$config['allowed_types']	= 'gif|jpg|png';
					$config['max_size']			= $this->config->item('size_limit');
					//$config['max_width']		= '980';
					//$config['max_height']		= '530';
					//$config['encrypt_name']		= true;
					$this->load->library('upload', $config);
					$this->upload->initialize($config); 
					
					$uploaded	= $this->upload->do_upload('image_detail');
					if($id)
					{
						//delete the original file if another is uploaded
						if($uploaded)
						{
							if($data['image_detail'] != '')
							{
								$file = array();
								$file[] = 'uploads/products/image_details/full/'.$data['image_detail'];
								$file[] = 'uploads/products/image_details/small/'.$data['image_detail'];
								//delete the existing file if needed
								foreach($file as $f){if(file_exists($f)){@unlink($f);}}
							}
						}
					}
					if($uploaded)
					{
						$image_detail			= $this->upload->data();
						$save['image_detail']	= $image_detail['file_name'];
						
						$this->load->library('image_lib');
						//this is the larger image
						$config['image_library'] = 'gd2';
						$config['source_image'] = 'uploads/products/image_details/full/'.$save['image_detail'];
						$config['new_image']	= 'uploads/products/image_details/small/'.$save['image_detail'];
						$config['maintain_ratio'] = TRUE;
						$config['width'] = 157;
						$config['height'] = 192;
						$this->image_lib->initialize($config);
						$this->image_lib->resize();
						$this->image_lib->clear();
					 }
			    }*/
			
			
				if($this->input->post('related_products'))
				{
					$save['related_products'] = json_encode($this->input->post('related_products'));
				}
				else
				{
					$save['related_products'] = '';
				}
				
				//save categories
				$categories			= $this->input->post('categories');
				if(!$categories)
				{
					$categories	= array();
				}
				
				//save producers
				/*$producers			= $this->input->post('producers');
				if(!$producers)
				{
					$producers	= array();
				}*/
				
				//save colectii
				/*$colectii			= $this->input->post('colectii');
				if(!$colectii)
				{
					$colectii	= array();
				}*/
				
				
				//print_r($save);die;
				
				// save product 
				//$product_id	= $this->Product_model->save($save, $options, $categories, $producers, $colectii);
				$product_id	= $this->Product_model->save($save, $categories);
				
				// add file associations
				// clear existsing
				$this->Digital_Product_model->disassociate(false, $product_id);
				// save new
				$downloads = $this->input->post('downloads');
				if(is_array($downloads))
				{
					foreach($downloads as $d)
					{
						$this->Digital_Product_model->associate($d, $product_id);
					}
				}			
	
				//save the route
				$route['id']	= $route_id;
				$route['slug']	= $slug;
				$route['route']	= 'cart/product/'.$product_id;
				
				$this->Routes_model->save($route);
				
				$this->session->set_flashdata('message', lang('message_saved_product'));
	
				//go back to the product list
				redirect($this->config->item('admin_folder').'/products');
		}
	}
	
	function product_image_form()
	{
		$data['file_name'] = false;
		$data['error']	= false;
		$this->load->view($this->config->item('admin_folder').'/products/iframe/product_image_uploader', $data);
	}
	
	function product_image_upload()
	{
		$data['file_name'] = false;
		$data['error']	= false;
		
		$config['allowed_types'] = 'gif|jpg|png';
		//$config['max_size']	= $this->config->item('size_limit');
		$config['upload_path'] = 'uploads/products/galerie_foto/full';
		$config['encrypt_name'] = true;
		$config['remove_spaces'] = true;

		$this->load->library('upload', $config);
		
		if ( $this->upload->do_upload())
		{
			$upload_data	= $this->upload->data();
			
			$this->load->library('image_lib');
			/*
			
			I find that ImageMagick is more efficient that GD2 but not everyone has it
			if your server has ImageMagick then you can change out the line
			
			$config['image_library'] = 'gd2';
			
			with
			
			$config['library_path']		= '/usr/bin/convert'; //make sure you use the correct path to ImageMagic
			$config['image_library']	= 'ImageMagick';
			*/			
			
			//this is the larger image
			$config['image_library'] = 'gd2';
			$config['source_image'] = 'uploads/products/galerie_foto/full/'.$upload_data['file_name'];
			$config['new_image']	= 'uploads/products/galerie_foto/small/'.$upload_data['file_name'];
			$config['maintain_ratio'] = TRUE;
			$config['width'] = 250;
			$config['height'] = 188; //800/600
			$this->image_lib->initialize($config);
			$this->image_lib->resize();
			$this->image_lib->clear();

			//small image
			/*$config['image_library'] = 'gd2';
			$config['source_image'] = 'uploads/images/medium/'.$upload_data['file_name'];
			$config['new_image']	= 'uploads/images/small/'.$upload_data['file_name'];
			$config['maintain_ratio'] = TRUE;
			$config['width'] = 235;
			$config['height'] = 235;
			$this->image_lib->initialize($config); 
			$this->image_lib->resize();
			$this->image_lib->clear();*/

			//cropped thumbnail
			/*$config['image_library'] = 'gd2';
			$config['source_image'] = 'uploads/images/small/'.$upload_data['file_name'];
			$config['new_image']	= 'uploads/images/thumbnails/'.$upload_data['file_name'];
			$config['maintain_ratio'] = TRUE;
			$config['width'] = 150;
			$config['height'] = 150;
			$this->image_lib->initialize($config); 	
			$this->image_lib->resize();	
			$this->image_lib->clear();*/

			$data['file_name']	= $upload_data['file_name'];
		}
		
		if($this->upload->display_errors() != '')
		{
			$data['error'] = $this->upload->display_errors();
		}
		$this->load->view($this->config->item('admin_folder').'/products/iframe/product_image_uploader', $data);
	}
	
	
	function delete_image_detail($id,$image_detail)
    {
		if ($image_detail)
		{
		    $this->db->update('products',array('image_detail'=>''),array('id'=>$id));
			@unlink('uploads/products/image_details/full/' . $image_detail);
			@unlink('uploads/products/image_details/small/' . $image_detail);
			
			$this->session->set_flashdata('message', lang('message_delete_imagine'));
			redirect($this->config->item('admin_folder').'/products/form/'.$id);
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_not_found'));
		}
    }
	
	function delete_image_list($id,$image_list)
    {
		if($image_list)
		{
		    $this->db->update('products',array('image_list'=>''),array('id'=>$id));
			@unlink('uploads/products/image_listing/' . $image_list);
			
			$this->session->set_flashdata('message', lang('message_delete_imagine'));
			redirect($this->config->item('admin_folder').'/products/form/'.$id);
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_not_found'));
		}
    }
	
	function delete($id = false)
	{
		if ($id)
		{	
			$product	= $this->Product_model->get_product($id);
			//if the product does not exist, redirect them to the customer list with an error
			if (!$product)
			{
				$this->session->set_flashdata('error', lang('error_not_found'));
				redirect($this->config->item('admin_folder').'/products');
			}
			else
			{

				// remove the slug
				$this->load->model('Routes_model');
				$this->Routes_model->remove('('.$product->slug.')');

				//if the product is legit, delete them
				$this->Product_model->delete_product($id);

				$this->session->set_flashdata('message', lang('message_deleted_product'));
				redirect($this->config->item('admin_folder').'/products');
			}
		}
		else
		{
			//if they do not provide an id send them to the product list page with an error
			$this->session->set_flashdata('error', lang('error_not_found'));
			redirect($this->config->item('admin_folder').'/products');
		}
	}
	
	
	function colors_images_form()
	{
		$data['file_name'] = false;
		$data['error']	= false;
		$this->load->view($this->config->item('admin_folder').'/products/iframe/colors_images_uploader', $data);
	}
	
	function colors_images_upload()
	{//die('aa');
		$data['file_name'] = false;
		$data['error']	= false;
		
		$config['allowed_types'] = 'gif|jpg|png';
		$config['upload_path'] = 'uploads/products/colors/full';
		$config['encrypt_name'] = true;
		$config['remove_spaces'] = true;

		$this->load->library('upload', $config);
		
		if ( $this->upload->do_upload())
		{
			$upload_data	= $this->upload->data();
			$this->load->library('image_lib');
			
			//this is the larger image
			$config['image_library'] = 'gd2';
			$config['source_image'] = 'uploads/products/colors/full/'.$upload_data['file_name'];
			$config['new_image']	= 'uploads/products/colors/small/'.$upload_data['file_name'];
			$config['maintain_ratio'] = TRUE;
			$config['width'] = 312;
			$config['height'] = 278;
			$this->image_lib->initialize($config);
			$this->image_lib->resize();
			$this->image_lib->clear();

			$data['file_name']	= $upload_data['file_name'];
		}
		
				
		if($this->upload->display_errors() != '')
		{
			$data['error'] = $this->upload->display_errors();
		}
		$this->load->view($this->config->item('admin_folder').'/products/iframe/colors_images_uploader', $data);
	}
	
	function accesories_form($id = false)
	{
		$data['product_list']	= $this->Product_model->get_products();
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('<div class="error">', '</div>');
		$data['page_title']		= lang('product_form');

		//default values are empty if the product is new
		$data['related_products']	= array();
		
		if ($id)
		{	
			$product					= $this->Product_model->get_product($id);
			
			//if the product does not exist, redirect them to the product list with an error
			if (!$product)
			{
				$this->session->set_flashdata('error', lang('error_not_found'));
				redirect($this->config->item('admin_folder').'/products');
			}
			//set values to db values
			$data['id']					= $id;
			//make sure we haven't submitted the form yet before we pull in the images/related products from the database
			if(!$this->input->post('submit'))
			{
				$data['related_products']	= json_decode($product->related_products);
			}
		}
		
		//if $data['related_products'] is not an array, make it one.
		if(!is_array($data['related_products']))
		{
			$data['related_products']	= array();
		}
		
		//no error checking on these
		$this->form_validation->set_rules('caption', 'Caption');
		
		if($this->input->post('submit'))
		{
			//reset the product options that were submitted in the post
			$data['related_products']	= $this->input->post('related_products');
		}
		
		if ($this->form_validation->run() == FALSE)
		{//die;
			$this->load->view($this->config->item('admin_folder').'/products/accesories_form', $data);
		}
		else
		{
				$save['id']					= $id;
				if($this->input->post('related_products'))
				{
					$save['related_products'] = json_encode($this->input->post('related_products'));
				}
				else
				{
					$save['related_products'] = '';
				}
				
				// save product 
				$product_id	= $this->Product_model->save_accesories($save);
				$this->session->set_flashdata('message', lang('message_saved_product'));
				
				//$this->load->view($this->config->item('admin_folder').'/products/accesories_form', $data);
				//go back to the product list
				redirect($this->config->item('admin_folder').'/categories/organize/10');
		}
	}
}
?>