<?php
class Pages extends Admin_Controller
{
	
	function __construct()
	{
		parent::__construct();
		
		force_ssl();

		$this->auth->check_access('Admin', true);
		$this->load->model('Page_model');
		$this->lang->load('page');
		$this->load->helper('form');
		$this->load->library('form_validation');
		$this->lang->load('common');
	}
		
	function index()
	{
		$data['page_title']	= lang('pages');
		$data['pages']		= $this->Page_model->get_pages();
		
		
		$this->load->view($this->config->item('admin_folder').'/pages/pages', $data);
	}
	
	/********************************************************************
	edit page
	********************************************************************/
	function form($id = false)
	{
		/*$config['upload_path']		= 'uploads/pages';
		$config['allowed_types']	= 'gif|jpg|png';
		$config['max_size']			= $this->config->item('size_limit');
		$config['encrypt_name']		= true;
		$this->load->library('upload', $config);*/
		
		$this->load->helper('url');		
		
		//set the default values
		$data['id']			= '';
		$data['title']		= '';
		$data['subtitlu']		= '';
		$data['menu_title']	= '';
		$data['slug']		= '';
		//$data['sequence']	= 0;
		$data['parent_id']	= 0;
		//$data['lang_id']	= 1;
		$data['content']	= '';
		$data['scurta_descriere']	= '';
		$data['seo_title']	= '';
		$data['meta']		= '';
		$data['keywords']		= '';
		$data['image']		= '';
		$data['banner']		= '';
		$data['tip']		= 'page';
		$data['images']				= array();
		
		if($id == '46') //daca este homepage
		{
			$data['rez_titlu1']		= '';
			$data['rez_titlu2']		= '';
			$data['rez_titlu3']		= '';
			$data['rez_titlu4']		= '';
			
			$data['rez_text1']		= '';
			$data['rez_text2']		= '';
			$data['rez_text3']		= '';
			$data['rez_text4']		= '';
			
			$data['categorie_titlu']		= '';
			$data['categorie_text']		= '';
			$data['categorie_link']		= '';
			$data['categorie_image']		= '';
			
			//$data['servicii_image']		= '';
			
			$data['dinsite_titlu']		= '';
			$data['dinsite_subtitlu']		= '';
			$data['dinsite_link']		= '';
			$data['dinsite_titlulink']		= '';
			$data['dinsite_text']		= '';
			
			$data['portofoliu_titlu']		= '';
			$data['portofoliu_text']		= '';
			$data['portofoliu_link']		= '';
			$data['portofoliu_titlulink']		= '';
			
			$data['reclamatii_titlu']		= '';
			$data['reclamatii_subtitlu']		= '';
			$data['reclamatii_telefon']		= '';
			$data['reclamatii_email']		= '';
			$data['reclamatii_text']		= '';
		}
		
		/*$data['adresa']	= '';
		$data['telefon1']	= '';
		$data['telefon2']	= '';
		$data['email']	= '';
		$data['website']	= '';*/
		$data['latitudine']	= '';
		$data['longitudine']	= '';
		
		$data['page_title']	= lang('page_form');
		$data['pages']		= $this->Page_model->get_pages();
		
		if($id)
		{
			
			$page			= $this->Page_model->get_page($id);
			if(!$page)
			{
				//page does not exist
				$this->session->set_flashdata('error', lang('error_page_not_found'));
				redirect($this->config->item('admin_folder').'/pages');
			}
			
			//set values to db values
			$data['id']				= $page->id;
			$data['tip']			= $page->tip;
			$data['parent_id']		= $page->parent_id;
			//$data['lang_id']		= $page->lang_id;
			$data['title']			= $page->title;
			$data['subtitlu']			= $page->subtitlu;
			$data['menu_title']		= $page->menu_title;
			//$data['sequence']		= $page->sequence;
			$data['content']		= $page->content;
			$data['scurta_descriere']		= $page->scurta_descriere;
			$data['seo_title']		= $page->seo_title;
			$data['meta']			= $page->meta;
			$data['keywords']			= $page->keywords;
			$data['slug']			= $page->slug;
			$data['image']			= $page->image;
			$data['banner']			= $page->banner;
			
			/*$data['adresa']		= $page->adresa;
			$data['telefon1']		= $page->telefon1;
			$data['telefon2']		= $page->telefon2;
			$data['email']		= $page->email;
			$data['website']		= $page->website;*/
			$data['latitudine']		= $page->latitudine;
			$data['longitudine']		= $page->longitudine;
			
			if($id == '46') //daca este homepage
			{
				$data['rez_titlu1']		= $page->rez_titlu1;
				$data['rez_titlu2']		= $page->rez_titlu2;
				$data['rez_titlu3']		= $page->rez_titlu3;
				$data['rez_titlu4']		= $page->rez_titlu4;
				
				$data['rez_text1']		= $page->rez_text1;
				$data['rez_text2']		= $page->rez_text2;
				$data['rez_text3']		= $page->rez_text3;
				$data['rez_text4']		= $page->rez_text4;
				
				$data['categorie_titlu']		= $page->categorie_titlu;
				$data['categorie_text']		= $page->categorie_text;
				$data['categorie_link']		= $page->categorie_link;
				$data['categorie_image']		= $page->categorie_image;
				
				//$data['servicii_image']		= $page->servicii_image;
				
				$data['dinsite_titlu']		= $page->dinsite_titlu;
				$data['dinsite_link']		= $page->dinsite_link;
				$data['dinsite_titlulink']		= $page->dinsite_titlulink;
				$data['dinsite_subtitlu']		= $page->dinsite_subtitlu;
				$data['dinsite_text']		= $page->dinsite_text;
				
				$data['reclamatii_titlu']		= $page->reclamatii_titlu;
				$data['reclamatii_subtitlu']		= $page->reclamatii_subtitlu;
				$data['reclamatii_telefon']		= $page->reclamatii_telefon;
				$data['reclamatii_email']		= $page->reclamatii_email;
				$data['reclamatii_text']		= $page->reclamatii_text;
								
				$data['portofoliu_titlu']		= $page->portofoliu_titlu;
				$data['portofoliu_text']		= $page->portofoliu_text;
				$data['portofoliu_link']		= $page->portofoliu_link;
				$data['portofoliu_titlulink']		= $page->portofoliu_titlulink;
			}
			
			//make sure we haven't submitted the form yet before we pull in the images/related products from the database
			if(!$this->input->post('submit'))
			{
				$data['images']				= (array)json_decode($page->images);
			}
		}
		
		$this->form_validation->set_rules('title', 'lang:title', 'trim|required');
		//$this->form_validation->set_rules('subtitlu', 'Subtitlu', 'trim');
		$this->form_validation->set_rules('menu_title', 'lang:menu_title', 'trim');
		$this->form_validation->set_rules('slug', 'lang:slug', 'trim');
		$this->form_validation->set_rules('seo_title', 'lang:seo_title', 'trim');
		$this->form_validation->set_rules('meta', 'lang:meta', 'trim');
		$this->form_validation->set_rules('keywords', 'lang:keywords', 'trim');
		//$this->form_validation->set_rules('sequence', 'lang:sequence', 'trim|integer');
		$this->form_validation->set_rules('parent_id', 'lang:parent_id', 'trim|integer');
		//$this->form_validation->set_rules('lang_id', 'lang:lang_id', 'trim|integer');
		$this->form_validation->set_rules('content', 'lang:content', 'trim');
		$this->form_validation->set_rules('scurta_descriere', 'lang:scurta_descriere', 'trim');
		$this->form_validation->set_rules('image', 'lang:image', 'trim');
		$this->form_validation->set_rules('banner', 'lang:banner', 'trim');
		
		$this->form_validation->set_rules('rez_titlu1', 'Rezultat 1', 'trim|numeric');
		$this->form_validation->set_rules('rez_titlu2', 'Rezultat 2', 'trim|numeric');
		$this->form_validation->set_rules('rez_titlu3', 'Rezultat 3', 'trim|numeric');
		$this->form_validation->set_rules('rez_titlu4', 'Rezultat 4', 'trim|numeric');
		
		
		if($this->input->post('submit'))
		{
			//reset the product forms that were submitted in the post
			$data['images']				= $this->input->post('images');
		}
		// Validate the form
		if($this->form_validation->run() == false)
		{
			$data['error'] = validation_errors();
			$this->load->view($this->config->item('admin_folder').'/pages/page_form', $data);
		}
		else
		{
			$this->load->helper('text');
			
			//first check the slug field
			$slug = $this->input->post('slug');
			
			//if it's empty assign the name field
			if(empty($slug) || $slug=='')
			{
				$slug = $this->input->post('title');
			}
			
			$slug	= url_title(convert_accented_characters($slug), 'dash', TRUE);
			
			//validate the slug
			$this->load->model('Routes_model');
			if($id)
			{
				$slug		= $this->Routes_model->validate_slug($slug, $page->route_id);
				$route_id	= $page->route_id;
			}
			else
			{
				$slug			= $this->Routes_model->validate_slug($slug);
				$route['slug']	= $slug;	
				$route_id		= $this->Routes_model->save($route);
			}
			
			$save = array();
			$save['id']			= $id;
			$save['parent_id']	= $this->input->post('parent_id');
			//$save['lang_id']	= $this->input->post('lang_id');
			$save['title']		= $this->input->post('title');
			$save['subtitlu']		= $this->input->post('subtitlu');
			$save['menu_title']	= $this->input->post('menu_title'); 
			//$save['sequence']	= $this->input->post('sequence');
			$save['content']	= $this->input->post('content');
			$save['scurta_descriere']	= $this->input->post('scurta_descriere');
			$save['seo_title']	= $this->input->post('seo_title');
			$save['meta']		= $this->input->post('meta');
			$save['keywords']		= $this->input->post('keywords');
			$save['route_id']	= $route_id;
			$save['slug']		= $slug;
			$save['tip']		= $this->input->post('tip'); 
			//$save['image']		=  $this->input->post('image');
			//$save['banner']		=  $this->input->post('banner');
			
			/*$save['adresa']		= $this->input->post('adresa');
			$save['telefon1']		= $this->input->post('telefon1');
			$save['telefon2']		= $this->input->post('telefon2');
			$save['email']		= $this->input->post('email');
			$save['website']		= $this->input->post('website');*/
			$save['latitudine']		= $this->input->post('latitudine');
			$save['longitudine']		= $this->input->post('longitudine');
			
			if($id == '46') //daca este homepage
			{
				$save['rez_titlu1']		= $this->input->post('rez_titlu1');
				$save['rez_titlu2']		= $this->input->post('rez_titlu2');
				$save['rez_titlu3']		= $this->input->post('rez_titlu3');
				$save['rez_titlu4']		= $this->input->post('rez_titlu4');
				
				$save['rez_text1']		= $this->input->post('rez_text1');
				$save['rez_text2']		= $this->input->post('rez_text2');
				$save['rez_text3']		= $this->input->post('rez_text3');
				$save['rez_text4']		= $this->input->post('rez_text4');
				
				$save['categorie_titlu']		= $this->input->post('categorie_titlu');
				$save['categorie_text']		= $this->input->post('categorie_text');
				$save['categorie_link']		= $this->input->post('categorie_link');
				if(isset($_FILES['categorie_image']) && !empty($_FILES['categorie_image']['name']))
				{
					//die;
					$config['upload_path']		= 'uploads/pages/categorie_images';
					$config['allowed_types']	= 'gif|jpg|png|jpeg';
					$config['max_size']			= $this->config->item('size_limit');
					//$config['max_width']		= '1920';
					//$config['max_height']		= '550';
					$config['encrypt_name']		= true;
					$this->load->library('upload', $config);
					$this->upload->initialize($config); 
					
					$uploaded_categorie_image	= $this->upload->do_upload('categorie_image');
					//print_r($uploaded_categorie_image);die;
					if($id)
					{
						//delete the original file if another is uploaded
						if($uploaded_categorie_image)
						{
							if($data['categorie_image'] != '')
							{
								$file = array();
								$file[] = 'uploads/pages/categorie_images/'.$data['categorie_image'];
								//delete the existing file if needed
								foreach($file as $f){if(file_exists($f)){@unlink($f);}}
							}
						}
					 }
					if($uploaded_categorie_image)
					{
						$categorie_image			= $this->upload->data();
						$save['categorie_image']	= $categorie_image['file_name'];
					}
				}
				
				
				/*if(isset($_FILES['servicii_image']) && !empty($_FILES['servicii_image']['name']))
				{
					$config['upload_path']		= 'uploads/pages/servicii_images';
					$config['allowed_types']	= 'gif|jpg|png|jpeg';
					$config['max_size']			= $this->config->item('size_limit');
					$config['encrypt_name']		= true;
					$this->load->library('upload', $config);
					$this->upload->initialize($config); 
					
					$uploaded_servicii_image	= $this->upload->do_upload('servicii_image');
					if($id)
					{
						if($uploaded_servicii_image)
						{
							if($data['servicii_image'] != '')
							{
								$file = array();
								$file[] = 'uploads/pages/servicii_images/'.$data['servicii_image'];
								foreach($file as $f){if(file_exists($f)){@unlink($f);}}
							}
						}
					 }
					if($uploaded_servicii_image)
					{
						$servicii_image			= $this->upload->data();
						$save['servicii_image']	= $servicii_image['file_name'];
					}
				}*/
				
				$save['dinsite_titlu']		= $this->input->post('dinsite_titlu');
				$save['dinsite_subtitlu']		= $this->input->post('dinsite_subtitlu');
				$save['dinsite_link']		= $this->input->post('dinsite_link');
				$save['dinsite_titlulink']		= $this->input->post('dinsite_titlulink');
				$save['dinsite_text']		= $this->input->post('dinsite_text');
				
				$save['reclamatii_titlu']		= $this->input->post('reclamatii_titlu');
				$save['reclamatii_subtitlu']		= $this->input->post('reclamatii_subtitlu');
				$save['reclamatii_telefon']		= $this->input->post('reclamatii_telefon');
				$save['reclamatii_email']		= $this->input->post('reclamatii_email');
				$save['reclamatii_text']		= $this->input->post('reclamatii_text');
				
				$save['portofoliu_titlu']		= $this->input->post('portofoliu_titlu');
				$save['portofoliu_text']		= $this->input->post('portofoliu_text');
				$save['portofoliu_link']		= $this->input->post('portofoliu_link');
				$save['portofoliu_titlulink']		= $this->input->post('portofoliu_titlulink');
			}
			
			//set the menu title to the page title if if is empty
			if ($save['menu_title'] == '')
			{
				$save['menu_title']	= $this->input->post('title');
			}
			
			$post_images				= $this->input->post('images');
			if($primary	= $this->input->post('primary_image'))
			{
				if($post_images)
				{
					foreach($post_images as $key => &$pi)
					{
						if($primary == $key)
						{
							$pi['primary']	= true;
							continue;
						}
					}	
				}
				
			}
			$save['images']				= json_encode($post_images);
			
			if(isset($_FILES['banner']) && !empty($_FILES['banner']['name']))
		    {
				//die;
				$config['upload_path']		= 'uploads/pages/banners';
				$config['allowed_types']	= 'gif|jpg|png|jpeg';
				$config['max_size']			= $this->config->item('size_limit');
				//$config['max_width']		= '1920';
				//$config['max_height']		= '1200';
				$config['encrypt_name']		= true;
				$this->load->library('upload', $config);
				$this->upload->initialize($config); 
				
				$uploaded_banner	= $this->upload->do_upload('banner');
				//print_r($uploaded_banner);die;
				if($id)
				{
					//delete the original file if another is uploaded
					if($uploaded_banner)
					{
						if($data['banner'] != '')
						{
							$file = array();
							$file[] = 'uploads/pages/banners/'.$data['banner'];
							//delete the existing file if needed
							foreach($file as $f){if(file_exists($f)){@unlink($f);}}
						}
					}
				 }
				if($uploaded_banner)
				{
					$banner			= $this->upload->data();
					$save['banner']	= $banner['file_name'];
				}
			}
			
			if(isset($_FILES['image']) && !empty($_FILES['image']['name']))
		    {
				$config['upload_path']		= 'uploads/pages/images';
				$config['allowed_types']	= 'gif|jpg|png|jpeg';
				$config['max_size']			= $this->config->item('size_limit');
				//$config['max_width']		= '1140';
				//$config['max_height']		= '400';
				$config['encrypt_name']		= true;
				$this->load->library('upload', $config);
				$this->upload->initialize($config); 
				
				$uploaded	= $this->upload->do_upload('image');
				if($id)
				{
					//delete the original file if another is uploaded
					if($uploaded)
					{
						if($data['image'] != '')
						{
							$file = array();
							$file[] = 'uploads/pages/images/'.$data['image'];
							$file[] = 'uploads/pages/images/small/'.$data['image'];
							//delete the existing file if needed
							foreach($file as $f){if(file_exists($f)){@unlink($f);}}
						}
					}
				}
				if($uploaded)
				{
					$image			= $this->upload->data();
					$save['image']	= $image['file_name'];
					
					$this->load->library('image_lib');
					//this is the larger image
					$config['image_library'] = 'gd2';
					$config['source_image'] = 'uploads/pages/images/'.$save['image'];
					$config['new_image']	= 'uploads/pages/images/small/'.$save['image'];
					$config['maintain_ratio'] = TRUE;
					$config['width'] = 1920;
					$config['height'] = 1000;
					$this->image_lib->initialize($config);
					$this->image_lib->resize();
					$this->image_lib->clear();
				 }
			}
			
			//save the page
			$page_id	= $this->Page_model->save($save);
			
			//save the route
			$route['id']	= $route_id;
			$route['slug']	= $slug;
			$route['route']	= 'cart/page/'.$page_id;
			
			$this->Routes_model->save($route);
			
			$this->session->set_flashdata('message', lang('message_saved_page'));
			
			//go back to the page list
			redirect($this->config->item('admin_folder').'/pages');
		}
	}
	
	function link_form($id = false)
	{
	
		$this->load->helper('url');
		$this->load->helper('form');
		$this->load->library('form_validation');
		
		//set the default values
		$data['id']			= '';
		$data['tip']			= 'link';
		$data['title']		= '';
		$data['url']		= '';
		$data['new_window']	= false;
		//$data['sequence']	= 0;
		$data['parent_id']	= 0;

		
		$data['page_title']	= lang('link_form');
		$data['pages']		= $this->Page_model->get_pages();
		if($id)
		{
			$page			= $this->Page_model->get_page($id);

			if(!$page)
			{
				//page does not exist
				$this->session->set_flashdata('error', lang('error_link_not_found'));
				redirect($this->config->item('admin_folder').'/pages');
			}
			
			
			//set values to db values
			$data['id']			= $page->id;
			$data['tip']			= $page->tip;
			$data['parent_id']	= $page->parent_id;
			$data['title']		= $page->title;
			$data['url']		= $page->url;
			$data['new_window']	= (bool)$page->new_window;
			//$data['sequence']	= $page->sequence;
		}
		
		$this->form_validation->set_rules('title', 'lang:title', 'trim|required');
		$this->form_validation->set_rules('url', 'lang:url', 'trim|required');
	//	$this->form_validation->set_rules('sequence', 'lang:sequence', 'trim|integer');
		$this->form_validation->set_rules('new_window', 'lang:new_window', 'trim|integer');
		$this->form_validation->set_rules('parent_id', 'lang:parent_id', 'trim|integer');
		
		// Validate the form
		if($this->form_validation->run() == false)
		{
			$this->load->view($this->config->item('admin_folder').'/pages/link_form', $data);
		}
		else
		{	
			$save = array();
			$save['id']			= $id;
			$save['parent_id']	= $this->input->post('parent_id');
			$save['title']		= $this->input->post('title');
			$save['menu_title']	= $this->input->post('title'); 
			$save['url']		= $this->input->post('url');
		//	$save['sequence']	= $this->input->post('sequence');
			$save['new_window']	= $this->input->post('new_window');
			$save['tip']		= $this->input->post('tip'); 
			
			//save the page
			$this->Page_model->save($save);
			
			$this->session->set_flashdata('message', lang('message_saved_link'));
			
			//go back to the page list
			redirect($this->config->item('admin_folder').'/pages');
		}
	}
	
	
	function delete_image($id,$image)
    {
		if ($image)
		{
		    $this->db->update('pages',array('image'=>''),array('id'=>$id));
			@unlink('uploads/pages/images/' . $image);
			@unlink('uploads/pages/images/small/' . $image);
			
			$this->session->set_flashdata('message', lang('message_delete_imagine'));
			redirect($this->config->item('admin_folder').'/pages/form/'.$id);
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_not_found'));
		}
    }
	
	function delete_banner($id,$banner)
    {
		if($banner)
		{
		    $this->db->update('pages',array('banner'=>''),array('id'=>$id));
			@unlink('uploads/pages/banners/' . $banner);
			
			$this->session->set_flashdata('message', lang('message_delete_banner'));
			redirect($this->config->item('admin_folder').'/pages/form/'.$id);
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_not_found'));
		}
    }
	
	function delete_categorie_image($id,$categorie_image)
    {
		if($categorie_image)
		{
		    $this->db->update('pages',array('categorie_image'=>''),array('id'=>$id));
			@unlink('uploads/pages/categorie_images/' . $categorie_image);
			
			$this->session->set_flashdata('message', lang('message_delete_imagine'));
			redirect($this->config->item('admin_folder').'/pages/form/'.$id);
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_not_found'));
		}
    }
	
	function delete_servicii_image($id,$servicii_image)
    {
		if($servicii_image)
		{
		    $this->db->update('pages',array('servicii_image'=>''),array('id'=>$id));
			@unlink('uploads/pages/servicii_images/' . $servicii_image);
			
			$this->session->set_flashdata('message', lang('message_delete_imagine'));
			redirect($this->config->item('admin_folder').'/pages/form/'.$id);
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_not_found'));
		}
    }
	
	
	
	
	/********************************************************************
	delete page
	********************************************************************/
	function delete($id)
	{
		
		$page	= $this->Page_model->get_page($id);
		
		if($page)
		{
			$this->load->model('Routes_model');
			
			$this->Routes_model->delete($page->route_id);
			$this->Page_model->delete_page($id);
			$this->session->set_flashdata('message', lang('message_deleted_page'));
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_page_not_found'));
		}
		
		redirect($this->config->item('admin_folder').'/pages');
	}
	
	/*function organize()
	{
		$pages	= $this->input->post('pages');
		$this->Page_model->organize($pages,$parent_id);
	}*/
	
	function move($id,$direction)
	{
		$sequence=$this->Page_model->get_sequence($id);
		$target=$this->Page_model->get_target_sequence($direction,$sequence);
		if($target==NULL) header('location:'.$this->config->item('base_url').'/admin/pages');
		else 
			{
				$this->Page_model->move($sequence,$target);
				header('location:'.$this->config->item('base_url').'/admin/pages');
			}
	}
	
	function page_image_form()
	{
		$data['file_name'] = false;
		$data['error']	= false;
		$this->load->view($this->config->item('admin_folder').'/pages/iframe/page_image_uploader', $data);
	}
	
	function page_image_upload()
	{
		$data['file_name'] = false;
		$data['error']	= false;
		
		$config['allowed_types'] = 'gif|jpg|png';
		//$config['max_size']	= $this->config->item('size_limit');
		$config['upload_path'] = 'uploads/pages/galerie_foto/full';
		$config['encrypt_name'] = true;
		$config['remove_spaces'] = true;

		$this->load->library('upload', $config);
		
		if ( $this->upload->do_upload())
		{
			$upload_data	= $this->upload->data();
			
			$this->load->library('image_lib');
			/*
			
			I find that ImageMagick is more efficient that GD2 but not everyone has it
			if your server has ImageMagick then you can change out the line
			
			$config['image_library'] = 'gd2';
			
			with
			
			$config['library_path']		= '/usr/bin/convert'; //make sure you use the correct path to ImageMagic
			$config['image_library']	= 'ImageMagick';
			*/			
			
			//this is the larger image
			$config['image_library'] = 'gd2';
			$config['source_image'] = 'uploads/pages/galerie_foto/full/'.$upload_data['file_name'];
			$config['new_image']	= 'uploads/pages/galerie_foto/small/'.$upload_data['file_name'];
			$config['maintain_ratio'] = TRUE;
			$config['width'] = 197;
			$config['height'] = 148; //800/600
			$this->image_lib->initialize($config);
			$this->image_lib->resize();
			$this->image_lib->clear();

			//small image
			/*$config['image_library'] = 'gd2';
			$config['source_image'] = 'uploads/pages/images/medium/'.$upload_data['file_name'];
			$config['new_image']	= 'uploads/pages/images/small/'.$upload_data['file_name'];
			$config['maintain_ratio'] = TRUE;
			$config['width'] = 235;
			$config['height'] = 235;
			$this->image_lib->initialize($config); 
			$this->image_lib->resize();
			$this->image_lib->clear();*/

			//cropped thumbnail
			/*$config['image_library'] = 'gd2';
			$config['source_image'] = 'uploads/pages/images/small/'.$upload_data['file_name'];
			$config['new_image']	= 'uploads/pages/images/thumbnails/'.$upload_data['file_name'];
			$config['maintain_ratio'] = TRUE;
			$config['width'] = 150;
			$config['height'] = 150;
			$this->image_lib->initialize($config); 	
			$this->image_lib->resize();	
			$this->image_lib->clear();*/

			$data['file_name']	= $upload_data['file_name'];
		}
		
		if($this->upload->display_errors() != '')
		{
			$data['error'] = $this->upload->display_errors();
		}
		$this->load->view($this->config->item('admin_folder').'/pages/iframe/page_image_uploader', $data);
	}
	
	function formular($id = false)
	{
		$this->page_id	= $id;
		$this->load->library('form_validation');
		$this->load->model(array('Form_model'));
		$this->form_validation->set_error_delimiters('<div class="error">', '</div>');
		
		$data['page_title']		= lang('page_form');

		//default values are empty if the page is new
		//$data['id']					= '';

		if ($id)
		{	
			// get page & forms data
			$data['page_forms']	= $this->Form_model->get_page_forms($id);
			$page			= $this->Page_model->get_page($id);
			//if the page does not exist, redirect them to the page list with an error
			if (!$page)
			{
				$this->session->set_flashdata('error', lang('error_not_found'));
				redirect($this->config->item('admin_folder').'/pages');
			}
			//set values to db values
			$data['id']					= $id;
		}
		
		//no error checking on these
		$this->form_validation->set_rules('caption', 'Caption');

		if($this->input->post('submit'))
		{
			//reset the page forms that were submitted in the post
			$data['page_forms']	= $this->input->post('form');
		}
		
		if ($this->form_validation->run() == FALSE)
		{
			$this->load->view($this->config->item('admin_folder').'/pages/formular', $data);
		}
		else
		{
			$save['id']					= $id;
			// format forms
			$forms	= array();
			if($this->input->post('form'))
			{
				//print_r($this->input->post('form'));die;
				foreach ($this->input->post('form') as $keey => $form)
				{
					$forms[]	= $form;
				}
			}	
			// save page 
			///$page_id	= $this->page_model->save($save, $forms,false);
			$this->Page_model->save_formular($save, $forms);
			$this->session->set_flashdata('message', lang('message_saved_page'));
	
			//go back to the page list
			redirect($this->config->item('admin_folder').'/pages');
		}
	}

}	
?>