<?php
class branduri extends Admin_Controller
{
	
	function __construct()
	{
		parent::__construct();
		
		force_ssl();

		$this->auth->check_access('Admin', true);
		$this->load->model('brand_model');
		$this->lang->load('brand');
		$this->load->helper('form');
		$this->load->library('form_validation');
		$this->lang->load('common');
	}
		
	function index()
	{
		$data['page_title']	= lang('branduri');
		//$data['branduri']		= $this->brand_model->get_branduri();
		$data['branduri']		= $this->brand_model->get_branduri_multilingv(0,1);
		
		
		$this->load->view($this->config->item('admin_folder').'/branduri/branduri', $data);
	}
	
	/********************************************************************
	edit brand
	********************************************************************/
	function form($id = false)
	{
		/*$config['upload_path']		= 'uploads/branduri';
		$config['allowed_types']	= 'gif|jpg|png';
		$config['max_size']			= $this->config->item('size_limit');
		$config['encrypt_name']		= true;
		$this->load->library('upload', $config);*/
		
		$this->load->helper('url');		
		
		//set the default values
		$data['id']			= '';
		$data['title']		= '';
		//$data['subtitlu']		= '';
		$data['menu_title']	= '';
		$data['slug']		= '';
		//$data['sequence']	= 0;
		$data['parent_id']	= 0;
		$data['lang_id']	= 1;
		$data['content']	= '';
		$data['scurta_descriere']	= '';
		$data['seo_title']	= '';
		$data['meta']		= '';
		$data['keywords']		= '';
		$data['image']		= '';
		$data['banner']		= '';
		$data['tip']		= 'brand';
		$data['images']				= array();
		
		$data['page_title']	= lang('brand_form');
		$data['branduri']		= $this->brand_model->get_branduri_multilingv(0,1);
		
		if($id)
		{
			
			$brand			= $this->brand_model->get_brand($id);
			if(!$brand)
			{
				//brand does not exist
				$this->session->set_flashdata('error', lang('error_brand_not_found'));
				redirect($this->config->item('admin_folder').'/branduri');
			}
			
			//set values to db values
			$data['id']				= $brand->id;
			$data['tip']			= $brand->tip;
			$data['parent_id']		= $brand->parent_id;
			$data['lang_id']		= $brand->lang_id;
			$data['title']			= $brand->title;
			//$data['subtitlu']			= $brand->subtitlu;
			$data['menu_title']		= $brand->menu_title;
			//$data['sequence']		= $brand->sequence;
			$data['content']		= $brand->content;
			$data['scurta_descriere']		= $brand->scurta_descriere;
			$data['seo_title']		= $brand->seo_title;
			$data['meta']			= $brand->meta;
			$data['keywords']			= $brand->keywords;
			$data['slug']			= $brand->slug;
			$data['image']			= $brand->image;
			$data['banner']			= $brand->banner;
			
			//make sure we haven't submitted the form yet before we pull in the images/related products from the database
			if(!$this->input->post('submit'))
			{
				$data['images']				= (array)json_decode($brand->images);
			}
		}
		
		$this->form_validation->set_rules('title', 'lang:title', 'trim|required');
		$this->form_validation->set_rules('menu_title', 'lang:menu_title', 'trim');
		//$this->form_validation->set_rules('subtitlu', 'Subtitlu', 'trim');
		$this->form_validation->set_rules('slug', 'lang:slug', 'trim');
		$this->form_validation->set_rules('seo_title', 'lang:seo_title', 'trim');
		$this->form_validation->set_rules('meta', 'lang:meta', 'trim');
		$this->form_validation->set_rules('keywords', 'lang:keywords', 'trim');
		//$this->form_validation->set_rules('sequence', 'lang:sequence', 'trim|integer');
		$this->form_validation->set_rules('parent_id', 'lang:parent_id', 'trim|integer');
		$this->form_validation->set_rules('lang_id', 'lang:lang_id', 'trim|integer');
		$this->form_validation->set_rules('content', 'lang:content', 'trim');
		$this->form_validation->set_rules('scurta_descriere', 'lang:scurta_descriere', 'trim');
		$this->form_validation->set_rules('image', 'lang:image', 'trim');
		$this->form_validation->set_rules('banner', 'lang:banner', 'trim');
		
		
		if($this->input->post('submit'))
		{
			//reset the product forms that were submitted in the post
			$data['images']				= $this->input->post('images');
		}
		// Validate the form
		if($this->form_validation->run() == false)
		{
			$data['error'] = validation_errors();
			$this->load->view($this->config->item('admin_folder').'/branduri/brand_form', $data);
		}
		else
		{
			$this->load->helper('text');
			
			//first check the slug field
			$slug = $this->input->post('slug');
			
			//if it's empty assign the name field
			if(empty($slug) || $slug=='')
			{
				$slug = $this->input->post('title');
			}
			
			$slug	= url_title(convert_accented_characters($slug), 'dash', TRUE);
			
			//validate the slug
			$this->load->model('Routes_model');
			if($id)
			{
				$slug		= $this->Routes_model->validate_slug($slug, $brand->route_id);
				$route_id	= $brand->route_id;
			}
			else
			{
				$slug			= $this->Routes_model->validate_slug($slug);
				$route['slug']	= $slug;	
				$route_id		= $this->Routes_model->save($route);
			}
			
			$save = array();
			$save['id']			= $id;
			$save['parent_id']	= $this->input->post('parent_id');
			$save['lang_id']	= $this->input->post('lang_id');
			$save['title']		= $this->input->post('title');
			//$save['subtitlu']		= $this->input->post('subtitlu');
			$save['menu_title']	= $this->input->post('menu_title'); 
			//$save['sequence']	= $this->input->post('sequence');
			$save['content']	= $this->input->post('content');
			$save['scurta_descriere']	= $this->input->post('scurta_descriere');
			$save['seo_title']	= $this->input->post('seo_title');
			$save['meta']		= $this->input->post('meta');
			$save['keywords']		= $this->input->post('keywords');
			$save['route_id']	= $route_id;
			$save['slug']		= $slug;
			$save['tip']		= $this->input->post('tip'); 
			//$save['image']		=  $this->input->post('image');
			//$save['banner']		=  $this->input->post('banner');
			
			//set the menu title to the brand title if if is empty
			if ($save['menu_title'] == '')
			{
				$save['menu_title']	= $this->input->post('title');
			}
			
			$post_images				= $this->input->post('images');
			if($primary	= $this->input->post('primary_image'))
			{
				if($post_images)
				{
					foreach($post_images as $key => &$pi)
					{
						if($primary == $key)
						{
							$pi['primary']	= true;
							continue;
						}
					}	
				}
				
			}
			$save['images']				= json_encode($post_images);
			
			if(isset($_FILES['banner']) && !empty($_FILES['banner']['name']))
		    {
				//die;
				$config['upload_path']		= 'uploads/branduri/banners';
				$config['allowed_types']	= 'gif|jpg|png|jpeg';
				$config['max_size']			= $this->config->item('size_limit');
				//$config['max_width']		= '1920';
				//$config['max_height']		= '600';
				$config['encrypt_name']		= true;
				$this->load->library('upload', $config);
				$this->upload->initialize($config); 
				
				$uploaded_banner	= $this->upload->do_upload('banner');
				//print_r($uploaded_banner);die;
				if($id)
				{
					//delete the original file if another is uploaded
					if($uploaded_banner)
					{
						if($data['banner'] != '')
						{
							$file = array();
							$file[] = 'uploads/branduri/banners/'.$data['banner'];
							//delete the existing file if needed
							foreach($file as $f){if(file_exists($f)){@unlink($f);}}
						}
					}
				 }
				if($uploaded_banner)
				{
					$banner			= $this->upload->data();
					$save['banner']	= $banner['file_name'];
				}
			}
			
			if(isset($_FILES['image']) && !empty($_FILES['image']['name']))
		    {
				$config['upload_path']		= 'uploads/branduri/images';
				$config['allowed_types']	= 'gif|jpg|png|jpeg';
				$config['max_size']			= $this->config->item('size_limit');
				//$config['max_width']		= '980';
				//$config['max_height']		= '530';
				$config['encrypt_name']		= true;
				$this->load->library('upload', $config);
				$this->upload->initialize($config); 
				
				$uploaded	= $this->upload->do_upload('image');
				if($id)
				{
					//delete the original file if another is uploaded
					if($uploaded)
					{
						if($data['image'] != '')
						{
							$file = array();
							$file[] = 'uploads/branduri/images/'.$data['image'];
							$file[] = 'uploads/branduri/images/small/'.$data['image'];
							//delete the existing file if needed
							foreach($file as $f){if(file_exists($f)){@unlink($f);}}
						}
					}
				}
				if($uploaded)
				{
					$image			= $this->upload->data();
					$save['image']	= $image['file_name'];
					
					$this->load->library('image_lib');
					//this is the larger image
					$config['image_library'] = 'gd2';
					$config['source_image'] = 'uploads/branduri/images/'.$save['image'];
					$config['new_image']	= 'uploads/branduri/images/small/'.$save['image'];
					$config['maintain_ratio'] = TRUE;
					$config['width'] = 575;
					$config['height'] = 430; //800/600
					$this->image_lib->initialize($config);
					$this->image_lib->resize();
					$this->image_lib->clear();
				 }
			}
			
			//save the brand
			$brand_id	= $this->brand_model->save($save);
			
			//save the route
			$route['id']	= $route_id;
			$route['slug']	= $slug;
			$route['route']	= 'cart/brand/'.$brand_id;
			
			$this->Routes_model->save($route);
			
			$this->session->set_flashdata('message', lang('message_saved_brand'));
			
			//go back to the brand list
			redirect($this->config->item('admin_folder').'/branduri');
		}
	}
	
	function link_form($id = false)
	{
	
		$this->load->helper('url');
		$this->load->helper('form');
		$this->load->library('form_validation');
		
		//set the default values
		$data['id']			= '';
		$data['tip']			= 'link';
		$data['title']		= '';
		$data['url']		= '';
		$data['new_window']	= false;
		//$data['sequence']	= 0;
		$data['parent_id']	= 0;

		
		$data['page_title']	= lang('link_form');
		$data['branduri']		= $this->brand_model->get_branduri();
		if($id)
		{
			$brand			= $this->brand_model->get_brand($id);

			if(!$brand)
			{
				//brand does not exist
				$this->session->set_flashdata('error', lang('error_link_not_found'));
				redirect($this->config->item('admin_folder').'/branduri');
			}
			
			
			//set values to db values
			$data['id']			= $brand->id;
			$data['tip']			= $brand->tip;
			$data['parent_id']	= $brand->parent_id;
			$data['title']		= $brand->title;
			$data['url']		= $brand->url;
			$data['new_window']	= (bool)$brand->new_window;
			//$data['sequence']	= $brand->sequence;
		}
		
		$this->form_validation->set_rules('title', 'lang:title', 'trim|required');
		$this->form_validation->set_rules('url', 'lang:url', 'trim|required');
	//	$this->form_validation->set_rules('sequence', 'lang:sequence', 'trim|integer');
		$this->form_validation->set_rules('new_window', 'lang:new_window', 'trim|integer');
		$this->form_validation->set_rules('parent_id', 'lang:parent_id', 'trim|integer');
		
		// Validate the form
		if($this->form_validation->run() == false)
		{
			$this->load->view($this->config->item('admin_folder').'/branduri/link_form', $data);
		}
		else
		{	
			$save = array();
			$save['id']			= $id;
			$save['parent_id']	= $this->input->post('parent_id');
			$save['title']		= $this->input->post('title');
			$save['menu_title']	= $this->input->post('title'); 
			$save['url']		= $this->input->post('url');
		//	$save['sequence']	= $this->input->post('sequence');
			$save['new_window']	= $this->input->post('new_window');
			$save['tip']		= $this->input->post('tip'); 
			
			//save the brand
			$this->brand_model->save($save);
			
			$this->session->set_flashdata('message', lang('message_saved_link'));
			
			//go back to the brand list
			redirect($this->config->item('admin_folder').'/branduri');
		}
	}
	
	
	function delete_image($id,$image)
    {
		if ($image)
		{
		    $this->db->update('branduri',array('image'=>''),array('id'=>$id));
			@unlink('uploads/branduri/images/' . $image);
			@unlink('uploads/branduri/images/small/' . $image);
			
			$this->session->set_flashdata('message', lang('message_delete_imagine'));
			redirect($this->config->item('admin_folder').'/branduri/form/'.$id);
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_not_found'));
		}
    }
	
	function delete_banner($id,$banner)
    {
		if($banner)
		{
		    $this->db->update('branduri',array('banner'=>''),array('id'=>$id));
			@unlink('uploads/branduri/banners/' . $banner);
			
			$this->session->set_flashdata('message', lang('message_delete_banner'));
			redirect($this->config->item('admin_folder').'/branduri/form/'.$id);
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_not_found'));
		}
    }
	
	
	/********************************************************************
	delete brand
	********************************************************************/
	function delete($id)
	{
		
		$brand	= $this->brand_model->get_brand($id);
		
		if($brand)
		{
			$this->load->model('Routes_model');
			
			$this->Routes_model->delete($brand->route_id);
			$this->brand_model->delete_brand($id);
			$this->session->set_flashdata('message', lang('message_deleted_brand'));
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_brand_not_found'));
		}
		
		redirect($this->config->item('admin_folder').'/branduri');
	}
	
	/*function organize()
	{
		$branduri	= $this->input->post('branduri');
		$this->brand_model->organize($branduri,$parent_id);
	}*/
	
	function move($id,$direction)
	{
		$sequence=$this->brand_model->get_sequence($id);
		$target=$this->brand_model->get_target_sequence($direction,$sequence);
		if($target==NULL) header('location:'.$this->config->item('base_url').'/admin/branduri');
		else 
			{
				$this->brand_model->move($sequence,$target);
				header('location:'.$this->config->item('base_url').'/admin/branduri');
			}
	}
	
	function brand_image_form()
	{
		$data['file_name'] = false;
		$data['error']	= false;
		$this->load->view($this->config->item('admin_folder').'/branduri/iframe/brand_image_uploader', $data);
	}
	
	function brand_image_upload()
	{
		$data['file_name'] = false;
		$data['error']	= false;
		
		$config['allowed_types'] = 'gif|jpg|png';
		//$config['max_size']	= $this->config->item('size_limit');
		$config['upload_path'] = 'uploads/branduri/galerie_foto/full';
		$config['encrypt_name'] = true;
		$config['remove_spaces'] = true;

		$this->load->library('upload', $config);
		
		if ( $this->upload->do_upload())
		{
			$upload_data	= $this->upload->data();
			
			$this->load->library('image_lib');
			/*
			
			I find that ImageMagick is more efficient that GD2 but not everyone has it
			if your server has ImageMagick then you can change out the line
			
			$config['image_library'] = 'gd2';
			
			with
			
			$config['library_path']		= '/usr/bin/convert'; //make sure you use the correct path to ImageMagic
			$config['image_library']	= 'ImageMagick';
			*/			
			
			//this is the larger image
			$config['image_library'] = 'gd2';
			$config['source_image'] = 'uploads/branduri/galerie_foto/full/'.$upload_data['file_name'];
			$config['new_image']	= 'uploads/branduri/galerie_foto/small/'.$upload_data['file_name'];
			$config['maintain_ratio'] = TRUE;
			$config['width'] = 290;
			$config['height'] = 218; //800/600
			$this->image_lib->initialize($config);
			$this->image_lib->resize();
			$this->image_lib->clear();

			//small image
			/*$config['image_library'] = 'gd2';
			$config['source_image'] = 'uploads/branduri/images/medium/'.$upload_data['file_name'];
			$config['new_image']	= 'uploads/branduri/images/small/'.$upload_data['file_name'];
			$config['maintain_ratio'] = TRUE;
			$config['width'] = 235;
			$config['height'] = 235;
			$this->image_lib->initialize($config); 
			$this->image_lib->resize();
			$this->image_lib->clear();*/

			//cropped thumbnail
			/*$config['image_library'] = 'gd2';
			$config['source_image'] = 'uploads/branduri/images/small/'.$upload_data['file_name'];
			$config['new_image']	= 'uploads/branduri/images/thumbnails/'.$upload_data['file_name'];
			$config['maintain_ratio'] = TRUE;
			$config['width'] = 150;
			$config['height'] = 150;
			$this->image_lib->initialize($config); 	
			$this->image_lib->resize();	
			$this->image_lib->clear();*/

			$data['file_name']	= $upload_data['file_name'];
		}
		
		if($this->upload->display_errors() != '')
		{
			$data['error'] = $this->upload->display_errors();
		}
		$this->load->view($this->config->item('admin_folder').'/branduri/iframe/brand_image_uploader', $data);
	}
	
	function formular($id = false)
	{
		$this->brand_id	= $id;
		$this->load->library('form_validation');
		$this->load->model(array('Form_model'));
		$this->form_validation->set_error_delimiters('<div class="error">', '</div>');
		
		$data['page_title']		= lang('brand_form');

		//default values are empty if the brand is new
		//$data['id']					= '';

		if ($id)
		{	
			// get brand & forms data
			$data['brand_forms']	= $this->Form_model->get_brand_forms($id);
			$brand			= $this->brand_model->get_brand($id);
			//if the brand does not exist, redirect them to the brand list with an error
			if (!$brand)
			{
				$this->session->set_flashdata('error', lang('error_not_found'));
				redirect($this->config->item('admin_folder').'/branduri');
			}
			//set values to db values
			$data['id']					= $id;
		}
		
		//no error checking on these
		$this->form_validation->set_rules('caption', 'Caption');

		if($this->input->post('submit'))
		{
			//reset the brand forms that were submitted in the post
			$data['brand_forms']	= $this->input->post('form');
		}
		
		if ($this->form_validation->run() == FALSE)
		{
			$this->load->view($this->config->item('admin_folder').'/branduri/formular', $data);
		}
		else
		{
			$save['id']					= $id;
			// format forms
			$forms	= array();
			if($this->input->post('form'))
			{
				//print_r($this->input->post('form'));die;
				foreach ($this->input->post('form') as $keey => $form)
				{
					$forms[]	= $form;
				}
			}	
			// save brand 
			///$brand_id	= $this->brand_model->save($save, $forms,false);
			$this->brand_model->save_formular($save, $forms);
			$this->session->set_flashdata('message', lang('message_saved_brand'));
	
			//go back to the brand list
			redirect($this->config->item('admin_folder').'/branduri');
		}
	}

}	
?>