<?php
class banners_left extends Admin_Controller
{
	function __construct()
	{
		parent::__construct();

		force_ssl();
		$this->auth->check_access('Admin', true);
		
		$this->lang->load('banner_left');
		$this->lang->load('common');
		$this->load->model('Banner_left_model');
		$this->load->helper('date');

	}
		
	function index()
	{
		$data['banners_left']		= $this->Banner_left_model->get_banners_left();
		$data['page_title']		= lang('banners_left');
		
		$this->load->view($this->config->item('admin_folder').'/banners_left/banners_left', $data);
	}
	
	function organize()
	{
		$banners_left	= $this->input->post('banners_left');
		$this->Banner_left_model->organize($banners_left);
	}
	
	function delete($id)
	{
		$this->Banner_left_model->delete($id);
		
		$this->session->set_flashdata('message', lang('message_delete_banner'));
		redirect($this->config->item('admin_folder').'/banners_left');
	}
	
	function delete_image($id,$image)
    {
		if ($image)
		{
		    $this->db->update('banners_left',array('image'=>''),array('id'=>$id));
			@unlink('uploads/banners_left/' . $image);
			
			$image_small = 'uploads/banners_left/small/'.$image;
			if(file_exists($image_small))
			{
				@unlink($image_small);
			}
			
			$this->session->set_flashdata('message', lang('message_delete_imagine'));
			redirect($this->config->item('admin_folder').'/banners_left/form/'.$id);
		}
		else
		{
			$this->session->set_flashdata('error', lang('error_not_found'));
		}
    }
	
	/********************************************************************
	this function is called by an ajax script, it re-sorts the banners_left
	********************************************************************/
	
	function form($id = false)
	{
		
		$config['upload_path']		= 'uploads/banners_left';
		$config['allowed_types']	= 'gif|jpg|png|jpeg';
		$config['max_size']			= $this->config->item('size_limit');
		//$config['max_width']		= '290';
		//$config['max_height']		= '204';
		$config['encrypt_name']		= true;
		$this->load->library('upload', $config);
		
		
		$this->load->helper('form');
		$this->load->library('form_validation');
		
		//set the default values
		$data	= array(	 'id'=>$id
							,'title'=>''
							,'enable_on'=>''
							,'disable_on'=>''
							,'image'=>''
							,'link'=>''
							,'text'=>''
							,'shorttext'=>''
							,'subtitlu'=>''
							,'new_window'=>false	
						);
		
		if($id)
		{
			$data				= (array) $this->Banner_left_model->get_banner($id);
			$data['enable_on']	= format_mdy($data['enable_on']);
			$data['disable_on']	= format_mdy($data['disable_on']);
			$data['new_window']	= (bool) $data['new_window'];
			//$data['content']		= $data['content'];
		}
		
		$data['page_title']	= lang('banner_form');
		
		$this->form_validation->set_rules('title', 'lang:title', 'trim|required|full_decode');
		$this->form_validation->set_rules('text', 'lang:text', 'trim');
		$this->form_validation->set_rules('enable_on', 'lang:enable_on', 'trim');
		$this->form_validation->set_rules('disable_on', 'lang:disable_on', 'trim|callback_date_check');
		$this->form_validation->set_rules('image', 'lang:image', 'trim');
		$this->form_validation->set_rules('link', 'lang:link', 'trim');
		$this->form_validation->set_rules('new_window', 'lang:new_window', 'trim');
		
		if ($this->form_validation->run() == false)
		{
			$data['error'] = validation_errors();
			$this->load->view($this->config->item('admin_folder').'/banners_left/banner_form', $data);
		}
		else
		{	
			
			$uploaded	= $this->upload->do_upload('image');
			
			$save['title']			= $this->input->post('title');
			$save['enable_on']		= format_ymd($this->input->post('enable_on'));
			$save['disable_on']		= format_ymd($this->input->post('disable_on'));
			$save['link']			= $this->input->post('link');
			if($this->input->post('new_window')){$save['new_window']		= $this->input->post('new_window');}else{$save['new_window']		= 0;}
			$save['text']	= $this->input->post('text');
			$save['shorttext']	= $this->input->post('shorttext');
			$save['subtitlu']	= $this->input->post('subtitlu');
			
			if ($id)
			{
				$save['id']	= $id;
				
				//delete the original file if another is uploaded
				if($uploaded)
				{//die('aa');
					if($data['image'] != '')
					{
						$file = 'uploads/banners_left/'.$data['image'];
						
						//delete the existing file if needed
						if(file_exists($file))
						{
							@unlink($file);
						}
						
						$file2 = 'uploads/banners_left/small/'.$data['image'];
						
						//delete the existing file if needed
						if(file_exists($file2))
						{
							@unlink($file2);
						}
					}
				}
				
			}
			else
			{
				/*if(!$uploaded)
				{
					$data['error']	= $this->upload->display_errors();
					$this->load->view($this->config->item('admin_folder').'/banners_left/banner_form', $data);
					return; //end script here if there is an error
				}*/
			}
			
			if($uploaded)
			{
				$image			= $this->upload->data();
				$save['image']	= $image['file_name'];
			}
			
			$this->Banner_left_model->save_banner($save);
			
			$this->session->set_flashdata('message', lang('message_banner_saved'));
			
			redirect($this->config->item('admin_folder').'/banners_left');
		}	
	}

	function date_check()
	{
		
		if ($this->input->post('disable_on') != '')
		{
			if (format_ymd($this->input->post('disable_on')) <= format_ymd($this->input->post('enable_on')))
			{
				$this->form_validation->set_message('date_check', lang('date_error'));
				return FALSE;
			}
		}
		
		return TRUE;
	}
}
?>