<?php
class banners_footer extends Admin_Controller
{
	function __construct()
	{
		parent::__construct();

		force_ssl();
		$this->auth->check_access('Admin', true);
		
		$this->lang->load('banner_footer');
		$this->lang->load('common');
		$this->load->model('banner_footer_model');
		$this->load->helper('date');

	}
		
	function index()
	{
		$data['banners_footer']		= $this->banner_footer_model->get_banners_footer();
		$data['page_title']		= lang('banners_footer');
		
		$this->load->view($this->config->item('admin_folder').'/banners_footer/banners_footer', $data);
	}
	
	function organize()
	{
		$banners_footer	= $this->input->post('banners_footer');
		$this->banner_footer_model->organize($banners_footer);
	}
	
	function delete($id)
	{
		$this->banner_footer_model->delete($id);
		
		$this->session->set_flashdata('message', lang('message_delete_banner_footer'));
		redirect($this->config->item('admin_folder').'/banners_footer');
	}
	
	/********************************************************************
	this function is called by an ajax script, it re-sorts the banners_footer
	********************************************************************/
	
	function form($id = false)
	{
		
		$config['upload_path']		= 'uploads/banners_footer';
		$config['allowed_types']	= 'gif|jpg|png|jpeg';
		$config['max_size']			= $this->config->item('size_limit');
		$config['max_width']		= '1920';
		//$config['max_height']		= '600';
		$config['encrypt_name']		= true;
		$this->load->library('upload', $config);
		
		
		$this->load->helper('form');
		$this->load->library('form_validation');
		
		//set the default values
		$data	= array(	 'id'=>$id
							,'title'=>''
							,'titlu'=>''
							,'text'=>''
							,'enable_on'=>''
							,'disable_on'=>''
							,'image'=>''
							,'titlu_link'=>''
							,'link'=>''
							,'new_window'=>false	
						);
		
		if($id)
		{
			$data				= (array) $this->banner_footer_model->get_banner_footer($id);
			$data['enable_on']	= format_mdy($data['enable_on']);
			$data['disable_on']	= format_mdy($data['disable_on']);
			$data['text']	= $data['text'];
			$data['new_window']	= (bool) $data['new_window'];
			
		}
		
		$data['page_title']	= lang('banner_footer_form');
		
		$this->form_validation->set_rules('title', 'lang:title', 'trim|required|full_decode');
		$this->form_validation->set_rules('titlu', 'Titlu', 'trim');
		$this->form_validation->set_rules('enable_on', 'lang:enable_on', 'trim');
		$this->form_validation->set_rules('disable_on', 'lang:disable_on', 'trim|callback_date_check');
		$this->form_validation->set_rules('image', 'lang:image', 'trim');
		$this->form_validation->set_rules('link', 'lang:link', 'trim');
		$this->form_validation->set_rules('new_window', 'lang:new_window', 'trim');
		
		if ($this->form_validation->run() == false)
		{
			$data['error'] = validation_errors();
			$this->load->view($this->config->item('admin_folder').'/banners_footer/banner_footer_form', $data);
		}
		else
		{	
			
			$uploaded	= $this->upload->do_upload('image');
			
			$save['title']			= $this->input->post('title');
			$save['titlu']			= $this->input->post('titlu');
			$save['text']			= $this->input->post('text');
			$save['enable_on']		= format_ymd($this->input->post('enable_on'));
			$save['disable_on']		= format_ymd($this->input->post('disable_on'));
			$save['link']			= $this->input->post('link');
			$save['titlu_link']			= $this->input->post('titlu_link');
			//$save['new_window']		= $this->input->post('new_window');
			if($this->input->post('new_window')){$save['new_window']		= $this->input->post('new_window');}else{$save['new_window']		= 0;}

			if ($id)
			{
				$save['id']	= $id;
				
				//delete the original file if another is uploaded
				if($uploaded)
				{//die('aa');
					if($data['image'] != '')
					{
						$file = 'uploads/banners_footer/'.$data['image'];
						
						//delete the existing file if needed
						if(file_exists($file))
						{
							@unlink($file);
						}
						
						$file2 = 'uploads/banners_footer/small/'.$data['image'];
						
						//delete the existing file if needed
						if(file_exists($file2))
						{
							@unlink($file2);
						}
					}
				}
				
			}
			else
			{
				if(!$uploaded)
				{
					$data['error']	= $this->upload->display_errors();
					$this->load->view($this->config->item('admin_folder').'/banners_footer/banner_footer_form', $data);
					return; //end script here if there is an error
				}
			}
			
			if($uploaded)
			{
				$image			= $this->upload->data();
				$save['image']	= $image['file_name'];
			}
			
			$this->banner_footer_model->save_banner_footer($save);
			
			$this->session->set_flashdata('message', lang('message_banner_footer_saved'));
			
			redirect($this->config->item('admin_folder').'/banners_footer');
		}	
	}

	function date_check()
	{
		
		if ($this->input->post('disable_on') != '')
		{
			if (format_ymd($this->input->post('disable_on')) <= format_ymd($this->input->post('enable_on')))
			{
				$this->form_validation->set_message('date_check', lang('date_error'));
				return FALSE;
			}
		}
		
		return TRUE;
	}
}
?>