<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Adm_newsletter extends Admin_Controller 
{
	function __construct()
	{
			parent::__construct();
			force_ssl();
			$this->auth->check_access('Admin', true);
			$this->lang->load('newsletter');
			$this->lang->load('common');
			
			$this->load->model('newslettermdl');
	
			$this->load->helper('ckeditor');
			//Ckeditor's configuration
			$this->editor['ckeditor'] = array(
					//ID of the textarea that will be replaced
					'id'     =>     'content',     // Must match the textarea's id
					'path'    =>    'js/ckeditor',    // Path to the ckeditor folder relative to index.php
					//Ckfinder's configuration
					'ckfinder' => array(
					'path'    =>    'js/ckfinder',    // Path to the ckeditor folder relative to index.php
					),
					//Optionnal values
					'config' => array(
					'toolbar'     =>     "Full",     //Using the Full toolbar
					'width'     =>     "810px",    //Setting a custom width
					'height'     =>     '200px',    //Setting a custom height
					),
			 );		
	}	
	
	function index()
	{
				$this->session->set_userdata(array('prv_url'=>current_url()));
				$data['page_title']=lang('adm_nwl');
				$this->load->library('pagination');
				$config['base_url']=base_url().$this->uri->segment(1);
				$config['uri_segment'] = "2";
				$config['total_rows']=$this->newslettermdl->total();			
				$config['per_page'] = '1000';
				$config['num_links']='10';
				$this->pagination->initialize($config);		
				$data['items']=$this->newslettermdl->items($config['per_page'],$this->uri->segment(2));
				$this->load->view($this->config->item('admin_folder').'/newsletter/main', $data);
	}
	
	function adauga()
	{
				if($this->form_validation->run('email')==FALSE)
				{
					$data['page_title']=lang('add_abonat_nwl');
					$this->load->view($this->config->item('admin_folder').'/newsletter/add', $data);
				}
				else
				{												
	
					unset($_POST['save']);
					$_POST['time']=time();
					if($this->newslettermdl->add($_POST)) $this->session->set_userdata(array('success'=>lang('add_succes')));
					else $this->session->set_userdata(array('error'=>lang('add_probl')));
					redirect($this->session->userdata('prv_url')); 
				}
	}
	
	function editeaza()
	{
				if($this->form_validation->run('email')==FALSE)
				{
					$data['page_title']=lang('edit_abonat_nwl');;
					$data['item']=$this->newslettermdl->item($this->uri->segment(2));			
					$this->load->view($this->config->item('admin_folder').'/newsletter/edit', $data);
	
				}
				else
				{						
					unset($_POST['save']);
					if($this->newslettermdl->edit($_POST,$this->uri->segment(2))) $this->session->set_userdata(array('success'=>lang('edit_succes')));
					else $this->session->set_userdata(array('error'=>lang('add_probl')));
					redirect($this->session->userdata('prv_url')); 
				}
	}
	
	function export()
	{
				$this->load->helper('csv');
				$result=$this->newslettermdl->all_items();			
				query_to_csv($result, TRUE, 'abonati.csv');
	}
	
	function sterge()
	{
				if($this->newslettermdl->delete($this->uri->segment(2))) $this->session->set_userdata(array('success'=>lang('del_succes')));
				else $this->session->set_userdata(array('error'=>lang('del_probl'))); 
				redirect($this->session->userdata('prv_url'));
	}
	
		
	function trimite()
	{
				if($this->form_validation->run('admin_newsletter')==FALSE)
				{
					$data['page_title']=lang('trim_nwl');
					$this->load->view($this->config->item('admin_folder').'/newsletter/trimite', $data);
				}
				else
				{
					$attach='';
					if($_FILES['atasament']['name']<>''){
						$config['upload_path'] = './uploads/atasamente/';
						$config['allowed_types'] = '*';
						$this->load->library('upload', $config);
						$this->upload->do_upload('atasament');
						$upload_data=$this->upload->data();
						$attach=$upload_data['file_name'];					
					}
					
					$this->load->library('email');
					$this->email->clear(true);
					$config['protocol'] = 'mail';
					$config['mailtype']="html";
					$this->email->initialize($config);		
	
					$emails=$this->newslettermdl->all_items();
					for($i=0;$i<$emails->num_rows;$i++){
						$this->email->clear(true);
						$row=$emails->row($i);								
						
						if($attach!='') $this->email->attach($this->config->item('uploads_path')."uploads/atasamente/".$attach);
						
						$message =$_POST['mesaj'];
						//$this->email->from($this->config->item('email'), 'Newsletter - '.$this->input->post('subiect'))
						$this->email->from($this->config->item('email'), 'Newsletter - '.$this->config->item('company_name'));		                
						$this->email->to($row->email);
						$this->email->subject($this->input->post('subiect'));
						$this->email->message($message);
						$this->email->send();	
						
						//echo $this->email->print_debugger();die;						
					}
	
					$info=array(
								'subiect'=>$this->input->post('subiect'),
								'mesaj'=>$this->input->post('mesaj'),
								'atasament'=>$attach,
								'timp'=>time()
								);
	
					if($this->newslettermdl->add_msg($info)) $this->session->set_userdata(array('success'=>lang('save_succes')));
					else $this->session->set_userdata(array('error'=>lang('save_probl')));
					redirect('admin-arhiva-mesaje');	
				}
	}
	
	
	
	function arhiva()
	{
				$this->session->set_userdata(array('prv_url'=>current_url()));
				$data['page_title']=lang('arhiva_mesaje');
				$data['items']=$this->newslettermdl->msgs();
				$this->load->view($this->config->item('admin_folder').'/newsletter/arhiva', $data);
	}
	
	function edit_mesaj()
	{
				$data['item']=$this->newslettermdl->mesaj($this->uri->segment(2));
				if($this->form_validation->run('admin_newsletter')==FALSE)
				{
					$data['page_title']=lang('edit_nwl');
					$this->load->view($this->config->item('admin_folder').'/newsletter/edit_trimite', $data);
				}
				else
				{
					$attach=$data['item']->atasament;
					if($_FILES['atasament']['name']<>''){
						$config['upload_path'] = './uploads/atasamente/';
						$config['allowed_types'] = '*';
						$this->load->library('upload', $config);
						$this->upload->do_upload('atasament');
						$upload_data=$this->upload->data();
						$attach=$upload_data['file_name'];					
					}
					
					$this->load->library('email');
					$this->email->clear(true);
					$config['protocol'] = 'mail';
					$config['mailtype']="html";
					$this->email->initialize($config);
					
					$emails=$this->newslettermdl->all_items();
					for($i=0;$i<$emails->num_rows;$i++){
						$this->email->clear(true);
						$row=$emails->row($i);					
	
						if($attach!='') $this->email->attach($this->config->item('uploads_path')."uploads/atasamente/".$attach);
						
						$this->email->from($this->config->item('email'), 'Newsletter - '.$this->config->item('company_name'));		                
						$this->email->to($row->email);
						$this->email->subject($this->input->post('subiect'));
						$this->email->message($this->input->post('mesaj'));
						$this->email->send();
						
						//echo $this->email->print_debugger();die;		
					}
	
					$info=array(
								'subiect'=>$this->input->post('subiect'),
								'mesaj'=>$this->input->post('mesaj'),
								'atasament'=>$attach,
								'timp'=>time()
								);
	
					if($this->newslettermdl->edit_msg($info,$this->uri->segment(2))) $this->session->set_userdata(array('success'=>lang('save_succes')));
					else $this->session->set_userdata(array('error'=>lang('save_probl')));
					redirect('admin-arhiva-mesaje');	
			   }
	}
	
	function sterge_mesaj()
	{
				if($this->newslettermdl->sterge_mesaj($this->uri->segment(2))) $this->session->set_userdata(array('success'=>lang('del_msg_succes')));
				else $this->session->set_userdata(array('error'=>lang('del_msg_probl')));
				redirect('admin-arhiva-mesaje');			
	}
	
}

/*

 * End of file adm_newsletter.php

 * Location:./application/controllers/adm_newsletter.php

 */
 ?>