<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Adm_fisiere_branduri extends Admin_Controller 
{

	function __construct(){

		parent::__construct();

        force_ssl();
		$this->auth->check_access('Admin', true);
		$this->load->model('fisiere_brandurimdl');
		$this->lang->load('common');
			
		$this->load->helper('ckeditor');
	        //Ckeditor's configuration
	        $this->editor['ckeditor'] = array(

	            //ID of the textarea that will be replaced
	            'id'     =>     'content',     // Must match the textarea's id
	            'path'    =>    'js/ckeditor',    // Path to the ckeditor folder relative to index.php

	            //Ckfinder's configuration
	            'ckfinder' => array(
	            'path'    =>    'js/ckfinder',    // Path to the ckeditor folder relative to index.php
	            ),
	            //Optionnal values
	            'config' => array(
	                'toolbar'     =>     "Full",     //Using the Full toolbar
	                'width'     =>     "810px",    //Setting a custom width
	                'height'     =>     '200px',    //Setting a custom height
	            ),
	        );
	}	

	

	function index(){

			$this->session->set_userdata(array('prv_url'=>current_url()));

			$data['page_title']="Admin - fisiere";
			$data['items']=$this->fisiere_brandurimdl->items($this->uri->segment(2));
			
			//print_r($data['items']);die;

            $this->load->view($this->config->item('admin_folder').'/fisiere_branduri/main', $data);
	}

	

	function adauga(){


			if($this->form_validation->run('fisier')==FALSE){

				$data['page_title']="Admin - adauga fisier";				

				$this->load->view($this->config->item('admin_folder').'/fisiere_branduri/add', $data);

			}else{

				if($_FILES['fisier']['name']<>''){

	                $config['upload_path'] = './uploads/fisiere2/';

	                $config['allowed_types'] = '*';

	                $this->load->library('upload', $config);

					$this->upload->do_upload('fisier');

					$upload_data=$this->upload->data();

                    $_POST['fisier']=$upload_data['file_name'];					

				}								

				unset($_POST['save']);

				$_POST['id_pagina']=$this->uri->segment(2);

				$_POST['pozitie']=$this->fisiere_brandurimdl->max_pos($this->uri->segment(2))+1;

				if($this->fisiere_brandurimdl->add($_POST)) $this->session->set_userdata(array('success'=>'Fisierul a fost adaugat cu succes!'));

				else $this->session->set_userdata(array('error'=>'A aparut o problema si fisierul nu a fost salvat!'));

				redirect($this->session->userdata('prv_url')); 

			}
		

	}

	

	function editeaza(){


			if($this->form_validation->run('fisier')==FALSE){

				$data['page_title']="Admin editeaza fisier";

				$data['item']=$this->fisiere_brandurimdl->item($this->uri->segment(2));			

				$this->load->view($this->config->item('admin_folder').'/fisiere_branduri/edit', $data);

			}else{

				if($_FILES['fisier']['name']<>''){

					$fisier=$this->config->item('uploads_path')."fisiere2/".$this->fisiere_brandurimdl->item($this->uri->segment(2))->fisier;

					if(is_file($fisier)) unlink($fisier);

					$config['upload_path'] = './uploads/fisiere2/';

	                $config['allowed_types'] = '*';

	                $this->load->library('upload', $config);

					$this->upload->do_upload('fisier');

					$upload_data=$this->upload->data();

                    $_POST['fisier']=$upload_data['file_name'];

				}								

				unset($_POST['save']);

				if($this->fisiere_brandurimdl->edit($_POST,$this->uri->segment(2))) $this->session->set_userdata(array('success'=>'Fisierul a fost editat cu succes!'));

				else $this->session->set_userdata(array('error'=>'A aparut o problema si fisierul nu a fost salvat!'));

				redirect($this->session->userdata('prv_url')); 

			}

	}



	function sterge(){

			if($this->fisiere_brandurimdl->delete($this->uri->segment(2))) $this->session->set_userdata(array('success'=>'Fisierul a fost sters cu succes!'));

			else $this->session->set_userdata(array('error'=>'A aparut o problema si fisierul nu a fost sters!')); 

			redirect($this->session->userdata('prv_url'));
	}

	

	/*function modifica_pozitie(){

			if($this->fisiere_brandurimdl->schimba_pozitie($this->uri->segment(2),$this->uri->segment(3),$this->uri->segment(4))) $this->session->set_userdata(array('success'=>'Status modificat cu succes!'));

			else $this->session->set_userdata(array('error'=>'A aparut o problema si nu s-a putut modifica statusul!')); 

			redirect($this->session->userdata('prv_url'));

	}	*/
	
	function organize()
	{
		$fisiere	= $this->input->post('fisiere');
		
		//print_r($_POST);die;
		$this->fisiere_brandurimdl->organize($fisiere);
	}

	

}

/*

 * End of file adm_fisiere_branduri.php

 * Location:./application/controllers/adm_fisiere_branduri.php

 */